

<?php $__env->startSection('added_css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/datatable/datatables.min.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('chart.js/dist/Chart.min.css')); ?>">
<script src='https://unpkg.com/maplibre-gl@latest/dist/maplibre-gl.js'></script>
<link href='https://unpkg.com/maplibre-gl@latest/dist/maplibre-gl.css' rel='stylesheet' />
<script src="<?php echo e(asset('js/geoportail/mapblibre_animated_popup.js')); ?>"></script>

<style>
    .m-footer {
        color: #ff1308 !important;
        font-weight: 600;
    }

    .small-box>.inner {
        padding: 0.75rem;
    }

    .datatables tr {
        background: #ffffff;
    }

    .small-box {
        margin-bottom: 10px;
    }


    .text-styling {
        font-size: 14px;
        color: #000;

    }

    .text-center {
        font-size: 14px;
        color: #000;
    }


    .table th,
    .table td {
        border-right: 1px solid #f4f4f4;
    }


    .table-striped tbody tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, .05) !important;
    }

    th {
        background-color: unset !important;
    }


    .m-thead {
        font-family: Lato;
        font-weight: 700 !important;
        font-size: 15px !important;
    }


    .m-thead-mobile {
        font-family: Lato;
        font-weight: 600 !important;
        font-size: 13px !important;

    }



    .google_map_btn {
        line-height: 60px;
        height: 60px;
        width: 100%;
        border-radius: 6px;
        border: 2px #93c854 solid;
    }

    .google_map_btn:hover {
        cursor: pointer;
        opacity: 0.6;
        transition: all 0.35s ease-out;
    }

    .google_map_btn.disabled {
        filter: grayscale(1);
        border: 2px gainsboro solid;
    }

    .google_map_label {
        font-family: 'Roboto';
        font-size: 1rem;
        margin: auto;
        display: block;
        text-align: center;
    }

    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {

        margin-bottom: 8px !important;
        margin-top: 8px !important;
        color: #366caf;
    }

    .lot_row_tag {
        right: 0px;
        height: 80px !important;
        width: 24px !important;
        background: #e6e6e6;
        position: absolute;
        border-radius: 0px 6px 6px 0px;
        text-transform: capitalize;
    }

    .lot_row_tag.reserve {
        background: #4bbfc0a6;
    }

    .lot_row_tag.vendu {
        background: #e4562a85;
    }

    .lot_row_tag.libre {
        background: #fff96296;
    }

    thead {
        display: none;
    }


    .dossier_row {
        background: #f1f1f1;
        border-radius: 6px;
        margin: 2px;
        border: 1px #d2d2d2 solid;
        transition: all 0.35s ease-out;
        box-shadow: -1px 1px 3px 1px rgb(0 0 0 / 16%) !important;
    }

    .dossier_row :hover {
        cursor: pointer;
        transition: all 0.35s ease-out;
        background: #E6E3E3;
    }

    .dossier_row_icon {
        font-size: 20px;
        top: calc(50% - 16px);
        position: absolute;
        left: 6px;
        border: 1px #d7d2d2 solid;
        border-radius: 50%;
        padding: 6px;
        color: #7e7e7e;
        background: #f2f2f2;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div id='map' style='margin: -5px -5px 0px -5px !important;width: 100%;height: calc(100%);position:absolute'>
    <div class="side_panel">
        <div class="side-panel-toggle">
            <i class="side-panel-toggle-icon fa-solid fa-chevron-left"></i>
        </div>

        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="dossiers-tab" data-toggle="tab" href="#dossiers" role="tab" aria-controls="dossiers" aria-selected="true"><i class="fa-regular fa-folder-open"></i>&nbspDossier</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="couches-tab" data-toggle="tab" href="#couches" role="tab" aria-controls="couches" aria-selected="false"><i class="fa-solid fa-layer-group"></i>&nbspCouches</a>
            </li>
        </ul>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="dossiers" role="tabpanel" aria-labelledby="dossiers-tab">
                <div class="row">
                    <div class="col" style="flex: 0 0 36px;    padding: 0px 4px;">
                        <button id="v_tab_filters_btn" type="button" class="btn v-tab-btn " style="writing-mode: vertical-rl;text-decoration: none;"><i class="fa-regular fa-filter"></i>&nbsp&nbspFiltres</button>
                        <button id="v_tab_list_btn" type="button" class="btn v-tab-btn active" style="writing-mode: vertical-rl;text-decoration: none;"><i class="fa-solid fa-list"></i>&nbsp&nbspListe des dossiers</button>
                    </div>
                    <div class="col" style="border-left: 1px #c0c0c0 dashed; padding: 0px;">
                        <div class="mtab" id="dossiers_filters_div">
                            <div class="row mt-1">
                                <div class="col-12">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 140px;">Province :</span>
                                        </div>
                                        <select id="provinces_filter" class="form-control select2 m-tout dt_filter" column="province_id" table="">
                                            <option value="all" selected="">Indifferent</option>
                                            <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($province->id); ?>"><?php echo e($province->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 140px;">Cercle :</span>
                                        </div>
                                        <select id="cercles_filter" class="form-control select2 m-tout dt_filter" column="cercle_id" table="">
                                            <option value="all" selected="">Indifferent</option>
                                            <?php $__currentLoopData = $cercles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cercle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($cercle->id); ?>"><?php echo e($cercle->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 140px;">Commune :</span>
                                        </div>
                                        <select id="communes_filter" class="form-control select2 m-tout dt_filter" column="commune_id" table="">
                                            <option value="all" selected="">Indifferent</option>
                                            <?php $__currentLoopData = $communes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($commune->id); ?>"><?php echo e($commune->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 140px;">Douar :</span>
                                        </div>
                                        <select id="douars_filter" class="form-control select2 m-tout dt_filter" column="douar_id" table="">
                                            <option value="all" selected="">Indifferent</option>
                                            <?php $__currentLoopData = $douars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $douar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($douar->id); ?>"><?php echo e($douar->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">

                                            <span class="input-group-text" style="width: 140px;">Déblocage d'aide :</span>
                                        </div>
                                        <select id="aide_frontale_filter" class="form-control select2 m-tout dt_filter" column="aide_frontale" table="">
                                            <option value="all" selected="">Indifferent</option>
                                            <option value="1">Frontale N° 1</option>
                                            <option value="2">Frontale N° 2</option>
                                            <option value="3">Frontale N° 3</option>
                                            <option value="4">Frontale N° 4</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">

                                            <span class="input-group-text" style="width: 140px;">Etat d'avancement :</span>
                                        </div>
                                        <select id="etat_avancement_filter" class="form-control select2 m-tout dt_filter" column="etat_avancement" table="">
                                            <option value="all" selected="">Indifferent</option>
                                            <option value="En cours d'étude">En cours d'étude</option>
                                            <option value="Autorisé">Autorisé</option>
                                            <option value="Travaux Gros œuvres">Travaux Gros œuvres</option>
                                            <option value="Travaux de finition">Travaux de finition</option>
                                        </select>
                                    </div>
                                </div>
                            </div>


                            <div class="row">
                                <div class="col-12">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 140px;">
                                                <input id="date_dossier_from_active" style="vertical-align: middle;position: relative;" type="checkbox">&nbspDate dossier de :
                                            </span>
                                        </div>
                                        <input disabled id="date_dossier_from_filter" class="form-control cdate  " column="dossiers.created_at" table="">

                                        </input>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 140px;">
                                                <input id="date_dossier_to_active" style="vertical-align: middle;position: relative;" type="checkbox">&nbspÀ :
                                            </span>
                                        </div>
                                        <input disabled id="date_dossier_to_filter" class="form-control cdate  " column="dossiers.created_at" table="">

                                        </input>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-2" style="font-family: Roboto;">
                                <div class="col-12">
                                    <input style="vertical-align: middle;" id="permis_habiter_filter" style="margin-left: 12px;" type="checkbox">&nbsp;Permis d'habiter
                                </div>
                            </div>

                            <div class="row mt-1" style="font-family: Roboto;border-top: 1px #d1d1d1 solid;">
                                <div class="col-6">
                                    <button id="filters_tab_apply" type="button" class="btn"><i class="fa-solid fa-check"></i>&nbsp;Appliquer</button>
                                </div>
                                <div class="col-6">
                                    <button id="filters_tab_rest" type="button" class="btn btn-danger"><i class="fa-solid fa-arrows-rotate"></i>&nbsp;Réinitialiser</button>
                                </div>
                            </div>
                        </div>

                        <div class="mtab active" id="dossiers_result_div">

                            <div class="row mt-2 mb-1">                               
                                <div class="col-6">
                                    <div class="input-group">                                         
                                        <select id="dossiers_pagelist" class="form-control select2">                                        
                                        </select>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <span style="margin: 4px 0px 0px 0px; display: inline-block; font-weight: 400; font-family: 'Roboto';">Dossiers :<b id="dossiers_count" style="margin-left:6px;display: inline-block; font-weight: 500; font-family: 'Roboto';color: #128db7;">0</b></span>
                                </div>
                            </div>
                            <div id="dossiers_result_list" style="height: 400px;display: block;overflow-x: hidden;overflow-y:auto">
                                <table style="border: unset;height:100%" class="table datatables dataTable no-footer display nowrap" id="dossiers_table">
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>




            </div>
            <div class="tab-pane fade" id="couches" role="tabpanel" aria-labelledby="couches-tab">
                <h6>&nbsp Couches Google</h6>
                <div class="row mt-1">
                    <div id="baselayer_google_streets" class="google_map_btn disabled" style="background-image: url('images/baselayer_icon_google_map.png');">
                        <!-- <b class="google_map_label">Google Streets</b> -->
                    </div>
                </div>
                <div class="row mt-1">
                    <div id="baselayer_google_hybrid" class="google_map_btn disabled" style="background-image: url('images/baselayer_icon_google_hyb.png');">
                        <!-- <b class="google_map_label">Google Hybrid</b> -->
                    </div>

                </div>
                <div class="row mt-1">
                    <div id="baselayer_google_sat" class="google_map_btn  " style="background-image: url('images/baselayer_icon_google_sat.png');">
                        <!-- <b class="google_map_label">Google Satellite</b> -->
                    </div>

                </div>

                <!-- <h6>Découpage administratif</h6>
                <div class="row" style="font-family: Roboto;">
                    <input id="couche_provinces" style="margin-left: 12px;"   style="vertical-align: middle;position: relative;" type="checkbox">&nbspProvinces
                </div>
                <div class="row" style="font-family: Roboto;">
                    <input id="couche_communes" style="margin-left: 12px;" checked style="vertical-align: middle;position: relative;" type="checkbox">&nbspCommunes
                </div>
                <h6>Douars</h6>
                <div class="row" style="font-family: Roboto;">
                    <input id="couche_douars_centres" style="margin-left: 12px;" checked style="vertical-align: middle;position: relative;" type="checkbox">&nbspCentre
                </div>
                <div class="row" style="font-family: Roboto;">
                    <input  id="couche_douars_limites" style="margin-left: 12px;"  disabled style="vertical-align: middle;position: relative;" type="checkbox">&nbspDélimitation
                </div> -->
                <h6>Dossiers</h6>
                <div class="row" style="font-family: Roboto;">
                    <input id="couche_dossiers_centres" style="margin-left: 12px;" checked style="vertical-align: middle;position: relative;" type="checkbox">&nbspCentre
                </div>
                <div class="row" style="font-family: Roboto;">
                    <input id="couche_dossiers_limites" style="margin-left: 12px;" checked style="vertical-align: middle;position: relative;" type="checkbox">&nbspLimite
                </div>
                <h6>Vue 3D/2D</h6>
                <div class="row" style="font-family: Roboto;">
                    <div class="col">
                        <div id="vue_3d" class="google_map_btn  disabled" style="background-image: url(images/vue_3d.png);background-size: contain;background-repeat: no-repeat;background-position: center;">
                            <b class="google_map_label">3D</b>
                        </div>
                    </div>
                    <div class="col">
                        <div id="vue_2d" class="google_map_btn " style="background-image: url(images/vue_2d.png);">
                            <b class="google_map_label">2D</b>
                        </div>
                    </div>
                </div>



            </div>

        </div>
    </div>
</div>

<script>
    var provinces = <?php echo json_encode($provinces, 15, 512) ?>;
    var cercles = <?php echo json_encode($cercles, 15, 512) ?>;
    var communes = <?php echo json_encode($communes, 15, 512) ?>;
    var douars = <?php echo json_encode($douars, 15, 512) ?>;
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('added_scripts'); ?>
<script src="<?php echo e(asset('js/geoportail/filters.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/geoportail/map.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/geoportail/tab_dossiers.js').'?t='.time()); ?>"></script>
<script>
    $(document).ready(function() {
        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });
    });
</script>


<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/batirc6/public_html/resources/views/geoportail/index.blade.php ENDPATH**/ ?>