
<?php $__env->startSection('added_css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div style="padding-top: 16px;margin-left: 8px;">
    <nav class="hk-breadcrumb" aria-label="breadcrumb">
        <ol class="breadcrumb breadcrumb-light bg-transparent">
            <li class="breadcrumb-item"><a href="<?php echo e(route('demandes')); ?>">Demandes</a></li>
            <?php if($mode=='create'): ?>
            <li class="breadcrumb-item active" aria-current="page">Nouvelle demande</li>
            <?php else: ?>
            <li class="breadcrumb-item active" aria-current="page">Demande N° <?php echo e($demande->numero); ?></li>
            <?php endif; ?>
        </ol>
    </nav>
    <div class="row">
        <div class="col-12 col-md-9 mb-3">
            <div style="margin-top:8px;padding-left: 10px;padding-right: 10px;">
                <h6><i class="fa-solid fa-location-dot"></i>&nbsp Situation de la bâtisse</h6>
                <div class="row">
                    <div class="col-12 col-md-6">

                        <div class="row">
                            <?php if($mode=='create'): ?>
                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Province :</span>
                                        </div>
                                        <select id="province" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($province->id); ?>"><?php echo e($province->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Cercle :</span>
                                        </div>
                                        <select id="cercle" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $cercles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cercle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($cercle->id); ?>"><?php echo e($cercle->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Commune :</span>
                                        </div>
                                        <select id="commune" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $communes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($commune->id); ?>"><?php echo e($commune->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>



                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Douar :</span>
                                        </div>
                                        <select id="douar" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $douars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $douar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($douar->id); ?>"><?php echo e($douar->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 140px;">Province :</span>
                                    </div>
                                    <input readonly class="form-control" value="<?php echo e($demande->province->nom); ?>">
                                </div>
                            </div>

                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 140px;">Cercle :</span>
                                    </div>
                                    <input readonly class="form-control" value="<?php echo e($demande->cercle->nom); ?>">
                                </div>
                            </div>


                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 140px;">Commune :</span>
                                    </div>
                                    <input readonly class="form-control" value="<?php echo e($demande->commune->nom); ?>">
                                </div>
                            </div>

                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 140px;">Douar :</span>
                                    </div>
                                    <input readonly class="form-control" value="<?php echo e(strlen($demande->douar->nom)>0?$demande->douar->nom:$demande->douar->nom_ar); ?>">
                                </div>
                            </div>

                            <?php endif; ?>
                            <hr>

                            <div class="col-12 mt-2" style="font-size: 0.8rem">
                                <i id="etude_geotechnique_status_icon_1" style="color:#759B24;display:none" class="fa-regular fa-square-check"></i>
                                <i id="etude_geotechnique_status_icon_0" style="color:#F44141" class="fa-regular fa-circle-xmark"></i>
                                <span id="etude_geotechnique_status_label" style="color:#F44141">Etude géotechnique</span>
                            </div>

                            <div class="col-12 mt-2" style="font-size: 0.8rem">
                                <i id="stabilisation_sol_status_icon_1" style="color:#759B24;display:none" class="fa-regular fa-square-check"></i>
                                <i id="stabilisation_sol_status_icon_0" style="color:#F44141" class="fa-regular fa-circle-xmark"></i>
                                <span id="stabilisation_sol_status_label" style="color:#F44141">Stabilisation du sol</span>
                            </div>

                            <div class="col-12 mt-2" style="font-size: 0.8rem">
                                <i id="nivellement_sol_status_icon_1" style="color:#759B24;display:none" class="fa-regular fa-square-check"></i>
                                <i id="nivellement_sol_status_icon_0" style="color:#F44141" class="fa-regular fa-circle-xmark"></i>
                                <span id="nivellement_sol_status_label" style="color:#F44141">Nivellement du sol</span>
                            </div>

                            <div class="col-12 mt-2" style="font-size: 0.8rem">
                                <i id="deblaiement_status_icon_1" style="color:#759B24;display:none" class="fa-regular fa-square-check"></i>
                                <i id="deblaiement_status_icon_0" style="color:#F44141" class="fa-regular fa-circle-xmark"></i>
                                <span id="deblaiement_status_label" style="color:#F44141">Déblaiement</span>
                            </div>

                        </div>
                    </div>

                    <div class="col-12 col-md-6">
                        <?php if(!is_null($demande)): ?>
                        <div style="<?php echo e($demande->geojson()!=null?'display:none':'display:block'); ?>;height: calc( 100% - 0px); width: calc( 100% - 20px); position: absolute; z-index: 99999; border-radius: 6px; background: rgba(255, 255, 255, .5); backdrop-filter: blur(10px); border: 1px #cacaca solid;">
                            <span style="font-family: 'Roboto'; font-weight: 500; font-size: 1.3rem; position: absolute; top: 50%; text-align: center; width: 100%;">Absence de données géométriques</span>
                        </div>
                        <?php else: ?>
                        <div style="height: calc( 100% - 0px); width: calc( 100% - 20px); position: absolute; z-index: 99999; border-radius: 6px; background: rgba(255, 255, 255, .5); backdrop-filter: blur(10px); border: 1px #cacaca solid;">
                            <span style="font-family: 'Roboto'; font-weight: 500; font-size: 1.3rem; position: absolute; top: 50%; text-align: center; width: 100%;">Absence de données géométriques</span>
                        </div>
                        <?php endif; ?>

                        <div id="map" style="min-height: 300px;background: #f2f2f2; height: 100%; width: 100%; border-radius: 6px; border: 1px #c6c6c6 solid;"></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <h6><i class="fa-solid fa-users"></i>&nbsp Pétitionnaires</h6>
                        <div class="row">
                            <div class="col-6">
                                <?php if($mode=='create'): ?>
                                <button id="petitionnaires_add_btn" type="button" class="btn"> <i class="fa-solid fa-plus"></i>&nbspAjouter</button>
                                <button disabled id="petitionnaires_delete_btn" type="button" class="btn btn-danger"> <i class="fa-solid fa-trash"></i>&nbspSupprimer</button>
                                <?php else: ?>
                                <?php if(Auth::user()->id==$demande->user_id): ?>
                                <button id="petitionnaires_add_btn" type="button" class="btn"> <i class="fa-solid fa-plus"></i>&nbspAjouter</button>
                                <button disabled id="petitionnaires_delete_btn" type="button" class="btn btn-danger"> <i class="fa-solid fa-trash"></i>&nbspSupprimer</button>
                                <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <table class="table table-hover datatables dataTable no-footer display nowrap" id="petitionnaires_table">
                            <thead>
                                <th>Nom</th>
                                <th>Prenom</th>
                                <th>CIN</th>
                                <th>Téléphone</th>
                                <th>Documents</th>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <h6><i class="fa-solid fa-file"></i>&nbsp Documents</h6>
                        <div class="row">
                            <div class="col-6">
                                <?php if($mode=='create'): ?>
                                <button id="documents_add_btn" type="button" class="btn"> <i class="fa-solid fa-plus"></i>&nbspAjouter</button>
                                <button disabled id="documents_delete_btn" type="button" class="btn btn-danger"> <i class="fa-solid fa-trash"></i>&nbspSupprimer</button>
                                <?php else: ?>
                                <?php if(Auth::user()->id==$demande->user_id): ?>
                                <button id="documents_add_btn" type="button" class="btn"> <i class="fa-solid fa-plus"></i>&nbspAjouter</button>
                                <button disabled id="documents_delete_btn" type="button" class="btn btn-danger"> <i class="fa-solid fa-trash"></i>&nbspSupprimer</button>
                                <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <table class="table table-hover datatables dataTable no-footer display nowrap" id="documents_table">
                            <thead>
                                <th>Document</th>
                                <th>Date document</th>
                                <th>Taille</th>
                                <th>Type</th>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-md-3">

            <div class="row" style="background: #f2f2f2; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">


                <?php if($mode=='create'): ?>
                <h6>Nouvelle demande</h6>
                <?php else: ?>
                <h6>Demande N° <?php echo e($demande->numero); ?></h6>
                <?php endif; ?>

                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Date :</span>
                            </div>
                            <?php if($mode=='create'): ?>
                            <input readonly value="<?php echo e(Carbon\Carbon::now()->format('d/m/Y H:i')); ?>" class="form-control">
                            <?php else: ?>
                            <input readonly value="<?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$demande->created_at)->format('d/m/Y H:i')); ?>" class="form-control">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Créé par :</span>
                            </div>
                            <?php if($mode=='create'): ?>
                            <input value="<?php echo e(Auth::user()->nom.' '.Auth::user()->prenom); ?>" class="form-control">
                            <?php else: ?>
                            <input value="<?php echo e($demande->user->nom.' '.$demande->user->prenom); ?>" class="form-control">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Etat :</span>
                            </div>
                            <?php if($mode=='create'): ?>
                            <input value="Demande saisie" class="form-control">
                            <?php else: ?>
                            <?php if($demande->dossier==null): ?>
                            <input value="Demande saisie" class="form-control">
                            <?php else: ?>
                            <input value="-" class="form-control">
                            <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                 

                <?php if(Auth::user()->has_role('Architecte,IGT')): ?>
                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1 mt-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Type :</span>
                            </div>
                            <?php if($mode=='create'): ?>
                            <select id="demande_type" class="form-control select2nc">
                                <option selected value="">Veuillez sélectionner</option>
                                <option  value="T">Totale</option>
                                <option   value="P">Partielle</option>
                            </select>
                            <?php else: ?>
                            <select id="demande_type" class="form-control select2nc">
                                <option <?php echo e((is_null($demande->type)?'selected':'')); ?> value="">Veuillez sélectionner</option>
                                <option <?php echo e(($demande->type=='T'?'selected':'')); ?> value="T">Totale</option>
                                <option <?php echo e(($demande->type=='P'?'selected':'')); ?> value="P">Partielle</option>
                            </select>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php else: ?>
                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1 mt-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Type :</span>
                            </div>
                            <input disabled="" style="width: 30px;" value="<?php echo e($demande->type=='T'?'Totale':'Partielle'); ?>" type="text" class="form-control" placeholder="" aria-label="">

                        </div>
                    </div>
                </div>
                <?php endif; ?>


                <h6>Dossier</h6>
                <?php if($mode=='create' || $demande->dossier==null): ?>
                <p style="color: gray; margin-left: 12px;">Aucun dossier n'a été généré pour cette demande</p>
                <?php else: ?>
                <a href="<?php echo e(asset('').'dossiers/show/'.$demande->dossier->id); ?>" class="mt-2" style="font-size: 0.8rem;color: #2273ae;width:100%;text-align: left;">Dossier N° : <?php echo e($demande->dossier->numero); ?></a>
                <?php endif; ?>

                <h6>Prestataires</h6>

                <?php if($mode=='create' ): ?>
                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Laboratoire :</span>
                            </div>
                            <select role_name="Laboratoire" class="form-control select2nc prestataire_select">
                            </select>
                        </div>
                    </div>
                </div>

                <?php if(Auth::user()->has_role('Architecte')): ?>
                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Architecte :</span>
                            </div>
                            <input id="<?php echo e(Auth::user()->id); ?>" role_name="Architecte" disabled class="form-control prestataire_fixed" value="<?php echo e(Auth::user()->organisme_ste); ?>">

                        </div>
                    </div>
                </div>
                <?php else: ?>
                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Architecte :</span>
                            </div>
                            <select role_name="Architecte" class="form-control select2nc prestataire_select">
                            </select>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(Auth::user()->has_role('IGT')): ?>
                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">IGT :</span>
                            </div>
                            <input id="<?php echo e(Auth::user()->id); ?>" role_name="IGT" disabled class="form-control prestataire_fixed" value="<?php echo e(Auth::user()->organisme_ste); ?>">

                        </div>
                    </div>
                </div>
                <?php else: ?>
                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">IGT :</span>
                            </div>
                            <select role_name="IGT" class="form-control select2nc prestataire_select">
                            </select>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">BET :</span>
                            </div>
                            <select role_name="BET" class="form-control select2nc prestataire_select">
                            </select>
                        </div>
                    </div>
                </div>
                <?php else: ?>
                <table class="table table-hover datatables dataTable no-footer display nowrap">
                    <thead>
                        <th>Raison sociale</th>
                        <th>Mission</th>
                    </thead>
                    <tbody>
                        <tr>
                            <td style="font-weight: 500; color: #1a8fb8;"><a item_id="<?php echo e(is_null($demande->Architecte)?'-':$demande->Architecte->id); ?>" class="prestataire_info_btn" href="javascript:;"><i class="fa-solid fa-building"></i>&nbsp<?php echo e(is_null($demande->Architecte)?'-':$demande->Architecte->organisme_ste); ?></a></td>
                            <td>Architecte</td>
                        </tr>
                        <tr>
                            <td style="font-weight: 500; color: #1a8fb8;"><a item_id="<?php echo e(is_null($demande->igt)?'-':$demande->igt->id); ?>" class="prestataire_info_btn" href="javascript:;"><i class="fa-solid fa-building"></i>&nbsp<?php echo e(is_null($demande->igt)?'-':$demande->igt->organisme_ste); ?></a></td>
                            <td>Topographe</td>
                        </tr>
                        <tr>
                            <td style="font-weight: 500; color: #1a8fb8;"><a item_id="<?php echo e(is_null($demande->laboratoire)?'-':$demande->laboratoire->id); ?>" class="prestataire_info_btn" href="javascript:;"><i class="fa-solid fa-building"></i>&nbsp<?php echo e(is_null($demande->laboratoire)?'-':$demande->laboratoire->organisme_ste); ?></a></td>
                            <td>Laboratoire</td>
                        </tr>
                        <tr>
                            <td style="font-weight: 500; color: #1a8fb8;"><a item_id="<?php echo e(is_null($demande->bet)?'-':$demande->bet->id); ?>" class="prestataire_info_btn" href="javascript:;"><i class="fa-solid fa-building"></i>&nbsp<?php echo e(is_null($demande->bet)?'-':$demande->bet->organisme_ste); ?></a></td>
                            <td>Bureau d'études</td>
                        </tr>

                    </tbody>
                </table>
                <?php endif; ?>


                <?php if($mode=='create'): ?>
                <?php if(Auth::user()->has_role("Architecte,IGT,BET")): ?>
                <button id="save_btn" style="width: 100%; background: #fcfcfc  !important; border: 1px #a1a1a1 solid !important;" type="button" class="btn mt-2">
                    <span style="display: none;" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    Enregistrer
                </button>
                <?php endif; ?>
                <?php else: ?>

                <?php if($demande->user_id == Auth::user()->id): ?>
                <button id="save_btn" style="width: 100%; background: #fcfcfc  !important; border: 1px #a1a1a1 solid !important;" type="button" class="btn mt-2">
                    <span style="display: none;" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    Enregistrer
                </button>
                <button id="delete_btn" style="width: 100%; background: #fcfcfc  !important; border: 1px #a1a1a1 solid !important;" type="button" class="btn btn-danger mt-2">
                    <span style="display: none;" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    Supprimer
                </button>
                <?php endif; ?>


                <?php endif; ?>
                <?php if($mode!='create'): ?>
                <?php if(( $demande->dossier==null) && $demande->user_id == Auth::user()->id): ?>
                <button id="create_dossier" style="width: 100%; background: #fcfcfc  !important; border: 1px #a1a1a1 solid !important;" type="button" class="btn mt-2">
                    <span style="display: none;" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    Créer dossier
                </button>
                <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('demandes.modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('added_scripts'); ?>
<script src="<?php echo e(asset('js/demandes/show.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/demandes/petitionnaire_modal.js').'?t='.time()); ?>"></script>

<script>
    var provinces = <?php echo json_encode($provinces, JSON_PRETTY_PRINT, 512) ?>;
    var cercles = <?php echo json_encode($cercles, JSON_PRETTY_PRINT, 512) ?>;
    var communes = <?php echo json_encode($communes, JSON_PRETTY_PRINT, 512) ?>;
    var douars = <?php echo json_encode($douars, JSON_PRETTY_PRINT, 512) ?>;

    <?php if($demande != null): ?>
    var demande = <?php echo json_encode($demande, JSON_PRETTY_PRINT, 512) ?>;
    <?php else: ?>
    var demande = {};
    <?php endif; ?>
    $(document).ready(function() {
        for (var i = 0; i < demande.petitionnaires.length; i++) {
            petitionnaires_add(demande.petitionnaires[i]);
        }
    });

    $(document).ready(function() {
        for (var i = 0; i < demande.documents.length; i++) {
            documents_table_add(demande.documents[i]);
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/batirc6/public_html/resources/views/demandes/show.blade.php ENDPATH**/ ?>