
<?php $__env->startSection('added_css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<style>
    .table>tbody>tr>td,
    .table>tfoot>tr>td,
    .table>thead>tr>td {
        font-size: 0.70rem;
    }
</style>
<nav class="hk-breadcrumb" aria-label="breadcrumb">

    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo e(route('projets')); ?>">Projet</a></li>
        <li class="breadcrumb-item"><b>Projet N° <?php echo e($projet->numero); ?></b>

    </ol>
</nav>

<div class="row mt-2">
    <div class="col-12 col-sm-9">
        <ul class="nav nav-tabs " role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="preparation-tab" data-toggle="tab" href="#preparation" role="tab" aria-controls="preparation" aria-selected="true"><i class="fa-solid fa-calendar-check mr-1"></i>Préparation</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="projet-tab" data-toggle="tab" href="#projet" role="tab" aria-controls="projet" aria-selected="false"><i class="fa-solid fa-person-digging mr-1"></i>Projet</a>
            </li>

            <li class="nav-item">
                <a class="nav-link" id="documents-tab" data-toggle="tab" href="#documents" role="tab" aria-controls="documents" aria-selected="false"><i class="fa-regular fa-file-line mr-1s"></i>Documents/Fichiers de dessins</a>
            </li>

            <li class="nav-item">
                <a class="nav-link" id="visualisation3d-tab" data-toggle="tab" href="#visualisation3d" role="tab" aria-controls="visualisation3d" aria-selected="false"><i class="fa-brands fa-unity mr-1"></i>Visualisation 3d</a>
            </li>

            <li class="nav-item disabled">
                <a class="nav-link" id="reunion-tab" data-toggle="tab" href="#reunion" role="tab" aria-controls="reunion" aria-selected="false"><i class="fa-regular fa-comments mr-1"></i>Réunions</a>
            </li>

        </ul>
        <div class="tab-content" style="padding:8px">
            <div class="tab-pane fade show active" id="preparation" role="tabpanel" aria-labelledby="preparation-tab">


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-regular fa-circle-question mr-1"></i>Informations générales</h6>

                                <div class="row">
                                    <div class="col-12 col-sm-7">

                                        <div class="row mt-1" style="border: 1px dashed gray; padding: 8px; border-radius: 8px; background: #f8f8f8;">
                                            <div class="col-2">
                                                <img src="<?php echo e($projet->mao->avatar()); ?>" class="user-image rounded-circle" style="border: #1e6f6c solid; border-width: 2px;width:100%">

                                            </div>
                                            <div class="col-4" style="display: block;margin: auto 0px;">
                                                <b class="mb-2" style="font-size: 1rem;color: #115555; "><?php echo e($projet->mao->nom); ?> <?php echo e($projet->mao->prenom); ?></b>
                                                <br>
                                                <b style="font-size: 0.7rem; color: #7a7a7a; font-style: italic;">Maitre d'ouvarge</b>
                                            </div>

                                            <div class="col-4" style="display: block;margin: auto 0px;">
                                                <b class="mb-2" style="font-size: 0.9rem;color: #115555; "><?php echo e($projet->mao->email); ?> </b>
                                                <br>
                                                <b style="font-size: 0.9;color: #115555; "><?php echo e($projet->mao->tel); ?> </b>
                                            </div>
                                        </div>
                                        <div class="row  mt-2">
                                            <div class="col-12 col-sm-5">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 100px;">Region</span>
                                                    </div>
                                                    <input readonly class="form-control" value="<?php echo e($projet->lot->lotissement->region->nom); ?>">
                                                </div>
                                            </div>

                                            <div class="col-12 col-sm-7">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 140px;">Province</span>
                                                    </div>
                                                    <input readonly class="form-control" value="<?php echo e($projet->lot->lotissement->ville->province->nom); ?>">
                                                </div>
                                            </div>


                                        </div>

                                        <div class="row mt-1">
                                            <div class="col-12 col-sm-5">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 100px;">Ville</span>
                                                    </div>
                                                    <input readonly class="form-control" value="<?php echo e($projet->lot->lotissement->ville->nom); ?>">
                                                </div>
                                            </div>
                                            <div class="col-12 col-sm-7">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 140px;">Lotissement</span>
                                                    </div>
                                                    <input readonly class="form-control" value="R+<?php echo e($projet->lot->lotissement->nom); ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row mt-1">
                                            <div class="col-12 col-sm-5">
                                                <div class="input-group input-group-sm mb-2">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 100px;">Lot</span>
                                                    </div>
                                                    <input readonly class="form-control" value="R+<?php echo e($projet->lot->numero); ?>">

                                                </div>
                                            </div>
                                            <div class="col-12 col-sm-7">
                                                <div class="input-group input-group-sm mb-2">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 140px;">Référence foncière</span>
                                                    </div>
                                                    <input readonly class="form-control" value="<?php echo e($projet->lot->ref_fonciere); ?>">

                                                </div>
                                            </div>
                                        </div>


                                        <div class="row">
                                            <div class="col-12 col-lg-6">
                                                <h5 class="">• Intitulé</h5>
                                                <textarea class="form-control" rows="5" style="width: 100%;"><?php echo e($projet->intitule); ?></textarea>
                                            </div>

                                            <div class="col-12  col-lg-6">
                                                <h5 class="">• Cahier des charges : </h5>
                                                <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                                                    <div>
                                                        <i type_document="ATTESTATION_IMPLANTATION" style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;" class="fa-solid fa-file-circle-xmark upload_doc_icon"></i>

                                                        <b type_document="ATTESTATION_IMPLANTATION" class="mt-2 upload_doc_no_file_label" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                                        <div style="margin: auto; display: block;text-align: center;">
                                                            <button disabled="" type_document="ATTESTATION_IMPLANTATION" file_id="" type="button" class="btn btn-success download_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Télécharger</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="col-12 col-sm-5">

                                        <div id="image_sat_div" style="min-height: 400px; background: rgb(242, 242, 242); height: 100%; width: 100%; border-radius: 4px; border: 1px solid rgb(198, 198, 198); position: relative;">

                                        </div>
                                    </div>
                                </div>





                            </div>
                        </div>
                    </div>
                </div>

                <?php if(Auth::user()->has_role("admin,moa,chef_projet")): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-users-gear mr-1"></i>Désignation des intervenants</h6>


                                <div class="row mt-1">
                                    <div class="col-12">

                                        <h5 class="">• Sélection des prestataires : </h5>
                                        <div class="input-group input-group-sm mb-2 col-6 mt-2">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text" style="width: 140px;">Type de prestataire</span>
                                            </div>
                                            <select id="intervenants_table_type_prestataire" class="form-control select2nc">
                                                <option selected value="arch">Architecte</option>
                                                <option value="igt">Ingénieur topographe</option>
                                                <option value="bet">Bureau d'étude</option>
                                                <option value="labo">Laboratoire</option>
                                                <option value="bc">Bureau de controle</option>
                                            </select>

                                        </div>
                                        <div class="row mt-1">
                                            <div class="col-6">
                                                <button id="intervenants_table_add_btn" class="btn"><i class="fa-solid fa-circle-plus mr-1"></i>Ajouter</button>
                                            </div>

                                        </div>





                                        <table class="table table-striped datatables dataTable no-footer display nowrap" id="intervenants_table">
                                            <thead>
                                                <th class="intervenants_table_type_th">Architecte</th>
                                                <th>Ville</th>
                                                <th>Téléphone</th>
                                                <th>Prix de l'offre</th>
                                                <th>Devis</th>
                                                <th></th>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>


                                </div>



                                <div class="row mt-1">
                                    <div class="col-12">

                                        <h5 class="">• Prestataires retnus : </h5>

                                        <table class="table table-striped datatables dataTable no-footer display nowrap" id="intervenants_retenus_table">
                                            <thead>
                                                <th>Prestataire</th>
                                                <th>Ville</th>
                                                <th>Téléphone</th>
                                                <th>Honoraires</th>
                                                <th>Contrat</th>

                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>


                                    </div>

                                    <span style="color: #115555; float: right; font-size: 0.80rem; width: 100%; text-align: center; background: #f4f4f4; border-radius: 4px; border: 1px #d2d2d2 solid; padding: 8px; margin-top: 8px;">Total des honoraire : <b id="total_honoraires_txt">0</b> MAD</span>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>


                <?php else: ?>

                <?php if(Auth::user()->has_role('arch,bet,igt,labo')): ?>
                <?php if(!is_null($demnande_devis)): ?>

                <?php if($demnande_devis->etat=="en_cours"): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: #fad3a0;">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-file-signature mr-1"></i>Demande de devis</h6>
                                <div class="row">
                                    <div class="col-8">
                                        <p>Une demande de devis a été effectuée par <b><?php echo e($demnande_devis->projet->mao->prenom); ?> <?php echo e($demnande_devis->projet->mao->nom); ?></b> le <b><?php echo e($demnande_devis->created_at); ?> </b>.</p>
                                        <p>Pour répondre à la demande, veuillez charger le devis et indiquer le prix de l'offre.</p>
                                    </div>
                                    <div class="col-4">
                                        <button file_type="pdf" type_document="DEVIS" file_id="" type="button" class="btn btn-success upload_doc_link"> <i class="fa-solid fa-upload mr-1"></i>Charger le devis</button>
                                        <button disabled file_id="" type_document="DEVIS" file_id="" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le devis</button>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>



                <?php if($demnande_devis->etat=="devis_uploaded"): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: #b5dba6;">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-file-signature mr-1"></i>Demande de devis</h6>
                                <div class="row">
                                    <div class="col-8">
                                        <p>Une demande de devis a été effectuée par <b><?php echo e($demnande_devis->projet->mao->prenom); ?> <?php echo e($demnande_devis->projet->mao->nom); ?></b> le <b><?php echo e($demnande_devis->created_at); ?> </b>.</p>
                                        <p>Vous avez répondu à la demande de devis le <?php echo e($demnande_devis->file->formated_created_at()); ?>, avec un prix de l'offre de <b><?php echo e(number_format($demnande_devis->prix_offre,2,'.',' ')); ?></b> MAD</p>
                                    </div>
                                    <div class="col-4">
                                        <button file_id="<?php echo e($demnande_devis->file_id); ?>" type_document="DEVIS" file_id="" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le devis</button>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php endif; ?>




                <?php if(!is_null($demande_contrat)): ?>

                <?php if($demande_contrat->etat=="en_cours"): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: #fad3a0;">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-regular fa-circle-check mr-1"></i>Offre de prix acceptée</h6>
                                <div class="row">
                                    <div class="col-8">
                                        <p>Votre offre a été validée par <?php echo e($demande_contrat->projet->mao->prenom); ?> <?php echo e($demande_contrat->projet->mao->nom); ?> e <b><?php echo e($demnande_devis->created_at); ?></b>.</p>
                                        <p>Merci de bien vouloir charger le contrat.</p>
                                    </div>
                                    <div class="col-4">
                                        <button type_document="CONTRAT" file_type="pdf" file_id="" type="button" class="btn btn-success upload_doc_link"> <i class="fa-solid fa-upload mr-1"></i>Charger le contrat</button>
                                        <button disabled file_id="" type_document="CONTRAT" file_id="" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le contrat</button>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if($demande_contrat->etat=="uploaded"): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: #b5dba6;">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-file-signature mr-1"></i>Offre de prix acceptée</h6>
                                <div class="row">
                                    <div class="col-8">
                                        <p>Contrat chargé le <?php echo e($demande_contrat->contrat_file->formated_created_at()); ?></p>
                                    </div>
                                    <div class="col-4">
                                        <button file_id="<?php echo e($demande_contrat->contrat_file_id); ?>" type_document="CONTRAT" file_id="" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le contrat</button>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php endif; ?>

                <?php endif; ?>
                <?php endif; ?>


                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-circle-info mr-1"></i>Descriptif du projet</h6>

                                <div class="row">
                                    <div class="col-12 col-sm-6">
                                        <h5 class="">• Produits : </h5>
                                        <div class="row mt-1">
                                            <?php if(Auth::user()->has_role('arch') && $projet->arch_id==Auth::user()->id): ?>
                                            <div class="col-6">
                                                <button id="produits_table_add_btn" class="btn"><i class="fa-solid fa-circle-plus mr-1"></i>Ajouter</button>
                                                <button id="produits_table_delete_btn" disabled class="mr-3 btn btn-danger "><i class="fa-regular fa-trash-can mr-1"></i>Supprimer</button>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                        <table class="table table-striped datatables dataTable no-footer display nowrap" id="produits_table">
                                            <thead>
                                                <th>Produit</th>
                                                <th>Surface vendable</th>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="col-12 col-sm-6">

                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-12">
                                        <h5>• Expression de besoin</h5>
                                        <?php echo $__env->make('projets/check_list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if(Auth::user()->has_role("moa") && is_null($etude_marche)): ?>
                <div class="row mt-2 mb-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-magnifying-glass-chart mr-1"></i>Etude du marché</h6>
                                <div class="row">
                                    <div class="col-12">
                                        <p style="text-align: center;">Une étude de marché permettra de diagnostiquer rapidement votre lot et de vous fournir une estimation du chiffre d’affaires selon les prix de vente et les offres approximatives.
                                            Pour demander une étude de marché maerci de clique sur le lien ci-dessous</p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <button style="margin: auto;display: block;" id="demande_etude_marche_btn" class="btn"><i class="fa-solid fa-circle-plus mr-1"></i>Demander l'étude de marché</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(!is_null($etude_marche)): ?>
                <div class="row mt-2 mb-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="card-title">
                                    <i class="fa-solid fa-magnifying-glass-chart mr-1"></i>Etude du marché - <b style="color:<?php echo e($etude_marche->etat_color()); ?>"><?php echo e($etude_marche->h_etat()); ?></b>
                                    <?php if(Auth::user()->has_role("admin,chef_projet")): ?>
                                    <a style="float: right;" href="/etude_marche/show/<?php echo e($etude_marche->id); ?>"><i class="fa-solid fa-link mr-1"></i>Basculer vers l'etude du marché</a>
                                    <?php endif; ?>
                                </h6>
                                <div class="row">
                                    <div class="col-12 col-sm-3">
                                        <table class="table table-striped datatables dataTable no-footer display nowrap etude_marche_atouts_table">
                                            <thead>
                                                <th>Atouts</th>
                                            </thead>
                                            <tbody>
                                                <?php if(count($etude_marche->atouts)==0): ?>
                                                <tr>
                                                    <td>
                                                        <span>Aucune donnée disponible dans le tableau</span>
                                                    </td>
                                                </tr>
                                                <?php else: ?>

                                                <?php $__currentLoopData = $etude_marche->atouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $atout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <b style="color: #3b8512;" class="ml-1"><i class="fa-regular fa-thumbs-up mr-1"></i><?php echo e($atout->content); ?></b>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="col-12 col-sm-3">
                                        <table class="table table-striped datatables dataTable no-footer display nowrap etude_marche_faiblesses_table">
                                            <thead>
                                                <th>Faiblesses</th>
                                            </thead>
                                            <tbody>
                                                <?php if(count($etude_marche->faiblesses)==0): ?>
                                                <tr>
                                                    <td>
                                                        <span>Aucune donnée disponible dans le tableau</span>
                                                    </td>
                                                </tr>
                                                <?php else: ?>
                                                <?php $__currentLoopData = $etude_marche->faiblesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faiblesse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <b style="color: #fb5151;" class="ml-1"><i class="fa-regular fa-thumbs-down mr-1"></i><?php echo e($faiblesse->content); ?></b>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>

                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="col-12 col-sm-6">
                                        <table class="table table-striped datatables dataTable no-footer display nowrap etude_marche_produits_table">
                                            <thead>
                                                <th>Produit</th>
                                                <th>Surface vendable (Estimation)</th>
                                                <th>Prix unitaire adopté</th>
                                                <th>Chiffre d'affaire</th>
                                            </thead>
                                            <tbody>
                                                <?php if(count($etude_marche->projet->produits)==0): ?>
                                                <tr>
                                                    <td colspan="4">
                                                        <span>Aucune donnée disponible dans le tableau</span>
                                                    </td>
                                                </tr>
                                                <?php else: ?>
                                                <?php $__currentLoopData = $etude_marche->projet->produits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <b><?php echo e($produit->type); ?></b>
                                                    </td>
                                                    <td>
                                                        <b><?php echo e($produit->surface_vendable); ?> m²</b>
                                                    </td>

                                                    <?php if($etude_marche->etat=="en_cours"): ?>
                                                    <td>
                                                        <b>-</b>
                                                    </td>
                                                    <td>
                                                        <b>-</b>
                                                    </td>
                                                    <?php else: ?>
                                                    <td>
                                                        <b><?php echo e(number_format( $produit->pu_adopte,0,'.',' ')); ?> MAD</b>
                                                    </td>
                                                    <td>
                                                        <b><?php echo e(number_format( $produit->prix_total,0,'.',' ')); ?> MAD</b>
                                                    </td>
                                                    <?php endif; ?>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>

                                        <span style="color: #ca8e3d; float: right; margin-right: 8px;">Total : <b><?php echo e(number_format( $etude_marche_cf,0,'.',' ')); ?></b> MAD</span>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

            </div>

            <div class="tab-pane fade" id="projet" role="tabpanel" aria-labelledby="projet">
                <?php echo $__env->make("projets/projet_tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="tab-pane fade" id="documents" role="tabpanel" aria-labelledby="documents">
                <?php echo $__env->make("projets/documents_fichiers_tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="tab-pane fade" id="visualisation3d" role="tabpanel" aria-labelledby="visualisation3d">
                <?php echo $__env->make("projets/3dview_tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="tab-pane fade" id="reunion" role="reunion" aria-labelledby="reunion">
                <?php echo $__env->make("projets/reunions_tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>

    <div class="col-12 col-sm-3">
        <div class="row" style="background: #f9f9f9; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">

            <div class="row ml-2 mt-1" style="width:100%">
                <span style="color: #115555;font-size: 0.9rem;"><i class="fa-solid fa-layer-group mr-1"></i>Référence foncière : <?php echo e($projet->lot->ref_fonciere); ?></span>
            </div>

        </div>

        <div class="row mt-1" style="background: #f9f9f9; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">
            <div class="row">

                <div class="col-3">
                    <img src="<?php echo e($projet->chef_projet->avatar()); ?>" class="user-image rounded-circle" style="border: #1e6f6c solid; border-width: 2px;width:100%">

                </div>
                <div class="col-4" style="display: block;margin: auto 0px;">
                    <b style="font-size: 0.8rem;color: #115555; "><?php echo e($projet->chef_projet->nom); ?> <?php echo e($projet->chef_projet->prenom); ?></b>
                    <br>
                    <b style="font-size: 0.7rem; color: #7a7a7a; font-style: italic;">Chef du projet</b>
                </div>
            </div>

            <div class="row mt-1" style="width:100%">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text" style="width: 180px;">Démarage des travaux</span>
                    </div>
                    <input readonly="" class="form-control" value="-">
                </div>
            </div>

            <div class="row mt-1" style="width:100%">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text" style="width: 180px;">Date prévue de fin des travaux</span>
                    </div>
                    <input readonly="" class="form-control" value="-">
                </div>
            </div>
        </div>
        <div class="row mt-1">
            <div class="card" style="width: 100%;background: #f9f9f9;">
                <div class="card-body">
                    <h6 class="card-title"><i class="fa-solid fa-list-check mr-1"></i>Avancement</h6>

                    <div class="row ml-2 mt-1" style="width:100%">
                        <span style="color:#ee9e3e"><i class="fa-solid fa-caret-right mr-1"></i>Travaux préparatoires</span>
                    </div>
                    <div class="row ml-4 mt-1" style="width:100%">
                        <span style="color:#7a7a7a"><i class="fa-regular fa-clock mr-1"></i>Autorisation de construire</span>
                    </div>
                    <div class="row ml-4 mt-1" style="width:100%">
                        <span style="color:#7a7a7a"><i class="fa-regular fa-clock mr-1"></i>Fondations</span>
                    </div>
                    <div class="row ml-4 mt-1" style="width:100%">
                        <span style="color:#7a7a7a"><i class="fa-regular fa-clock mr-1"></i>Structure</span>
                    </div>
                    <div class="row ml-4 mt-1" style="width:100%">
                        <span style="color:#7a7a7a"><i class="fa-regular fa-clock mr-1"></i>Enveloppe</span>
                    </div>
                    <div class="row ml-4 mt-1" style="width:100%">
                        <span style="color:#7a7a7a"><i class="fa-regular fa-clock mr-1"></i>Finitions</span>
                    </div>
                    <div class="row ml-4 mt-1" style="width:100%">
                        <span style="color:#7a7a7a"><i class="fa-regular fa-clock mr-1"></i>Fin des travaux</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-1">
            <div class="card" style="width: 100%;background: #f9f9f9;">
                <div class="card-body">
                    <h6 class="card-title"><i class="fa-solid fa-user-gear mr-1"></i>Intervenants</h6>

                    <table class="table table-striped datatables dataTable no-footer display nowrap" id="intervenants_retenus_table">
                        <thead>
                            <th style="width:100px">Mission</th>
                            <th>Prestataire</th>
                        </thead>
                        <tbody>
                            <tr>
                                <td><b>Architecte</b></td>
                                <td>
                                    <?php if(is_null($projet->architecte)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->architecte->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><b>Topographe</b></td>
                                <td>
                                    <?php if(is_null($projet->igt)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->igt->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><b>Laboratoire</b></td>
                                <td>
                                    <?php if(is_null($projet->laboratoire)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->laboratoire->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><b>Bureau d'étude</b></td>
                                <td>
                                    <?php if(is_null($projet->bet)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->bet->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><b>Bureau de controle</b></td>
                                <td>
                                    <?php if(is_null($projet->bc)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->bc->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><b>Entreprise</b></td>
                                <td>
                                    <?php if(is_null($projet->entreprise)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->entreprise->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="row mt-1">
            <div class="card" style="width: 100%;background: #f9f9f9;">
                <div class="card-body">
                    <h6 class="card-title"><i class="fa-solid fa-gear mr-1"></i>Actions</h6>

                    <button id="save_projet" style="width: 100%;" class="btn mt-1"><i class="fa-regular fa-floppy-disk mr-1"></i>Enregistrer les modifications</button>

                </div>
            </div>
        </div>

    </div>
</div>
<?php echo $__env->make('projets/modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('added_scripts'); ?>
<script>
    var projet_id = "<?php echo e($projet->id); ?>";
    var lot_id = "<?php echo e($projet->lot->id); ?>";
    var lot_lat = parseFloat("<?php echo e($projet->lot->lat); ?>");
    var lot_lng = parseFloat("<?php echo e($projet->lot->lng); ?>");
</script>

<script src="<?php echo e(asset('js/projets/image_sat.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/show.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/intervenants.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/produits.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/etude_marche.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/entreprise.js').'?t='.time()); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u207500317/domains/seagreen-ostrich-285320.hostingersite.com/public_html/resources/views/projets/show.blade.php ENDPATH**/ ?>