

<?php $__env->startSection('added_css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/datatable/datatables.min.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('chart.js/dist/Chart.min.css')); ?>">
<script src="<?php echo e(asset('chart.js/dist/Chart.js')); ?>"></script>
<style>
    .m-footer {
        color: #ff1308 !important;
        font-weight: 600;
    }

    .small-box>.inner {
        padding: 0.75rem;
    }

    .small-box {
        margin-bottom: 10px;
    }


    .text-styling {
        font-size: 14px;
        color: #000;

    }

    .text-center {
        font-size: 14px;
        color: #000;
    }


    .table th,
    .table td {
        border-right: 1px solid #f4f4f4;
    }


    .table-striped tbody tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, .05) !important;
    }

    th {
        background-color: unset !important;
    }


    .m-thead {
        font-family: Lato;
        font-weight: 700 !important;
        font-size: 15px !important;
    }


    .m-thead-mobile {
        font-family: Lato;
        font-weight: 600 !important;
        font-size: 13px !important;

    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div style="padding-top: 16px;margin-left: 8px">

    <div style="width: 40%;margin: auto;display: block;text-align: center;">
        <img style="display: inline-block; height: 200px; margin-bottom: 8px; margin-top: 20px;"
            src="data:image/png;base64,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">
        <h5 class="mt-2">Bienvenue au centre de vérification VSB-Maroc. Pour commencer, veuillez cliquer sur le bouton suivant.
        </h5>
        <button class="mr-3 btn next_btn"><i class="fa-solid fa-arrow-right"></i>&nbsp Suivant</button>


        <?php if(Auth::user()->can_edit_decision==1): ?>
        <div class="row mt-3">
            <div class="col-12">
                <span>Nombre total des baraques : <b><?php echo e($baraques_count); ?></b></span>
                <span>, Verifiées : <b><?php echo e($baraques_verifiees_count); ?></b></span>
            </div>
        </div>

        <?php endif; ?>
    </div>

   


</div>
<?php echo $__env->make('dashboard/modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('added_scripts'); ?>


<script>
    var baraques_refuse_table = undefined;

    $('.next_btn').click(function() {
        $.ajax({
            url: assetBaseUrl + "verification2/next",
            type: "GET",
            dataType: "json",
            success: function(response) {
                if (response.success) {
                    location.href = assetBaseUrl + 'verification2/show/' + response.id;
                }

            },
            error: function(xhr, status, error) {
                console.log(xhr.responseText);
            },
        });
    });




     
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u490561298/domains/seagreen-sardine-362756.hostingersite.com/public_html/resources/views/verification2/index.blade.php ENDPATH**/ ?>