<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        $schedule->command('app:update_mi_verified_status')->everyFiveMinutes()->withoutOverlapping();
        $schedule->command('app:update_dashbaord')->everyTenMinutes()->withoutOverlapping();
        $schedule->command('app:refresh-suivi')->everyTenMinutes()->withoutOverlapping();
        $schedule->command('app:refresh-etude-geotechnique-intersections')->everyTenMinutes()->withoutOverlapping();

        $schedule->command('app:dump_db')->dailyAt("00:01")->withoutOverlapping();
        $schedule->command('app:dump_files')->dailyAt("00:01")->withoutOverlapping();
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
