<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Attachements;
use App\Models\Attachement_dossiers;
use Illuminate\Support\Str;
use DataTables;
use App\Models\Dossier;

use Response;
use stdClass;

class AttachementController extends Controller
{
    public function index()
    {
        $douars = Auth::user()->douars();
        $communes = Auth::user()->communes();
        $cercles = Auth::user()->cercles();
        $provinces = Auth::user()->provinces();

        for ($i = 0; $i < count($douars); $i++) {
            if (strlen($douars[$i]->nom) == 0) {
                $douars[$i]->nom = $douars[$i]->nom_ar;
            }
        }

        $prestataires = User::WhereIn(
            'role_id',
            [
                'cccfaaf5-9e6e-45eb-bbd3-0f813a085791',
                'f652fd43-e591-4562-9220-ce2ab98542af',
                '77970795-73b6-4f2f-8e4c-e97d25636598',
                '29a4359b-52c1-486b-8ede-b5fcda314a8b'
            ]
        )->get();

        return view('attachement.index', [
            'douars' => $douars,
            'communes' => $communes,
            'cercles' => $cercles,
            'provinces' => $provinces,
            'prestataires' => $prestataires
        ]);
    }

    public function attachements_datatable(Request $request)
    {
        $filters = json_decode($request->filters);
        $attachements = Attachements::orderBy('created_at', 'desc')->where('phase', 'etude');
        foreach ($filters as $filter) {
        }

        return Datatables::eloquent($attachements)

            ->addColumn('numero', function ($attachement) {
                return '<a class="fichier_echange_a" id="' . $attachement->id . '" href="#"><b><i class="fa-solid fa-file-export"></i>&nbsp' . $attachement->numero . '</b></a>';
            })
            ->addColumn('date', function ($attachement) {
                return  $attachement->formated_created_at();
            })
            ->addColumn('dossiers_count', function ($attachement) {
                return  $attachement->dossiers_count;
            })
            ->addColumn('envoye', function ($attachement) {
                if ($attachement->envoyer_validation == 1) {
                    return  '<b style="color:#6A9C27"><i class="fa-solid fa-circle-check"></i>&nbspEnvoyé</b>';
                } else {
                    return '<b style="color:#727272"><i class="fa-solid fa-eye-slash"></i>&nbspEn attente</b>';
                }
            })
            ->addColumn('etat', function ($attachement) {
                $color = "#000000";
                if ($attachement->etat == "En cours") {
                    $color = "#686868";
                }
                if ($attachement->etat == "Validé") {
                    $color = "#499462";
                }
                if ($attachement->etat == "Rejeté") {
                    $color = "#df0506";
                }
                return  '<b style="color:' . $color . '"><i class="fa-solid fa-circle-check"></i>&nbsp' . $attachement->etat . '</b>';
            })

            ->rawColumns(['numero', 'date', 'dossiers_count', 'envoye', 'etat'])
            ->make(true);
    }

    public function generate_new(Request $request)
    {
        if (Auth::user()->role->prestataire == 0) {

            $prestataire_id = $request->prestataire_id;

            $attachements_en_cours = Attachements::where('prestataire_id', $prestataire_id)->where('etat', 'En cours')->count();
            if ($attachements_en_cours > 0) {
                return Response::json(['success' => 0, 'error' => "ATTACHEMENT_EN_COURS"]);
            }


            $attachment = new Attachements();
            $attachment->id = Str::uuid();
            $attachment->user_id = Auth::user()->id;
            $attachment->prestataire_id = $prestataire_id;
            $attachment->type =  $request->type;
            $attachment->phase =  $request->phase;
            $attachment->dossiers_count = 0;
            $attachment->dossiers_rehab_count = 0;
            $attachment->save();


            if (Auth::user()->role->name = "IGT") {
                $result = self::generate_for_igt($attachment);
            }

            return Response::json(['success' => 1, 'error' => null, "result" => $result]);
        } else {
            return Response::json(['success' => 0, 'error' => "NOT_PRESTATIRE"]);
        }
    }

    public function delete(Request $request)
    {
        $attachement = Attachements::where('id', $request->id)->get()->first();
        if (is_null($attachement)) {
            return Response::json(['success' => 0, 'error' => "ATTACHEMENT_NOT_FOUND"]);
        } else {

            Attachement_dossiers::where([["attachement_id", $request->id]])->delete();
            $attachement->delete();
            return Response::json(['success' => 1, 'error' => null]);
        }
    }

    public function generate_for_igt($attachement)
    {
        $dossiers = Dossier::where('igt_id', $attachement->prestataire_id)->where('created_at', '<', '2024-02-01 15:37:20')->get();

        $dossiers_count = 0;

        foreach ($dossiers as $dossier) {

            $ac = $dossier->specific_document('AUTORISATION_CONSTRUIRE');
            $pc = $dossier->specific_document('PLAN_COTE_DWG');
            $ai = $dossier->specific_document('ATTESTATION_IMPLANTATION');

            if (is_null($ac) || is_null($pc) || is_null($ai)) {
                continue;
            }
            if ($ac->decision == "Validé") {
                if ($pc->decision == "Validé") {
                    if ($ai->decision == "Validé") {


                        $attachement_dossier = new Attachement_dossiers();
                        $attachement_dossier->id = Str::uuid();
                        $attachement_dossier->attachement_id = $attachement->id;
                        $attachement_dossier->user_id = Auth::user()->id;
                        $attachement_dossier->prestataire_id = $attachement->prestataire_id;
                        $attachement_dossier->phase = $attachement->phase;
                        $attachement_dossier->type = $attachement->type;
                        $attachement_dossier->dossier_id = $dossier->id;
                        $attachement_dossier->save();
                        $dossiers_count++;
                    }
                }
            }
        }
        $result = new stdClass();
        $result->dossiers_count = $dossiers_count;

        return $result;
    }
}
