<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Dossier;
use App\Models\Demande;
use Illuminate\Support\Facades\DB;
use App\Models\Dossier_rehab;
use App\Models\Dossier_document;
use App\Models\Guichet;
use App\Models\Douar;
use Carbon\Carbon;
use stdClass;

class DashboardController extends Controller
{
    public function index()
    {
        $currentYear = now()->year;
        $years = [];
        for ($i = 0; $i < 5; $i++) {
            $years[] = $currentYear - $i;
        }

        return view('dashboard.index', compact('years'));
    }


    public function index_terrains_stats(Request $request)
    {
        $stats = new stdClass();
        $currentYear = now()->year;
        $surface_perimetre = 0;
        $surface_perimetre = 12094781;

        $declarations = DB::table('declarations')
            ->whereYear('date', date('Y'))
            ->get();
        $stats->total_declarations_value = $declarations->count();

        $totalDeclarationsurface = 0;
        $totalDeclarationsurface = DB::table('declarations')
            ->join('terrains', 'declarations.id_terrain', '=', 'terrains.id')
            ->whereYear('declarations.date', date('Y'))
            ->sum('terrains.surface');


        $stats->total_declarations_surface_value = number_format($totalDeclarationsurface, 2, '.', ' ') . ' m²';





        $terrains = DB::table('terrains')->get();
        $stats->total_terrains_value = $terrains->count();


        $stats->declarations_surface_percentage = $totalDeclarationsurface > 0
            ? number_format(($totalDeclarationsurface / $surface_perimetre) * 100, 2) . '%'
            : '0%';


        $declarations_changement_proprietaires_number = DB::table('terrains_documents')
            ->where('type_document', 'DECLARATION_CHANGEMENT_PROPRIETAIRE_PDF')
            ->whereYear('date_document', date('Y'))
            ->distinct()
            ->count('terrain_id');


        $stats->declarations_changement_proprietaires_count = $declarations_changement_proprietaires_number;

        $stats->declarations_changement_proprietaires_percentage = $stats->declarations_changement_proprietaires_count > 0
            ? number_format(($declarations_changement_proprietaires_number / $stats->total_terrains_value) * 100, 2) . '%'
            : '0%';


        $totalSurface = $terrains->sum('surface');
        $stats->total_terrains_surface_value = number_format($totalSurface, 2, '.', ' ') . ' m²';

        $stats->total_surface_perimetre_value = number_format($surface_perimetre, 2, '.', ' ') . ' m²';

        $stats->terrains_nus_percentage = $stats->total_terrains_value > 0
            ? number_format(($totalSurface / $surface_perimetre) * 100, 2) . '%'
            : '0%';


        $terrainsTaxables = DB::table('terrains')->where('type', 'Terrains taxables')->get();
        $stats->terrains_taxables_count = $terrainsTaxables->count();
        $totalSurfaceTaxables = $terrainsTaxables->sum('surface');
        $stats->terrains_taxables_surface = number_format($totalSurfaceTaxables, 2, '.', ' ') . ' m²';

        $stats->terrains_taxables_percentage = $stats->total_terrains_value > 0
            ? number_format(($stats->terrains_taxables_count / $stats->total_terrains_value) * 100, 2) . '%'
            : '0%';

        // Exonerations temporaires
        $ExonerationsTemporaires = DB::table('terrains')->where('type', 'Exonerations temporaires')->get();
        $stats->exonerations_temporaires_count = $ExonerationsTemporaires->count();
        $totalSurfaceExonerationTemp = $ExonerationsTemporaires->sum('surface');
        $stats->exonerations_temporaires_surface = number_format($totalSurfaceExonerationTemp, 2, '.', ' ') . ' m²';

        $stats->exonerations_temporaires_percentage = $stats->total_terrains_value > 0
            ? number_format(($stats->exonerations_temporaires_count / $stats->total_terrains_value) * 100, 2) . '%'
            : '0%';


        // Exonerations supprimes (Loti/construit)
        $terrainsNonTaxables = DB::table('terrains')->where('type', 'Terrains supprimes')->get();
        $stats->terrains_non_taxables_count = $terrainsNonTaxables->count();
        $totalSurfaceExonerationTemp = $terrainsNonTaxables->sum('surface');
        $stats->terrains_non_taxables_surface = number_format($totalSurfaceExonerationTemp, 2, '.', ' ') . ' m²';

        $stats->terrains_non_taxables_percentage = $stats->total_terrains_value > 0
            ? number_format(($stats->terrains_non_taxables_count / $stats->total_terrains_value) * 100, 2) . '%'
            : '0%';


        // Exonerations permanentes
        $exonerationsPermanentes = DB::table('terrains')->where('type', 'Exonerations permanentes')->get();
        $stats->exonerations_permanentes_count = $exonerationsPermanentes->count();
        $totalSurfaceExonerationTemp = $exonerationsPermanentes->sum('surface');
        $stats->exonerations_permanentes_surface = number_format($totalSurfaceExonerationTemp, 2, '.', ' ') . ' m²';

        $stats->exonerations_permanentes_percentage = $stats->total_terrains_value > 0
            ? number_format(($stats->exonerations_permanentes_count / $stats->total_terrains_value) * 100, 2) . '%'
            : '0%';


        //operations
        $stats->exonerations_temporaires_construction_count = DB::table('terrains')
            ->join('terrain_operations', 'terrains.id', '=', 'terrain_operations.terrain_id')
            ->where('terrains.type', 'Exonerations temporaires')
            ->where('terrain_operations.operation_motif', 'construction')
            ->distinct()
            ->count('terrains.id');

        $stats->exonerations_temporaires_lotissement_count = DB::table('terrains')
            ->join('terrain_operations', 'terrains.id', '=', 'terrain_operations.terrain_id')
            ->where('terrains.type', 'Exonerations temporaires')
            ->where('terrain_operations.operation_motif', 'lotissement')
            ->distinct()
            ->count('terrains.id');

        // ADD ZONES

        // Zone: Faiblement équipées
        $zoneFaiblement = DB::table('zones')
            ->where('nom', 'Faiblement équipées')
            ->where('annee', $currentYear)
            ->first();
        $stats->zones_faiblement_count = 0;
        $stats->zones_faiblement_percentage = '0%';

        if ($zoneFaiblement) {
            $stats->zones_faiblement_count = DB::table('terrains_zones')
                ->where('zone_id', $zoneFaiblement->id)
                ->distinct()
                ->count('terrain_id');

            $stats->zones_faiblement_percentage = $stats->total_terrains_value > 0
                ? number_format(($stats->zones_faiblement_count / $stats->total_terrains_value) * 100, 2) . '%'
                : '0%';
        }
        // Zone: Moyennement équipées
        $zoneMoyennement = DB::table('zones')
            ->where('nom', 'Moyennement équipées')
            ->where('annee', $currentYear)
            ->first();
        $stats->zones_moyennement_count = 0;
        $stats->zones_moyennement_percentage = '0%';

        if ($zoneMoyennement) {
            $stats->zones_moyennement_count = DB::table('terrains_zones')
                ->where('zone_id', $zoneMoyennement->id)
                ->distinct()
                ->count('terrain_id');

            $stats->zones_moyennement_percentage = $stats->total_terrains_value > 0
                ? number_format(($stats->zones_moyennement_count / $stats->total_terrains_value) * 100, 2) . '%'
                : '0%';
        }
        // Zone: Bien équipées
        $zoneBien = DB::table('zones')
            ->where('nom', 'Bien équipées')
            ->where('annee', $currentYear)
            ->first();

        $stats->zones_bien_count = 0;
        $stats->zones_bien_percentage = '0%';

        if ($zoneBien) {
            $stats->zones_bien_count = DB::table('terrains_zones')
                ->where('zone_id', $zoneBien->id)
                ->distinct()
                ->count('terrain_id');

            $stats->zones_bien_percentage = $stats->total_terrains_value > 0
                ? number_format(($stats->zones_bien_count / $stats->total_terrains_value) * 100, 2) . '%'
                : '0%';
        }
        return $stats;
    }


    public function index_terrains_liquidations(Request $request)
    {
        $stats        = new stdClass();
        $yearParam    = $request->query('year'); // '2024' or 'all'
        $isAllYears   = !$yearParam || strtolower($yearParam) === 'all';
        $totalTerrains = (int) DB::table('terrains')->count();
        // Apply year filter using DATE column
        $applyYear = function ($q) use ($isAllYears, $yearParam) {
            if (!$isAllYears) {
                $q->whereYear('date', (int) $yearParam);
            }
            return $q;
        };
        // Count terrains with at least one PAID liquidation in the scope
        $withPaid = (int) DB::table('liquidations')
            ->where('paid', 1)
            ->tap($applyYear)
            ->distinct('id_terrain')
            ->count('id_terrain');
        // Without paid is the complement for that scope
        $withoutPaid = max(0, $totalTerrains - $withPaid);
        // Sum montant for PAID liquidations only (respecting the same scope)
        $totalPaid = (float) DB::table('liquidations')
            ->where('paid', 1)
            ->tap($applyYear)
            ->sum('montant');
        // EXACT KEYS expected by your JS (numeric values)
        $stats->total_liquidation_value        = $totalPaid;              // number
        $stats->number_terrain_liquidation_value = $withPaid;            // number
        $stats->number_terrain_liquidation_reste = $withoutPaid;         // number
        $stats->number_terrain_liquidation_percent = $totalTerrains > 0
            ? round(($withPaid / $totalTerrains) * 100, 2)               // number, not string
            : 0;
        // Optional extra metadata (won’t break your JS)
        $stats->year           = $isAllYears ? 'all' : (int) $yearParam;
        $stats->total_terrains = $totalTerrains;
        // If you want per-year breakdown when year=all (optional):
        if ($isAllYears) {
            $stats->by_year = DB::table('liquidations')
                ->selectRaw('YEAR(`date`) as year, COUNT(DISTINCT id_terrain) as with_paid, SUM(montant) as total_paid')
                ->where('paid', 1)
                ->whereNotNull('date')
                ->groupByRaw('YEAR(`date`)')
                ->orderBy('year')
                ->get()
                ->map(function ($row) use ($totalTerrains) {
                    $withPaidY = (int) ($row->with_paid ?? 0);
                    return [
                        'year'         => (int) $row->year,
                        'with_paid'    => $withPaidY,
                        'without_paid' => max(0, $totalTerrains - $withPaidY),
                        'total_paid'   => (float) ($row->total_paid ?? 0.0),
                    ];
                })
                ->values();
        }
        return response()->json($stats);
    }


    public function terrain_types_chart(Request $request)
    {
        // Get terrain types with their counts
        $terrainTypes = DB::table('terrains')
            ->select('type', DB::raw('count(*) as total'))
            ->groupBy('type')
            ->orderBy('total', 'desc')
            ->get();

        $data = [];
        $values = [];

        foreach ($terrainTypes as $type) {
            // Use the type directly since they're already in French
            $data[] = $type->type;
            $values[] = (int) $type->total;
        }

        return response()->json([
            'data' => $data,
            'values' => $values
        ]);
    }



    public function declarations_chart(Request $request)
    {
        // Get declarations for current year, grouped by month
        $declarations = DB::table('declarations')
            ->selectRaw('MONTH(date) as month, MONTHNAME(date) as month_name, COUNT(*) as count')
            ->whereYear('date', date('Y'))
            ->groupBy('month', 'month_name')
            ->orderBy('month', 'asc')
            ->get();

        // Prepare data arrays
        $data = [];
        $values = [];

        // Create all months for current year (1-12)
        $months = [
            1 => 'Jan',
            2 => 'Fév',
            3 => 'Mar',
            4 => 'Avr',
            5 => 'Mai',
            6 => 'Jun',
            7 => 'Jul',
            8 => 'Aoû',
            9 => 'Sep',
            10 => 'Oct',
            11 => 'Nov',
            12 => 'Déc'
        ];

        // Initialize all months with 0
        $monthlyData = [];
        foreach ($months as $monthNum => $monthName) {
            $monthlyData[$monthNum] = 0;
        }

        // Fill with actual data
        foreach ($declarations as $declaration) {
            $monthlyData[$declaration->month] = (int) $declaration->count;
        }

        // Convert to arrays for chart
        foreach ($monthlyData as $monthNum => $count) {
            $data[] = $months[$monthNum];
            $values[] = $count;
        }

        return response()->json([
            'data' => $data,
            'values' => $values,
            'total' => array_sum($values),
            'success' => true
        ]);
    }



    private function generateDateRange(Carbon $start_date, Carbon $end_date)
    {
        $dates = [];

        for ($date = $start_date->copy(); $date->lte($end_date); $date->addDay()) {
            $dates[] =  Carbon::createFromFormat('Y-m-d', $date->format('Y-m-d'))->endOfDay();;
        }

        return $dates;
    }



    function  stat_col($title, $main_value, $percentage_1, $percentage_2, $back_color, $text_color, $fa_icon, $class = '')
    {
        return [
            'title' => $title,
            'main_value' => $main_value,
            'percentage_1' => $percentage_1,
            'percentage_2' => $percentage_2,
            'back_color' => $back_color,
            'text_color' => $text_color,
            'fa-icon' => $fa_icon,
            'class' => $class
        ];
    }







    public function etat_index(string $etat)
    {
        if ($etat == 'Demande validée') {
            return 0;
        }
        if ($etat == "Demande d'autorisation déposée") {
            return 1;
        }
        if ($etat == "Autorisation de construire déposée") {
            return 2;
        }
        if ($etat == "Pv d'ouverture de chantier déposé") {
            return 3;
        }
        if ($etat == "Réception des fondations déposé") {
            return 4;
        }
        if ($etat == "Permis d'habiter déposé") {
            return 5;
        }
    }

    public function check_etat_actuel()
    {
        $dossiers = Dossier::select('dossiers.*')->where('active', 1)->join('douars', 'dossiers.douar_id', '=', 'douars.id');
        $dossiers = $dossiers->get();

        $result = new stdClass();
        $result->autorisations_octroyees = 0;
        $result->autorisations_octroyees_error = [];

        foreach ($dossiers as $dossier) {
            if ($this->etat_index($dossier->etat_actuel) >= 2) {
                $result->autorisations_octroyees++;
                $autorisation_construire = $dossier->specific_document("AUTORISATION_CONSTRUIRE");

                if (is_null($autorisation_construire)) {
                    $result->autorisations_octroyees_error[] = $dossier->id;
                }
            }
        }
        return  $result;
    }

    public function prestatraires_stat(Request $request)
    {

        $stats = new stdClass();

        $users = User::where([['active', 1]]);
        if ($request->role != 'all') {
            $users = $users->where('role_id', $request->role);
        } else {
            $users = $users->whereIn('role_id', [
                'cccfaaf5-9e6e-45eb-bbd3-0f813a085791',
                'f652fd43-e591-4562-9220-ce2ab98542af',
                '29a4359b-52c1-486b-8ede-b5fcda314a8b',
                '77970795-73b6-4f2f-8e4c-e97d25636598'
            ]);
        }
        $users = $users->get();

        $total = 0;
        $affectes = 0;
        $manifistation_interet = 0;
        $contractuels = 0;

        $province = null;
        if ($request->province != 'all') {
            $province = Province::where('id', $request->province)->get()->first();
        }
        foreach ($users as $user) {
            $total++;
            if ($user->affecte()) {
                $affectes++;
            }

            if ($request->province == 'all') {
                foreach ($user->etat_engagements as $etat_engagement) {
                    if ($etat_engagement->etat == 'Manifestation d’intérêt') {
                        $manifistation_interet++;
                        break;
                    }
                }
                foreach ($user->etat_engagements as $etat_engagement) {
                    if ($etat_engagement->etat == 'Contractuel') {
                        $contractuels++;
                        break;
                    }
                }
            } else {
                foreach ($user->etat_engagements as $etat_engagement) {
                    if ($etat_engagement->etat == 'Manifestation d’intérêt' && $etat_engagement->filiale_id == $province->filiale_id) {
                        $manifistation_interet++;
                        break;
                    }
                }
                foreach ($user->etat_engagements as $etat_engagement) {
                    if ($etat_engagement->etat == 'Contractuel'  && $etat_engagement->filiale_id == $province->filiale_id) {
                        $contractuels++;
                        break;
                    }
                }
            }
        }


        $stats->total = $total;
        $stats->affectes = $affectes;
        $stats->non_affectes = $total - $affectes;
        $stats->manifistation_interet = $manifistation_interet;
        $stats->contractuels = $contractuels;
        return  $stats;
    }

    public function demandes_chart(Request $request)
    {
        $stats = new stdClass();
        $demandes_data = [];


        $demandes = Demande::select('demandes.created_at')->where('demandes.active', 1);
        $demandes->where('enquete', 0);

        $dossiers_rehab = Dossier_rehab::select('created_at', 'filiale_id', 'province_id')->where('active', 1);

        if (Auth::user()->role->name == "Administrateur") {
            $demandes =  $demandes->where('filiale_id', Auth::user()->filiale_id);
            $dossiers_rehab =  $dossiers_rehab->where('filiale_id', Auth::user()->filiale_id);
        }

        if (Auth::user()->role->name == "Administrateur") {
            $demandes = $demandes->where('demandes.filiale_id', Auth::user()->filiale_id);
            $dossiers_rehab =  $dossiers_rehab->where('filiale_id', Auth::user()->filiale_id);
        }
        if (Auth::user()->role->name == "Observateur filiale") {

            if (!is_null(Auth::user()->province_id)) {
                $demandes =  $demandes->where('demandes.province_id', Auth::user()->province_id);
                $dossiers_rehab =  $dossiers_rehab->where('province_id', Auth::user()->province_id);
            } else {
                $demandes =  $demandes->where('demandes.filiale_id', Auth::user()->filiale_id);
                $dossiers_rehab =  $dossiers_rehab->where('filiale_id', Auth::user()->filiale_id);
            }
        }
        if (Auth::user()->role->name == "Agence urbaine") {
            $demandes = $demandes->where('demandes.filiale_id', Auth::user()->filiale_id);
            $dossiers_rehab =  $dossiers_rehab->where('filiale_id', Auth::user()->filiale_id);
        }


        if ($request->province != 'all') {

            $demandes = $demandes->where('province_id', $request->province);
            $dossiers_rehab =  $dossiers_rehab->where('province_id', $request->province);
        }


        $demandes = $demandes->get();
        $dossiers_rehab = $dossiers_rehab->get();

        foreach ($demandes as $demande) {

            $date_demande = Carbon::createFromFormat('Y-m-d H:i:s', $demande->created_at)->endOfDay();

            $exists = false;
            foreach ($demandes_data as $row) {
                if ($row->date == $date_demande) {
                    $exists = true;
                    $row->value++;
                    break;
                }
            }
            if (!$exists) {
                $row = new stdClass();
                $row->date = $date_demande;
                $row->value = 1;
                $demandes_data[] = $row;
            }
        }

        foreach ($dossiers_rehab as $dossier_rehab) {

            $date_demande = Carbon::createFromFormat('Y-m-d H:i:s', $dossier_rehab->created_at)->endOfDay();

            $exists = false;
            foreach ($demandes_data as $row) {
                if ($row->date == $date_demande) {
                    $exists = true;
                    $row->value++;
                    break;
                }
            }
            if (!$exists) {
                $row = new stdClass();
                $row->date = $date_demande;
                $row->value = 1;
                $demandes_data[] = $row;
            }
        }

        $stats->data = [];
        $stats->values = [];

        if (count($demandes_data) > 0) {
            $min_date = $demandes_data[0]->date;
            $max_date = $demandes_data[0]->date;
            foreach ($demandes_data as $row) {

                if ($row->date->lessThan($min_date)) {
                    $min_date = $row->date;
                }

                if ($row->date->greaterThan($max_date)) {
                    $max_date = $row->date;
                }
            }
            $dates =  $this->generateDateRange($min_date, $max_date);


            foreach ($dates as  $date) {
                $stats->data[] = $date->format('d/m/Y');
                $value = 0;
                foreach ($demandes_data as $row) {
                    if ($row->date->eq($date)) {
                        $value = $row->value;
                    }
                }
                $stats->values[] = $value;
            }
        }
        return  $stats;
    }

    public function autorisations_chart(Request $request)
    {
        $stats = new stdClass();
        $stats->data = [];
        $stats->values = [];

        $chart_autorisations_rows = DB::Table('chart_autorisations')->orderBy('date_db', 'asc')->get();

        foreach ($chart_autorisations_rows  as $row) {

            if (Auth::user()->role->name == "Administrateur") {
                if ($row->filiale_id != Auth::user()->filiale_id) {
                    continue;
                }
            }

            if (Auth::user()->role->name == "Observateur filiale") {

                if (!is_null(Auth::user()->province_id)) {

                    if ($row->province != Auth::user()->province_id) {
                        continue;
                    }
                } else {

                    if ($row->filiale_id != Auth::user()->filiale_id) {
                        continue;
                    }
                }
            }

            if (Auth::user()->role->name == "Agence urbaine") {
                if ($row->filiale_id != Auth::user()->filiale_id) {
                    continue;
                }
            }
            if ($request->province != 'all') {

                if ($row->province != $request->province) {
                    continue;
                }
            }
            $exists = false;
            for ($i = 0; $i < count($stats->data); $i++) {
                if ($stats->data[$i] == $row->date) {
                    $exists = true;
                    $stats->values[$i] += $row->value;
                }
            }
            if ($exists == false) {
                $stats->data[] = $row->date;
                $stats->values[] = $row->value;
            }
        }
        return  $stats;
    }

    public function calc_autorisations_chart_province($province_id, $filiale_id)
    {
        $stats = new stdClass();

        $autorisations_data = [];

        $documents = Dossier_document::with('dossier')->where([['type_document', 'AUTORISATION_CONSTRUIRE']])->where('active', 1)->whereNotNull('dossier_id')->groupBy('dossier_id')->get();


        foreach ($documents as $document) {

            if (is_null($document->dossier)) {
                continue;
            }
            if ($document->dossier->province_id  != $province_id && $province_id != 'all') {
                continue;
            }


            $date_document = Carbon::createFromFormat('Y-m-d H:i:s', $document->created_at)->endOfDay();
            $exists = false;
            foreach ($autorisations_data as $row) {
                if ($row->date == $date_document) {
                    $exists = true;
                    $row->value++;
                    break;
                }
            }
            if (!$exists) {
                $row = new stdClass();
                $row->date = $date_document;
                $row->value = 1;
                $autorisations_data[] = $row;
            }
        }

        if (count($autorisations_data) > 0) {
            $min_date = $autorisations_data[0]->date;
            $max_date = $autorisations_data[0]->date;
            foreach ($autorisations_data as $row) {

                if ($row->date->lessThan($min_date)) {
                    $min_date = $row->date;
                }

                if ($row->date->greaterThan($max_date)) {
                    $max_date = $row->date;
                }
            }
            $dates =  $this->generateDateRange($min_date, $max_date);


            foreach ($dates as  $date) {
                $stats->data[] = $date->format('d/m/Y');
                $value = 0;
                foreach ($autorisations_data as $row) {
                    if ($row->date->eq($date)) {
                        $value = $row->value;
                    }
                }
                $stats->values[] = $value;
            }
        }

        $rows = [];
        for ($i = 0; $i < count($stats->data); $i++) {
            $date_db = $stats->data[$i];
            $date_db = explode('/', $date_db)[2] . '-' . explode('/', $date_db)[1] . '-' . explode('/', $date_db)[0];

            $rows[] = ['filiale_id' => $filiale_id, 'province' => $province_id, 'date' => $stats->data[$i], 'date_db' =>  $date_db, 'value' => $stats->values[$i]];
        }

        return  $rows;
    }

    public function calc_autorisations_chart()
    {


        $provinces = Province::all();
        $rows = [];
        foreach ($provinces as $province) {
            $result = self::calc_autorisations_chart_province($province->id, $province->filiale_id);

            foreach ($result as $c_row) {
                $rows[] = $c_row;
            }
        }
        // $result = self::calc_autorisations_chart_province('all', 'all');
        // foreach ($result as $c_row) {
        //     $rows[] = $c_row;
        // }

        DB::table('chart_autorisations')->truncate();
        DB::table('chart_autorisations')->insert($rows);


        // foreach ($documents as $document) {
        //     if (is_null($document->dossier)) {
        //         continue;
        //     }
        //     if (Auth::user()->role->name == "Administrateur") {
        //         if ($document->dossier->filiale_id != Auth::user()->filiale_id) {
        //             continue;
        //         }
        //     }

        //     if (Auth::user()->role->name == "Observateur filiale") {

        //         if (!is_null(Auth::user()->province_id)) {

        //             if ($document->dossier->province_id != Auth::user()->province_id) {
        //                 continue;
        //             }
        //         } else {

        //             if ($document->dossier->filiale_id != Auth::user()->filiale_id) {
        //                 continue;
        //             }
        //         }
        //     }

        //     if (Auth::user()->role->name == "Agence urbaine") {
        //         if ($document->dossier->filiale_id != Auth::user()->filiale_id) {
        //             continue;
        //         }
        //     }



        //     if ($request->province != 'all') {
        //         if ($document->dossier->province_id != $request->province) {
        //             continue;
        //         }
        //     }

        //     $date_document = Carbon::createFromFormat('Y-m-d H:i:s', $document->created_at)->endOfDay();

        //     $exists = false;
        //     foreach ($autorisations_data as $row) {
        //         if ($row->date == $date_document) {
        //             $exists = true;
        //             $row->value++;
        //             break;
        //         }
        //     }
        //     if (!$exists) {
        //         $row = new stdClass();
        //         $row->date = $date_document;
        //         $row->value = 1;
        //         $autorisations_data[] = $row;
        //     }
        // }


        // $stats->data = [];
        // $stats->values = [];

        // if (count($autorisations_data) > 0) {
        //     $min_date = $autorisations_data[0]->date;
        //     $max_date = $autorisations_data[0]->date;
        //     foreach ($autorisations_data as $row) {

        //         if ($row->date->lessThan($min_date)) {
        //             $min_date = $row->date;
        //         }

        //         if ($row->date->greaterThan($max_date)) {
        //             $max_date = $row->date;
        //         }
        //     }
        //     $dates =  $this->generateDateRange($min_date, $max_date);


        //     foreach ($dates as  $date) {
        //         $stats->data[] = $date->format('d/m/Y');
        //         $value = 0;
        //         foreach ($autorisations_data as $row) {
        //             if ($row->date->eq($date)) {
        //                 $value = $row->value;
        //             }
        //         }
        //         $stats->values[] = $value;
        //     }
        // }
    }

    public function avis_favorables_chart(Request $request)
    {
        $stats = new stdClass();
        $dossiers_data = [];

        $dossiers = Dossier::where('active', 1);
        $dossiers = $dossiers->whereNotNull('commission_id');

        if ($request->province != 'all') {

            $dossiers = $dossiers->where('province_id', $request->province);
        }

        $dossiers = $dossiers->get();

        foreach ($dossiers as $dossier) {

            $date_demande = Carbon::createFromFormat('Y-m-d', $dossier->commission->date)->endOfDay();

            $exists = false;
            foreach ($dossiers_data as $row) {
                if ($row->date == $date_demande) {
                    $exists = true;
                    $row->value++;
                    break;
                }
            }
            if (!$exists) {
                $row = new stdClass();
                $row->date = $date_demande;
                $row->value = 1;
                $dossiers_data[] = $row;
            }
        }

        $stats->data = [];
        $stats->values = [];

        if (count($dossiers_data) > 0) {
            $min_date = $dossiers_data[0]->date;
            $max_date = $dossiers_data[0]->date;
            foreach ($dossiers_data as $row) {

                if ($row->date->lessThan($min_date)) {
                    $min_date = $row->date;
                }

                if ($row->date->greaterThan($max_date)) {
                    $max_date = $row->date;
                }
            }
            $dates =  $this->generateDateRange($min_date, $max_date);


            foreach ($dates as  $date) {
                $stats->data[] = $date->format('d/m/Y');
                $value = 0;
                foreach ($dossiers_data as $row) {
                    if ($row->date->eq($date)) {
                        $value = $row->value;
                    }
                }
                $stats->values[] = $value;
            }
        }
        return  $stats;
    }

    public function overtures_chantier_chart(Request $request)
    {
        $stats = new stdClass();
        $dossiers_data = [];

        $dossiers = Dossier::where('active', 1);
        //$dossiers = $dossiers->whereNotNull('commission_id');

        if ($request->province != 'all') {

            $dossiers = $dossiers->where('province_id', $request->province);
        }

        $dossiers = $dossiers->get();

        foreach ($dossiers as $dossier) {
            $overture_chantier = $dossier->specific_document('OVERTURE_CHANTIER');

            if (!is_null($overture_chantier)) {
                $date_demande = Carbon::createFromFormat('Y-m-d', $overture_chantier->date_document)->endOfDay();

                $exists = false;
                foreach ($dossiers_data as $row) {
                    if ($row->date == $date_demande) {
                        $exists = true;
                        $row->value++;
                        break;
                    }
                }
                if (!$exists) {
                    $row = new stdClass();
                    $row->date = $date_demande;
                    $row->value = 1;
                    $dossiers_data[] = $row;
                }
            }
        }

        $stats->data = [];
        $stats->values = [];

        if (count($dossiers_data) > 0) {
            $min_date = $dossiers_data[0]->date;
            $max_date = $dossiers_data[0]->date;
            foreach ($dossiers_data as $row) {

                if ($row->date->lessThan($min_date)) {
                    $min_date = $row->date;
                }

                if ($row->date->greaterThan($max_date)) {
                    $max_date = $row->date;
                }
            }
            $dates =  $this->generateDateRange($min_date, $max_date);


            foreach ($dates as  $date) {
                $stats->data[] = $date->format('d/m/Y');
                $value = 0;
                foreach ($dossiers_data as $row) {
                    if ($row->date->eq($date)) {
                        $value = $row->value;
                    }
                }
                $stats->values[] = $value;
            }
        }


        return  $stats;
    }
}
