<?php

namespace App\Http\Controllers;

use App\Models\DeclarationNumber;
use App\Models\Proprietaire;
use App\Models\Proprietaire_document;
use Illuminate\Http\Request;
use App\Models\Terrain;
use App\Models\Liquidation;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Services\TNBPDFService;
use Response;

class DeclarationsController extends Controller
{

    protected $pdfService;

    public function __construct(TNBPDFService $pdfService)
    {
        $this->pdfService = $pdfService;
    }


    // public function generatePdf(Request $request)
    // {
    //     // Decode the formatted JSON data
    //     $terrain = Terrain::with(['zones','proprietaires'])->where('id', $request->input('terrain_id'))->get()->first();      
    //     $data = [
    //         'terrain' => $terrain,
    //     ];
    //     $pdf = Pdf::loadView('terrains.declaration_pdf', $data)->setPaper('a4');
    //     return $pdf->stream('declaration_document.pdf');
    // }


    public function generatePdf(Request $request)
    {
        if ($request->has('terrain_id')) {
            // Generate PDF for single terrain
            $terrains = Terrain::with('proprietaires')->where('id', $request->input('terrain_id'))->get();
        } else {
            
            $terrains = Terrain::with('proprietaires')->orderBy('article')->get();
        }

        // get declaration number

        $next_number = DeclarationNumber::getNextNumber();
       

        return $this->pdfService->generateTerrainDeclaration($terrains,$next_number);
    }
}
