<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\Index;

class Indexing extends Controller
{

    public function store($type)
    {
        $now = Carbon::now();
        $index = new Index();
        $index->id = Str::uuid();
        $index->user_id = Auth::user()->id;
        $index->type = $type;
        $index->year = $now->year;

        $last_numero = Index::where([['type', $index->type], ['year', $index->year]])->max('numero');
        $index->numero =   $last_numero + 1;
        $index->save();

        return  $index;
    }
}
