<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class InvitationController extends Controller
{

    public function show(string $user_id, string $token)
    {
        $user = User::where('id', $user_id)->first();
        if ($user->validation_read_date == null) {
            $user->validation_read_date = Carbon::now();
            $user->save();
        }

        if ($user == null) {
            abort(404);
        }
        if ($user->token != $token) {
            abort(404);
        }
        return view('invitation.show', [

            'user' => $user,
            'token' => $token,
        ]);
    }

    public function invitation_save_pwd(Request $request)
    {

        $req = $request->all();
        $user_id = $req['user_id'];
        $token = $req['token'];
        $password = $req['password'];
        $confirmation_password = $req['password_confirmation'];


        $user = User::where('id', $user_id)->first();

        if (strlen(trim($password)) < 8) {
            return response()->json(['success' =>  0, "message" => "Le mot de passe doit comporter au moins 8 caractères en longueur."]);
        }
        if ($password != $confirmation_password) {
            return response()->json(['success' =>  0, "message" => "Mots de passes ne correspondent pas"]);
        }
        if ($user != null) {
            if ($user->token == null) {
                return response()->json(['success' =>  0, "message" => "Lien d'invitation expiré."]);
            }

            if ($user->token == $token) {
                $user->token = null;
                $user->password = Hash::make($password);
                $user->validation_completed_date = Carbon::now();
                $user->save();
                return response()->json(['success' =>  1]);
            } else {
                return response()->json(['success' =>  0, "message" => "Invalid token"]);
            }
        } else {
            return response()->json(['success' =>  0, "message" => "Invalid user_id"]);
        }
    }
}
