<?php

namespace App\Http\Controllers;

use App\Models\Proprietaire;
use App\Models\Proprietaire_document;
use Illuminate\Http\Request;
use App\Models\Terrain;
use App\Models\Liquidation;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf;
use Response;

class LiquidationsController extends Controller
{

    public function generatePdf(Request $request)
    {
        // Decode the formatted JSON data
        $terrain = Terrain::with(['zones','proprietaires'])->where('id', $request->input('terrain_id'))->get()->first();
        $formattedSanctions = json_decode($request->input('sanctions'), true);
        $montant_initial = $request->input('montant_initial');
        $montant_sanctions = $request->input('montant_sanctions');
        $montant_total = $request->input('montant_total');
        $data = [
            'sanctionsData' => $formattedSanctions,
            'montant_initial' => $montant_initial,
            'montant_sanctions' => $montant_sanctions,
            'montant_total' => $montant_total,
            'terrain' => $terrain,
        ];
        $pdf = Pdf::loadView('terrains.liquidation_pdf', $data)->setPaper('a4', 'landscape');
        return $pdf->stream('liquidation_document.pdf');
    }
}
