<?php

namespace App\Http\Controllers;

use App\Models\Petitionnaire_mi;
use App\Models\Dossier;
use App\Models\Dossier_rehab;
use App\Models\Douar;
use Illuminate\Http\Request;
use Response;
use Carbon\Carbon;
use App\Models\Fichier_echange;
use App\Models\ListeCheque;
use DataTables;
use Illuminate\Support\Str;
use stdClass;

class ListesChequesController extends Controller
{
    private $MI1_key = 'ED417DCB54BFFB55816D3F61D7FBB018';
    private $MI2_key = 'ED417DCB54BFFB55816D3F61D7FBB018';

    public function index()
    {
        return view('echangemi.index', []);
    }



    public function get_cheques_liste_data(Request $request)
    {

        $liste_cheque = ListeCheque::where('id', $request->liste_cheque_id)->get()->first();

        $dossiers = Dossier::with(['petitionnaires', 'douar'])->get();

        $dossiers_rehab = Dossier_rehab::with(['petitionnaires', 'douar'])->get();

        $response = new stdClass();
        $response->liste_cheque = $liste_cheque;
        $response->evacuation = [];
        $response->af1 = [];
        $response->af2 = [];
        $response->af3 = [];
        $response->af4 = [];

        $response->liste_cheque->created_at_timestamp = Carbon::createFromFormat('Y-m-d H:i:s', $response->liste_cheque->created_at)->timestamp;

        foreach ($dossiers as $dossier) {
            if ($dossier->cheque_evacuation_etat == "En attente") {
                $arrondissement = $dossier->douar ? $dossier->douar->nom : 'N/A';
                $petitionnaires = $dossier->petitionnaires;

                foreach ($petitionnaires as $petitionnaire) {
                    $response->evacuation[] = [
                        'nom' => $petitionnaire->nom,
                        'prenom' => $petitionnaire->prenom,
                        'cin' => $petitionnaire->cin,
                        'dossier_numero' => $dossier->numero,
                        'arrondissement' => $arrondissement
                    ];
                }
            }
            if ($dossier->cheque_af1_etat == "En attente") {
                $arrondissement = $dossier->douar ? $dossier->douar->nom : 'N/A';
                $petitionnaires = $dossier->petitionnaires;
                $petitionnaires = $petitionnaires->where('is_principal', 1);

                foreach ($petitionnaires as $petitionnaire) {
                    $response->af1[] = [
                        'nom' => $petitionnaire->nom,
                        'prenom' => $petitionnaire->prenom,
                        'cin' => $petitionnaire->cin,
                        'dossier_numero' => $dossier->numero,
                        'arrondissement' => $arrondissement
                    ];
                }
            }

            if ($dossier->cheque_af2_etat == "En attente") {
                $arrondissement = $dossier->douar ? $dossier->douar->nom : 'N/A';
                $petitionnaires = $dossier->petitionnaires;
                $petitionnaires = $petitionnaires->where('is_principal', 1);

                foreach ($petitionnaires as $petitionnaire) {
                    $response->af2[] = [
                        'nom' => $petitionnaire->nom,
                        'prenom' => $petitionnaire->prenom,
                        'cin' => $petitionnaire->cin,
                        'dossier_numero' => $dossier->numero,
                        'arrondissement' => $arrondissement
                    ];
                }
            }

            if ($dossier->cheque_af3_etat == "En attente") {
                $arrondissement = $dossier->douar ? $dossier->douar->nom : 'N/A';
                $petitionnaires = $dossier->petitionnaires;
                $petitionnaires = $petitionnaires->where('is_principal', 1);

                foreach ($petitionnaires as $petitionnaire) {
                    $response->af3[] = [
                        'nom' => $petitionnaire->nom,
                        'prenom' => $petitionnaire->prenom,
                        'cin' => $petitionnaire->cin,
                        'dossier_numero' => $dossier->numero,
                        'arrondissement' => $arrondissement
                    ];
                }
            }

            if ($dossier->cheque_af4_etat == "En attente") {
                $arrondissement = $dossier->douar ? $dossier->douar->nom : 'N/A';
                $petitionnaires = $dossier->petitionnaires;
                $petitionnaires = $petitionnaires->where('is_principal', 1);

                foreach ($petitionnaires as $petitionnaire) {
                    $response->af4[] = [
                        'nom' => $petitionnaire->nom,
                        'prenom' => $petitionnaire->prenom,
                        'cin' => $petitionnaire->cin,
                        'dossier_numero' => $dossier->numero,
                        'arrondissement' => $arrondissement
                    ];
                }
            }
        }


        foreach ($dossiers_rehab as $dossier) {
            if ($dossier->cheque_evacuation_etat == "En attente") {
                $arrondissement = $dossier->douar ? $dossier->douar->nom : 'N/A';
                $petitionnaires = $dossier->petitionnaires;

                foreach ($petitionnaires as $petitionnaire) {
                    $response->evacuation[] = [
                        'nom' => $petitionnaire->nom,
                        'prenom' => $petitionnaire->prenom,
                        'cin' => $petitionnaire->cin,
                        'dossier_numero' => $dossier->numero,
                        'arrondissement' => $arrondissement
                    ];
                }
            }
            if ($dossier->cheque_af1_etat == "En attente") {
                $arrondissement = $dossier->douar ? $dossier->douar->nom : 'N/A';
                $petitionnaires = $dossier->petitionnaires;
                $petitionnaires = $petitionnaires->where('is_principal', 1);

                foreach ($petitionnaires as $petitionnaire) {
                    $response->af1[] = [
                        'nom' => $petitionnaire->nom,
                        'prenom' => $petitionnaire->prenom,
                        'cin' => $petitionnaire->cin,
                        'dossier_numero' => $dossier->numero,
                        'arrondissement' => $arrondissement
                    ];
                }
            }

            if ($dossier->cheque_af2_etat == "En attente") {
                $arrondissement = $dossier->douar ? $dossier->douar->nom : 'N/A';
                $petitionnaires = $dossier->petitionnaires;
                $petitionnaires = $petitionnaires->where('is_principal', 1);

                foreach ($petitionnaires as $petitionnaire) {
                    $response->af2[] = [
                        'nom' => $petitionnaire->nom,
                        'prenom' => $petitionnaire->prenom,
                        'cin' => $petitionnaire->cin,
                        'dossier_numero' => $dossier->numero,
                        'arrondissement' => $arrondissement
                    ];
                }
            }

            if ($dossier->cheque_af3_etat == "En attente") {
                $arrondissement = $dossier->douar ? $dossier->douar->nom : 'N/A';
                $petitionnaires = $dossier->petitionnaires;
                $petitionnaires = $petitionnaires->where('is_principal', 1);

                foreach ($petitionnaires as $petitionnaire) {
                    $response->af3[] = [
                        'nom' => $petitionnaire->nom,
                        'prenom' => $petitionnaire->prenom,
                        'cin' => $petitionnaire->cin,
                        'dossier_numero' => $dossier->numero,
                        'arrondissement' => $arrondissement
                    ];
                }
            }

            if ($dossier->cheque_af4_etat == "En attente") {
                $arrondissement = $dossier->douar ? $dossier->douar->nom : 'N/A';
                $petitionnaires = $dossier->petitionnaires;
                $petitionnaires = $petitionnaires->where('is_principal', 1);

                foreach ($petitionnaires as $petitionnaire) {
                    $response->af4[] = [
                        'nom' => $petitionnaire->nom,
                        'prenom' => $petitionnaire->prenom,
                        'cin' => $petitionnaire->cin,
                        'dossier_numero' => $dossier->numero,
                        'arrondissement' => $arrondissement
                    ];
                }
            }
        }

        return response()->json($response);
    }

    public function generate_liste_cheques()
    {
        $cmd = 'php ' . base_path('artisan') . ' app:export_liste_cheques > /dev/null &';
        $output = '';
        $pid = shell_exec($cmd);
        return Response::json(['success' => 1], 201);
    }

    public function listes_cheques_datatable(Request $request)
    {
        $filters = json_decode($request->filters);
        $listes_cheques = ListeCheque::orderBy('created_at', 'desc');
        foreach ($filters as $filter) {
        }

        return Datatables::eloquent($listes_cheques)

            ->addColumn('date', function ($liste_cheque) {
                return '<a class="liste_cheque_a" id="' . $liste_cheque->id . '" href="#"><b><i class="fa-solid fa-file-export"></i>&nbspListe cheques du ' . $liste_cheque->formated_created_at() . '</b></a>';
            })
            ->addColumn('progression', function ($liste_cheque) {
                if ($liste_cheque->pending == 1) {
                    return '<div class="progress" style="margin-top: 0px !important;">
                    <div class="progress-bar progress-bar-striped progress-bar-animated progress-bar-warning" role="progressbar" aria-valuenow="' . $liste_cheque->progression . '" aria-valuemin="0" aria-valuemax="100" style="width: ' . $liste_cheque->progression . '%"><b>' . $liste_cheque->progression . '%</b></div>
                    </div>';
                } else {
                    return '<div class="progress" style="margin-top: 0px !important;">
                    <div class="progress-bar " role="progressbar" aria-valuenow="' . $liste_cheque->progression . '" aria-valuemin="0" aria-valuemax="100" style="width: ' . $liste_cheque->progression . '%"><b>Términée</b></div>
                    </div>';
                }
            })
            ->addColumn('excel_file', function ($liste_cheque) {
                if ($liste_cheque->pending == 0) {
                    return '<button  echange_id="' . $liste_cheque->id . '" type="button" class="btn btn-success download_fichier_echange_xlsx"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>';
                } else {
                    return '<b style="color:#ecb013">En cours de génération...</b>';
                }
            })
            ->addColumn('decision', function ($liste_cheque) {
                return "-";
            })

            ->rawColumns(['date', 'progression', 'excel_file'])
            ->make(true);
    }

    public function download_xlsx(string $id)
    {
        $liste_cheque = new ListeCheque();

        $liste_cheque = ListeCheque::where('id',  $id)->get()->first();

        if (!is_null($liste_cheque)) {
            $file_path = base_path('files/liste_cheque/' . $id . '/list_cheque.xlsx');
            $headers = array(
                'Content-Type: application/xlsx',
            );
            return Response::download($file_path, "Liste des chèque " . $liste_cheque->formated_liste_created_at() . ".xlsx", $headers);
        } else {
            abort(404);
        }
    }

    public function download_txt(string $id)
    {
        $fichiers_echange = Fichier_echange::where('id',  $id)->get()->first();

        if (!is_null($fichiers_echange)) {
            $file_path = base_path('files/echanges_mi/' . $id . '/file.txt');
            $headers = array(
                'Content-Type: application/txt',
            );
            return Response::download($file_path, "Data_Batir_" . $fichiers_echange->formated_echange_created_at() . ".txt", $headers);
        } else {
            abort(404);
        }
    }

    public function download_xlsx_ea(string $id)
    {
        $fichiers_echange = Fichier_echange::where('id',  $id)->get()->first();

        if (!is_null($fichiers_echange)) {
            $file_path = base_path('files/echanges_mi/' . $id . '/ea_file.xlsx');
            $headers = array(
                'Content-Type: application/xlsx',
            );
            return Response::download($file_path, "Data_Batir_" . $fichiers_echange->formated_echange_created_at() . ".xlsx", $headers);
        } else {
            abort(404);
        }
    }

    public function download_txt_ea(string $id)
    {
        $fichiers_echange = Fichier_echange::where('id',  $id)->get()->first();

        if (!is_null($fichiers_echange)) {
            $file_path = base_path('files/echanges_mi/' . $id . '/file_ea.txt');
            $headers = array(
                'Content-Type: application/txt',
            );
            return Response::download($file_path, "Data_Batir_" . $fichiers_echange->formated_echange_created_at() . ".txt", $headers);
        } else {
            abort(404);
        }
    }

    public function get_fichier_echange(string $id)
    {
        $fichier_echange = Fichier_echange::where('id', $id)->get()->first();

        if (is_null($fichier_echange)) {
            abort(404);
        } else {
            return  $fichier_echange;
        }
    }

    public function exportV2()
    {

        $liste_cheque = new ListeCheque();
        $liste_cheque->id = Str::uuid();
        $liste_cheque->pending = 1;
        $liste_cheque->save();


        $target_dir = base_path('files/liste_cheque/' . $liste_cheque->id);

        if (!file_exists($target_dir)) {
            mkdir($target_dir);
        }

        $file_path = base_path('files/liste_cheque/' . $liste_cheque->id . '/list_cheque.xlsx');

        $cmd = 'mono ' . base_path('app/DocGEN/hmrpro_doc_gen.exe') . ' "' . $file_path . '" "' . $liste_cheque->id . '"';
        shell_exec($cmd);




        $liste_cheque->progression = 100;
        $liste_cheque->generated = 1;
        $liste_cheque->pending = 0;

        $liste_cheque->save();
    }


    public function documents_constructibilite_par_douar()
    {
        $douars = Douar::where('province_id', 'b5be7d0b-43cd-4ca9-9241-bd94d0dab842')->get();
        $result = [];

        foreach ($douars as $douar) {
            $row = new stdClass();
            $row->province = $douar->province->nom;
            $row->commune = $douar->commune->nom;
            $row->douar = $douar->nom; //ar

            $row->nb_autorisation = $douar->AUTORISATION_CONSTRUIRE_c;
            $row->nb_attestation_implantation = $douar->ATTESTATION_IMPLANTATION_c;
            $row->nb_ouverture_chantier = $douar->OVERTURE_CHANTIER_c;
            $row->nb_reception_fond_fouille = $douar->RECPTION_FONDS_FOUILLES_c;

            $row->nb_constructible = Dossier::where([['etude_geotechnique_area_constructible', '>', 0], ['douar_id', $douar->id]])->count();
            $row->nb_constructible_a_conditions = Dossier::where([['etude_geotechnique_area_constructible_conditions', '>', 0], ['douar_id', $douar->id]])->count();
            $row->nb_constructible_a_conditions_strictes = Dossier::where([['etude_geotechnique_area_constructible_conditions_strictes', '>', 0], ['douar_id', $douar->id]])->count();
            $row->nb_non_constructible = Dossier::where([['etude_geotechnique_area_non_constructible', '>', 0], ['douar_id', $douar->id]])->count();
            $row->nb_non_couvert = Dossier::where([['etude_geotechnique_area_non_couvert', '>', 0], ['douar_id', $douar->id]])->count();

            $result[] = $row;
        }
        return $result;
    }
}
