<?php

namespace App\Http\Controllers;

use App\Models\Proprietaire;
use App\Models\Proprietaire_document;
use Illuminate\Http\Request;
use App\Models\Terrain;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Response;

class ProprietairesController extends Controller
{

    public function check_proprietaire(Request $request)
    {
        $terrain_id = $request->input('terrain_id');
        $added_quote_part = $request->input('quote_part');

       
        $existing_sum = DB::table('proprietaire_terrain')
            ->where('terrain_id', $terrain_id)
            ->sum('quote_part');

       
        if (($existing_sum + $added_quote_part) != 1) {
            return Response::json(['success' => 0, 'error' => 'La somme des quotes-parts doit être égale à 1'], 200);          
        }

        return Response::json(['success' => 1], 200);
    }
  

    public function store_proprietaire_document(Request $request)
    {
        $files = $request->file('file');
        if ($files && is_array($files)) {

            foreach ($files as $index => $file) {
                if ($file) {

                    $fileName = $file->getClientOriginalName();
                    $proprietaire_doc = new Proprietaire_document();
                    $proprietaire_doc->id = Str::uuid();
                    $proprietaire_doc->filename =  $fileName;
                    $proprietaire_doc->nom = $fileName;
                    $proprietaire_doc->date_document = now()->toDateString();
                    $proprietaire_doc->file_type = Str::upper($file->getClientOriginalExtension());
                    $proprietaire_doc->file_size = $file->getSize();
                    $proprietaire_doc->type_document = "PROPRIETAIRE_DOC";
                    $proprietaire_doc->save();

                    $file->move("files/proprietaires_documents/" . $proprietaire_doc->id . "/", $fileName);

                    $proprietaire_doc->file_size_formated = $this->formatBytes($proprietaire_doc->file_size, 2);
                    $proprietaire_doc->created_at_formated = Carbon::createFromFormat('Y-m-d H:i:s',   $proprietaire_doc->created_at)->format('d/m/Y H:i');
                    return $proprietaire_doc;
                }
            }
        }
    }



    public function file(string $file_id)
    {
        $proprietaire_document = Proprietaire_document::where('id', $file_id)->get()->first();
        $headers = array(
            'Content-Type: application/pdf',
        );

        return Response::download($proprietaire_document->documentPath(), $proprietaire_document->filename, $headers);
    }

    public static function formatBytes($size, $precision = 2)
    {
        if ($size > 0) {
            $size = (int) $size;
            $base = log($size) / log(1024);
            $suffixes = array(' bytes', ' KB', ' MB', ' GB', ' TB');

            return round(pow(1024, $base - floor($base)), $precision) . $suffixes[floor($base)];
        } else {
            return $size;
        }
    }
}
