<?php

namespace App\Http\Controllers;

use App\Models\Douar;
use App\Models\User;
use App\Models\Demande;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use DataTables;
use stdClass;
use Response;
use App\Models\Guichet;
use App\Models\Province;
use App\Models\Commission;
use App\Models\Dossier;
use App\Mail\InvitationMail;
use App\Models\Etat_engagement;
use Illuminate\Support\Facades\Mail;

class StatisticsController extends Controller
{
    public function  etat_avancement(Request $request)
    {
        $date = $request->date;
        $filiale_id = $request->filiale_id;

        $provinces = Province::where('filiale_id', $filiale_id)->get();

        $data = [];
        foreach ($provinces as $province) {
            $province_id =  $province->id;

            $result = new stdClass();
            $result->province =  $province->nom;
            $result->date =  Carbon::createFromFormat('Y-m-d', $date)->format('d/m/Y');
            $result->Arrete_gouvernemental = 6;
            $result->guichets_crees = Guichet::where([['province_id',  $province_id], ['creation', 1], ['date_creation', $date]])->count();
            $result->demandes_autorisations =  Dossier::where([['province_id',  $province_id], ['active', 1]])->whereDate('created_at', $date)->count();
            $result->nombre_kit_en_cours_elaboration = 0;
            $result->nombre_kit_elabores = 0;
            $dossiers = Dossier::where([['province_id',  $province_id], ['active', 1]])->get();

            foreach ($dossiers as $dossier) {

                if (!is_null($dossier->specific_document('PLAN_COTE_PDF'))) {
                    if ($dossier->specific_document('PLAN_COTE_PDF')->decision == 'Validé') {
                        if (Carbon::createFromFormat('Y-m-d', $dossier->specific_document('PLAN_COTE_PDF')->date_document)->format('Y-m-d') == $date) {
                            $result->nombre_kit_en_cours_elaboration++;
                        }
                    }
                }

                if (!is_null($dossier->specific_document('RECEPISSE'))) {
                    if ($dossier->specific_document('RECEPISSE')->decision == 'Validé') {
                        if (Carbon::createFromFormat('Y-m-d', $dossier->specific_document('RECEPISSE')->date_document)->format('Y-m-d') == $date) {
                            $result->nombre_kit_elabores++;
                        }
                    }
                }
            }
            $commissions = [];
            $result->Commission_count =  0;
            $result->dossiers_avis_favorable =  0;
            foreach ($dossiers as $dossier) {
                if ($dossier->commission_id != null) {
                    if (!in_array($dossier->commission_id, $commissions)) {
                        $commissions[] = $dossier->commission_id;
                        $result->Commission_count++;
                    }

                    if ($dossier->commission_id != null) {
                        $result->dossiers_avis_favorable++;
                    }
                }
            }


            $communes_data = [];
            $result->communes_avec_demandes = 0;
            foreach ($dossiers as $dossier) {
                if (!in_array($dossier->commune_id, $communes_data)) {
                    $communes_data[] = $dossier->commune_id;

                    $result->communes_avec_demandes++;
                }
            }
            $result->dossiers_autorises =  0;

            foreach ($dossiers as $dossier) {
                if (!is_null($dossier->specific_document('AUTORISATION_CONSTRUIRE'))) {
                    if ($dossier->specific_document('AUTORISATION_CONSTRUIRE')->decision == 'Validé') {
                        if (Carbon::createFromFormat('Y-m-d', $dossier->specific_document('AUTORISATION_CONSTRUIRE')->date_document)->format('Y-m-d') == $date) {
                            $result->dossiers_autorises++;
                        }
                    }
                }
            }


            $result->dossiers_demarrage_travaux =  0;

            foreach ($dossiers as $dossier) {
                if (!is_null($dossier->specific_document('OVERTURE_CHANTIER'))) {
                    if ($dossier->specific_document('OVERTURE_CHANTIER')->decision == 'Validé') {
                        if (Carbon::createFromFormat('Y-m-d H:i:s', $dossier->specific_document('OVERTURE_CHANTIER')->date_document)->format('Y-m-d') == $date) {
                            $result->dossiers_demarrage_travaux++;
                        }
                    }
                }
            }
            $data[] = $result;
        }


        return $data;
    }

    public function stats_all(Request $request)
    {
        $date = $request->date;
        $filiale_id = $request->filiale_id;

        $demandes = Demande::where('active', 1)->get();
        $dossiers = Dossier::with('commission')->where('active', 1)->get();





        $stats = new stdClass();
        $stats->provinces_data = [];

        $provinces = Province::all();

        $stats->dv_total = 0;
        $stats->da_total = 0;
        $stats->avf_total = 0;
        $stats->pa_total = 0;

        $stats->c_total = 0;
        $stats->oc_total = 0;
        $stats->ph_total = 0;
        $stats->pp_total = 0;

        $stats->dj_total = 0;
        $stats->daj_total = 0;
        $stats->cj_total = 0;
        $stats->afj_total = 0;
        $stats->ocj_total = 0;
        $stats->phj_total = 0;


        foreach ($provinces as $province) {
            if($filiale_id!="all")
            {
                if ($province->filiale_id != $filiale_id) {
                    continue;
                }
            }
            
            $data = new stdClass();
            $data->province = $province;

            $data->dv = 0;
            $data->da = 0;
            $data->avf = 0;
            $data->pa = 0;
            $data->c = 0;
            $data->oc = 0;
            $data->ph = 0;
            $data->pp = 0;

            $data->dj = 0;
            $data->daj = 0;
            $data->cj = 0;
            $data->afj = 0;
            $data->ocj = 0;
            $data->phj = 0;



            foreach ($demandes as $demande) {
                if ($demande->province_id == $province->id) {
                    $data->dv++;

                    if (Carbon::createFromFormat('Y-m-d H:i:s', $demande->created_at)->format('Y-m-d') == $date) {
                        $data->dj++;
                    }
                }
            }



            $dossiers_commissions = [];

            foreach ($dossiers as $dossier) {
                if ($dossier->province_id == $province->id) {

                    $OVERTURE_CHANTIER = $dossier->specific_document('OVERTURE_CHANTIER');
                    $DEMANDE_AUTORISATION = $dossier->specific_document('DEMANDE_AUTORISATION');
                    $PERMIS_HABITER = $dossier->specific_document('PERMIS_HABITER');

                    if ($this->etat_index($dossier->etat_actuel) >= 1) {
                        $data->da++;

                        if (!is_null($DEMANDE_AUTORISATION)) {
                            if ($DEMANDE_AUTORISATION->decision == 'Validé') {
                                if ($DEMANDE_AUTORISATION->date_document == $date) {
                                    $data->daj++;
                                }
                            }
                        }
                    }
                    if ($dossier->commission_id != null) {
                        $data->avf++;
                        if ($dossier->commission != null) {
                            if ($dossier->commission->date == $date) {
                                $data->afj++;
                            }
                        }
                    }
                    if (!in_array($dossier->commission_id, $dossiers_commissions)) {
                        $dossiers_commissions[] = $dossier->commission_id;
                        $data->c++;

                        if ($dossier->commission != null) {
                            if ($dossier->commission->date == $date) {
                                $data->cj++;
                            }
                        }
                    }
                    if ($this->etat_index($dossier->etat_actuel) == 3) {
                        $data->oc++;

                        if (!is_null($OVERTURE_CHANTIER)) {
                            if ($OVERTURE_CHANTIER->decision == 'Validé') {
                                if ($OVERTURE_CHANTIER->date_document == $date) {
                                    $data->ocj++;
                                }
                            }
                        }
                    }
                    if ($this->etat_index($dossier->etat_actuel) >= 5) {
                        $data->ph++;

                        if (!is_null($PERMIS_HABITER)) {
                            if ($PERMIS_HABITER->decision == 'Validé') {
                                if ($PERMIS_HABITER->date_document == $date) {
                                    $data->phj++;
                                }
                            }
                        }
                    }
                }
            }

            if ($data->dv > 0) {
                $data->pa = round($data->avf / $data->dv * 100, 2);
                $data->pp = round($data->ph / $data->dv * 100, 2);
            }



            $stats->dv_total += $data->dv;
            $stats->da_total += $data->da;
            $stats->avf_total += $data->avf;
            $stats->pa_total += $data->pa;

            $stats->c_total += $data->c;
            $stats->oc_total += $data->oc;
            $stats->ph_total += $data->ph;
            $stats->pp_total += $data->pp;

            $stats->dj_total += $data->dj;
            $stats->daj_total += $data->daj;
            $stats->cj_total += $data->cj;
            $stats->afj_total += $data->afj;
            $stats->ocj_total += $data->ocj;
            $stats->phj_total += $data->phj;

            $stats->provinces_data[] = $data;
        }

        return $stats;
    }


    public function etat_index(string $etat)
    {
        if ($etat == 'Demande validée') {
            return 0;
        }
        if ($etat == "Demande d'autorisation déposée") {
            return 1;
        }
        if ($etat == "Autorisation de construire déposée") {
            return 2;
        }
        if ($etat == "Pv d'ouverture de chantier déposé") {
            return 3;
        }
        if ($etat == "Réception des fondations déposé") {
            return 4;
        }
        if ($etat == "Permis d'habiter déposé") {
            return 5;
        }
    }
}
