<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Province;
use App\Models\User;
use App\Models\Dossier;
use App\Models\Demande;
use Illuminate\Support\Facades\DB;
use App\Models\Dossier_rehab;
use App\Models\Dossier_document;
use App\Models\DossierRehab_document;
use App\Models\Demande_document;
use Illuminate\Support\Facades\Storage;
use App\Models\Guichet;
use App\Models\Douar;
use Carbon\Carbon;
use stdClass;

class StorageManagerController extends Controller
{

    public function index()
    {
        if (Auth::user()->has_role('Observateur de suivi')) {

            $dossiers_documents_total_size = Dossier_document::whereNotNull('dossier_id')->sum('file_size');
            $dossiers_documents_sync_total_size = Dossier_document::whereNotNull('dossier_id')->where('sync', 1)->sum('file_size');
            $dossiers_documents_sync_r2_total_size = Dossier_document::whereNotNull('dossier_id')->where('sync_r2', 1)->sum('file_size');

            $dossiers_rehab_documents_total_size = DossierRehab_document::whereNotNull('dossier_id')->sum('file_size');
            $dossiers_rehab_documents_sync_total_size = DossierRehab_document::whereNotNull('dossier_id')->where('sync', 1)->sum('file_size');
            $dossiers_rehab_documents_sync_r2_total_size = DossierRehab_document::whereNotNull('dossier_id')->where('sync_r2', 1)->sum('file_size');


            $demandes_documents_total_size = Demande_document::whereNotNull('demande_id')->sum('file_size');
            $demandes_documents_sync_total_size = Demande_document::whereNotNull('demande_id')->where('sync', 1)->sum('file_size');
            $demandes_documents_sync_r2_total_size = Demande_document::whereNotNull('demande_id')->where('sync_r2', 1)->sum('file_size');

            $dossiers_documents_files_count = Dossier_document::whereNotNull('dossier_id')->count();
            $dossiers_documents_files_sync_count = Dossier_document::whereNotNull('dossier_id')->where('sync', 1)->count();
            $dossiers_documents_files_sync_r2_count = Dossier_document::whereNotNull('dossier_id')->where('sync_r2', 1)->count();


            $dossiers_rehab_documents_files_count = DossierRehab_document::whereNotNull('dossier_id')->count();
            $dossiers_rehab_documents_files_sync_count = DossierRehab_document::whereNotNull('dossier_id')->where('sync', 1)->count();
            $dossiers_rehab_documents_files_sync_r2_count = DossierRehab_document::whereNotNull('dossier_id')->where('sync_r2', 1)->count();

            $demandes_documents_files_count = Demande_document::whereNotNull('demande_id')->count();
            $demandes_documents_files_sync_count = Demande_document::whereNotNull('demande_id')->where('sync', 1)->count();
            $demandes_documents_files_sync_r2_count = Demande_document::whereNotNull('demande_id')->where('sync_r2', 1)->count();

            return view('storage_manager.index', [
                'dossiers_documents_total_size' => self::humanFileSize($dossiers_documents_total_size),
                'dossiers_documents_sync_total_size' => self::humanFileSize($dossiers_documents_sync_total_size),
                'dossiers_documents_sync_r2_total_size' => self::humanFileSize($dossiers_documents_sync_r2_total_size),

                'dossiers_rehab_documents_total_size' => self::humanFileSize($dossiers_rehab_documents_total_size),
                'dossiers_rehab_documents_sync_total_size' => self::humanFileSize($dossiers_rehab_documents_sync_total_size),
                'dossiers_rehab_documents_sync_r2_total_size' => self::humanFileSize($dossiers_rehab_documents_sync_r2_total_size),

                'demandes_documents_total_size' => self::humanFileSize($demandes_documents_total_size),
                'demandes_documents_sync_total_size' => self::humanFileSize($demandes_documents_sync_total_size),
                'demandes_documents_sync_r2_total_size' => self::humanFileSize($demandes_documents_sync_r2_total_size),

                'dossiers_documents_files_count' =>  number_format($dossiers_documents_files_count, 0, '.', ' '),
                'dossiers_documents_files_sync_count' =>  number_format($dossiers_documents_files_sync_count, 0, '.', ' '),
                'dossiers_documents_files_sync_r2_count' =>  number_format($dossiers_documents_files_sync_r2_count, 0, '.', ' '),

                'dossiers_rehab_documents_files_count' =>  number_format($dossiers_rehab_documents_files_count, 0, '.', ' '),
                'dossiers_rehab_documents_files_sync_count'=>number_format($dossiers_rehab_documents_files_sync_count, 0, '.', ' '),
                'dossiers_rehab_documents_files_sync_r2_count'=>number_format($dossiers_rehab_documents_files_sync_r2_count, 0, '.', ' '),

                'demandes_documents_files_count' =>  number_format($demandes_documents_files_count, 0, '.', ' '),
                'demandes_documents_files_sync_count'=>number_format($demandes_documents_files_sync_count, 0, '.', ' '),
                'demandes_documents_files_sync_r2_count'=>number_format($demandes_documents_files_sync_r2_count, 0, '.', ' '),
            ]);
        } else {
            abort(404);
        }
    }

    public function stats_dossiers_documents()
    {
        $dossiers_docs = Dossier_document::select('file_size', 'created_at')->orderBy('created_at')->get();

        $result = [];

        $last_date = null;
        foreach ($dossiers_docs as   $dossier_doc) {
            $date = Carbon::createFromFormat('Y-m-d H:i:s', $dossier_doc->created_at)->format('d/m/Y');

            if ($last_date != $date) {
                $last_date = $date;
                $row = new stdClass();
                $row->date = $date;
                $row->size = $dossier_doc->file_size;
                $result[] = $row;
            } else {
                $result[count($result) - 1]->size += $dossier_doc->file_size;
            }
        }

        foreach ($result as $row) {
            $row->hSize = self::humanFileSize($row->size);
        }
        return  $result;
    }

    function humanFileSize($size, $unit = "")
    {
        if ((!$unit && $size >= 1 << 30) || $unit == "GB")
            return number_format($size / (1 << 30), 2, '.', ' ') . " GB";
        if ((!$unit && $size >= 1 << 20) || $unit == "MB")
            return number_format($size / (1 << 20), 2, '.', ' ') . " MB";
        if ((!$unit && $size >= 1 << 10) || $unit == "KB")
            return number_format($size / (1 << 10), 2, '.', ' ') . " KB";
        return number_format($size, 2, '.', ' ') . " bytes";
    }

    public function sftp()
    {
        Storage::disk('sftp')->makeDirectory('batir/demandes_docs/');
    }
}
