<?php

namespace App\Http\Controllers;

use App\Models\Proprietaire;
use App\Models\Proprietaire_document;
use Illuminate\Http\Request;
use App\Models\Terrain;
use App\Models\Liquidation;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Services\TNBPDFService;
use Response;
use niklasravnsborg\LaravelPdf\Facades\Pdf;
class TerrainsNotificationsController extends Controller
{
    protected $pdfService;

    public function __construct(TNBPDFService $pdfService)
    {
        $this->pdfService = $pdfService;
    }



    public function generateNotificationsPdf(Request $request)
    {
        if ($request->has('terrain_id')) {
            // Generate PDF for single terrain
            $terrains = Terrain::with('proprietaires')->where('id', $request->terrain_id)->get();
        } else {
            // Generate PDF for ALL terrains when no specific terrain_id is provided
            $terrains = Terrain::with('proprietaires')->orderBy('article')->get();
        }

        return $this->pdfService->generateTerrainsNotifications($terrains);
    }
}
