<?php

namespace App\Http\Controllers;

use App\Models\Douar;
use App\Models\User;
use Carbon\Carbon;
use App\Models\Role;
use App\Models\Commune;
use App\Models\Province;
use App\Models\Cercle;
use App\Models\Affectation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use DataTables;
use stdClass;
use Response;
use App\Models\Demande;
use App\Models\Dossier_document;
use App\Mail\InvitationMail;
use App\Models\Etat_engagement;
use App\Mail\ForgotPwdMail;

use Hofmannsven\Brevo\BrevoServiceProvider;
use Hofmannsven\Brevo\Facades\Brevo;

use Illuminate\Support\Facades\Mail;

class UserController extends Controller
{
    public function show(string $id)
    {
        $user = User::where([['id', $id]])->whereIn('role_id', ['29a4359b-52c1-486b-8ede-b5fcda314a8b', '77970795-73b6-4f2f-8e4c-e97d25636598', 'cccfaaf5-9e6e-45eb-bbd3-0f813a085791', 'f652fd43-e591-4562-9220-ce2ab98542af'])->get()->first();
        if ($user == null) {
            abort(404);
        }
        $role_prestataires = Role::where('prestataire', 1)->get();
        return view('prestataire.show', [
            'user' => $user,
            'role_prestataires' => $role_prestataires

        ]);
    }

    public function store(Request $request)
    {
        $user = new User();
        if ($request->id == null) {
            $user->id = Str::uuid();

            $users_same_email = $user->where([['active', 1], ['email', $request->email]])->count();
            if ($users_same_email > 0) {
                return Response::json(['success' => 0, 'error', 'EMAIL_ALREADY_EXISTS'], 200);
            }
        } else {
            $user = User::where('id', $request->id)->get()->first();
        }
        if (!is_null($request->email)) {
            if (is_null($user->validation_completed_date)) {
                $user->email = $request->email;
            }
        }
        $user->password =  null;
        $user->nom = $request->nom;
        $user->prenom = $request->prenom;

        $user->organisme_ste = $request->organisme_ste;
        $user->role_id = $request->role_id;
        $user->tel = $request->tel;

        if ($request->id == null) {
            $user->token =  Str::random(64);
        }
        $user->save();

        return Response::json(['success' => 1], 200);
    }


    public function store_charge_guichet(Request $request)
    {
        $user = new User();
        if ($request->id == null) {
            $user->id = Str::uuid();

            $users_same_email = $user->where([['active', 1], ['email', $request->email]])->count();
            if ($users_same_email > 0) {
                return Response::json(['success' => 0, 'error', 'EMAIL_ALREADY_EXISTS'], 200);
            }
        } else {
            $user = User::where('id', $request->id)->get()->first();
        }
        if (!is_null($request->email)) {
            if (is_null($user->validation_completed_date)) {
                $user->email = $request->email;
            }
        }
        $user->password =  null;
        $user->nom = $request->nom;
        $user->prenom = $request->prenom;

        $user->role_id = '8c2d8e8f-8a54-47a9-bcc1-3dc0c6255220';
        $user->agence_urbain_id = Auth::user()->id;
        $user->filiale_id = Auth::user()->filiale_id;
        $user->tel = $request->tel;

        if ($request->id == null) {
            $user->token =  Str::random(64);
        }
        $user->save();

        return Response::json(['success' => 1], 200);
    }

    public function store_etat_engagement(Request $request)
    {
        $ids = explode(',', $request->user_ids);

        foreach ($ids as $id) {

            $auth_user = Auth::user();
            $etat_engagement =  Etat_engagement::where([['user_id', $id], ['filiale_id', $auth_user->filiale_id]])->get()->first();


            if (is_null($etat_engagement)) {
                $etat_engagement = new Etat_engagement();
                $etat_engagement->id = Str::uuid();
            }



            $etat_engagement->etat = $request->etat_engagement;
            $etat_engagement->user_id = $id;
            $etat_engagement->filiale_id = $auth_user->filiale_id;
            $etat_engagement->created_by = $auth_user->id;
            $etat_engagement->save();
        }
        return Response::json(['success' => 1], 200);
    }

    public function delete(Request $request)
    {
        User::whereIn('id', explode(',', $request->ids))->update(array('active' => 0));
        return Response::json(['success' => 1], 200);
    }

    public function get(string $id)
    {
        $user = User::with('role')->where('id', $id)->get()->first();
        if ($user != null) {
            return   $user;
        } else {
            return Response::json(['success' => 0, 'error' => 'UNKNOWN_USER'], 200);
        }
    }


    public function get_douars(string $id)
    {
        $user = User::where('id', $id)->get()->first();
        if ($user != null) {
            $result = new stdClass();
            //$result->user = $user;
            $result->count = 0;
            $result->douars = [];


            foreach ($user->douars() as $douar) {
                $douar_data = new stdClass();
                $douar_data->id = $douar->id;
                $douar_data->nom = (strlen($douar->nom) > 0 ?  $douar->nom :  $douar->nom_ar);
                $douar_data->commune_nom =  $douar->commune->nom;
                $douar_data->cercle_nom =  $douar->commune->cercle->nom;
                $douar_data->province_nom =  $douar->commune->cercle->province->nom;
                $result->douars[] = $douar_data;
            }
            $result->count = count($result->douars);
            // foreach ($result->douars  as $douar) {
            //     //$douar->commune = Commune::with('cercle.province')->where('id', $douar->commune_id)->get()->first();
            // }
            // for ($i = 0; $i < count($result->douars); $i++) {
            //     $result->douars[$i]->nom = (strlen($result->douars[$i]->nom) > 0 ?  $result->douars[$i]->nom :  $result->douars[$i]->nom_ar);
            // }


            return $result;
        } else {
            return Response::json(['success' => 0, 'error' => 'UNKNOWN_USER'], 200);
        }
    }

    public function set_douars(string $id, Request $request)
    {
        $douars = json_decode($request->douars);
        $user = User::where('id', $id)->get()->first();

        if ($user != null) {
            foreach ($douars as $douar) {

                if (Affectation::where([['douar_id', $douar->id], ['user_id', $user->id]])->count() == 0) {
                    $affectation = new Affectation();
                    $affectation->id = Str::uuid();
                    $affectation->type = $user->role->name;
                    $affectation->douar_id = $douar->id;
                    $affectation->user_id = $user->id;
                    $affectation->save();
                }
            }
            return Response::json(['success' => 1, 'error' => null], 200);
        } else {
            return Response::json(['success' => 0, 'error' => 'UNKNOWN_USER'], 200);
        }
    }

    public function get_by_role(string $role_id)
    {
        return User::where('role_id', $role_id)->get();
    }
    public function get_by_role_douar(string $role_id, string $douar_id)
    {
        $affectations = Affectation::where([['douar_id', $douar_id]])->get();
        $users = [];
        foreach ($affectations as $affectation) {
            $user = User::where('id', $affectation->user_id)->get()->first();
            if( $user->role_id==$role_id)
            {
                $users[] = $user;
            }
          
        }

        return  $users;
    }
    public function send_invitation_mail(string $user_id)
    {
        $auth_user = Auth::user();
        $user = User::where('id', $user_id)->get()->first();
        if ($user != null) {
            if ($auth_user->role->name == 'Administrateur' || $auth_user->role->name == 'Chef du projet') {
                if ($user->validation_completed_date == null) {
                    Mail::to($user->email)->send(new InvitationMail($user_id));
                    $user->validation_sent_date = Carbon::now();
                    $user->save();
                    return Response::json(['success' => 1, 'error' => null,'email'=>$user->email], 200);
                } else {
                    return Response::json(['success' => 1, 'error' => 'ACCOUNT_VERIFIED'], 200);
                }
            } else {
                return Response::json(['success' => 1, 'error' => 'UNAUTHORIZED'], 200);
            }
        } else {
            return Response::json(['success' => 0, 'error' => 'UNKNOWN_USER'], 200);
        }
    }

    public function send_forgotpwd_mail(Request $request)
    {

        $email = $request->email;
        $user = User::where('email', $email)->get()->first();
        if ($user != null) {
            $user->token = Str::random(64);
            $user->save();
            Mail::to($user->email)->send(new ForgotPwdMail($user->id));
        } else {
            return Response::json(['success' => 0, 'error' => 'UNKNOWN_USER'], 200);
        }
    }

    public function fix_no_token()
    {
        // $users = User::where([['password', null], ['token', null]])->get();
        // foreach ($users as $user) {
        //     $user->token = Str::random(64);
        //     $user->save();
        // }
        // return $users;
    }

    public function affectations_datatable(Request $request)
    {
        $export_mode = 0;
        if (isset($request->export_mode)) {
            $export_mode = $request->export_mode;
        }
        $user_id = $request->user_id;
        $filters = json_decode($request->filters);
        $douars = Douar::with('architecte', 'igt', 'bc', 'bet', 'laboratoire')->where('active', 1)->select('douars.*');

        foreach ($filters as $filter) {

            if ($filter->column == 'created_at') {

                $from =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[0]));
                $to =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[1]));

                $douars = $douars->whereBetween($filter->column, [$from, $to]);
            } else {
                if ($filter->table == '') {
                    $douars = $douars->where($filter->column, '=', $filter->value);
                } else {
                    $douars = $douars->whereHas($filter->table, function ($query) use ($filter) {
                        $query->where($filter->table . '.' . $filter->column, '=', $filter->value);
                    });
                }
            }
        }

        $douars =  $douars->where(function ($query) use ($user_id) {
            $query->where('architecte_id',  $user_id)
                ->orWhere('laboratoire_id', '=',  $user_id)
                ->orWhere('igt_id', '=',  $user_id)
                ->orWhere('bet_id', '=',  $user_id)
                ->orWhere('bc_id', '=', $user_id);
        });

        $douars = $douars->get();

        return Datatables::of($douars)
            ->addColumn('douar', function ($douar) {
                return (strlen($douar->nom) > 0 ? $douar->nom : $douar->nom_ar);
            })
            ->addColumn('province', function ($douar) {

                return $douar->commune->cercle->province->nom;
            })
            ->addColumn('cercle', function ($douar) {

                return $douar->commune->cercle->nom;
            })
            ->addColumn('commune', function ($douar) {

                return $douar->commune->nom;
            })
            ->rawColumns(['douar', 'commune', 'cercle', 'province'])
            ->only(['douar', 'commune', 'cercle', 'province'])
            ->make(true);
    }

    public function reset_pwd(string $user_id, string $token)
    {
        $user = User::where('id', $user_id)->first();


        if ($user == null) {
            return redirect('/login');
        }
        if ($user->token != $token) {
            return  redirect('/login');
        }
        return view('reset_pwd.show', [

            'user' => $user,
            'token' => $token,
        ]);
    }

    public function reset_save_pwd(Request $request)
    {
        $req = $request->all();
        $user_id = $req['user_id'];
        $token = $req['token'];
        $password = $req['password'];
        $confirmation_password = $req['password_confirmation'];


        $user = User::where('id', $user_id)->first();

        if (strlen(trim($password)) < 8) {
            return response()->json(['success' =>  0, "message" => "Le mot de passe doit comporter au moins 8 caractères en longueur."]);
        }
        if ($password != $confirmation_password) {
            return response()->json(['success' =>  0, "message" => "Mots de passes ne correspondent pas"]);
        }
        if ($user != null) {
            if ($user->token == null) {
                return response()->json(['success' =>  0, "message" => "Lien expiré."]);
            }

            if ($user->token == $token) {
                $user->token = null;
                $user->password = Hash::make($password);
                $user->save();
                return response()->json(['success' =>  1]);
            } else {
                return response()->json(['success' =>  0, "message" => "Invalid token"]);
            }
        } else {
            return response()->json(['success' =>  0, "message" => "Invalid user_id"]);
        }
    }

    public function update_depot()
    {

        $prestataires = User::WhereIn(
            'role_id',
            [
                'cccfaaf5-9e6e-45eb-bbd3-0f813a085791',
                'f652fd43-e591-4562-9220-ce2ab98542af',
                '77970795-73b6-4f2f-8e4c-e97d25636598',
                '29a4359b-52c1-486b-8ede-b5fcda314a8b'
            ]
        )->get();

        foreach ($prestataires  as  $prestataire) {
            if ($prestataire->role->name == "IGT") {
                $count_affectes = Demande::where([['enquete', 0], ['igt_id', $prestataire->id]])->count();
            }
            if ($prestataire->role->name == "BET") {
                $count_affectes = Demande::where([['enquete', 0], ['bet_id', $prestataire->id]])->count();
            }
            if ($prestataire->role->name == "Architecte") {
                $count_affectes = Demande::where([['enquete', 0], ['architecte_id', $prestataire->id]])->count();
            }
            if ($prestataire->role->name == "Laboratoire") {
                $count_affectes = Demande::where([['enquete', 0], ['laboratoire_id', $prestataire->id]])->count();
            }
            $count_dossier_with_depots = Dossier_document::where([['user_id', $prestataire->id]])->whereNotNull('dossier_id')->groupBy('dossier_id')->count();

            $percentage = 0;
            if ($count_affectes > 0) {
                $percentage = round(($count_dossier_with_depots / $count_affectes), 4) * 100;
            }
            $prestataire->taux_depot = $percentage;
            $prestataire->save();
        }
    }
}
