<?php

namespace App\Http\Controllers;

use App\Models\Adresse;
use App\Models\Affectation;
use App\Models\Cercle;
use App\Models\Commune;
use Illuminate\Support\Facades\DB;
use App\Models\Terrain;
use App\Models\Dossier;
use App\Models\User;
use App\Models\Declaration;
use App\Models\Liquidation;
use App\Models\Proprietaire;
use App\Models\Terrain_document;
use App\Models\Zone;
use App\Models\ZonePA;
use App\Models\TerrainOperation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Str;
use DataTables;
use Illuminate\Support\Facades\File;
use Response;
use \stdClass;
use PhpOffice\PhpSpreadsheet\IOFactory;
use App\Models\ZonesDocument;
use Illuminate\Support\Facades\Artisan;

class ZoningController extends Controller
{

    public function index()
    {
        Artisan::call('route:clear');

        $zones = Zone::orderBy('annee', 'desc')->get();
        $annees =  [];
        foreach ($zones as $zone) {

            $annees[] = $zone->annee;
        }
        $annees = array_unique($annees);

        $last_annee =  $annees[0];

        $zones_doucment = ZonesDocument::where('annee', $last_annee)->get()->first();
        return view('zoning.index', [
            'zones' => $zones,
            'annees' => $annees,
            'last_annee' => $last_annee,
            'zones_doucment ' => $zones_doucment
        ]);
    }

    public function getZonesDcision(Request $request)
    {
        $zones_doucment = ZonesDocument::where('annee', $request->annee)->get()->first();

        if (is_null($zones_doucment)) {
            abort(404);
        } else {
            $zones_doucment->formated_created_at =  $zones_doucment->formated_created_at();
            return  $zones_doucment;
        }
    }
    public function getZones(Request $request)
    {
        $zones = Zone::where("annee", $request->annee)->get();

        return  $zones;
    }



    public function file(string $file_id)
    {

        $zones_doucment = ZonesDocument::where('id', $file_id)->get()->first();

        $headers = array(
            'Content-Type: application/pdf',
        );

        return Response::download($zones_doucment->documentPath(), $zones_doucment->filename, $headers);
    }

    public function zones_datatable(Request $request)
    {
        $filters = json_decode($request->filters);
        $zones = Zone::orderBy('created_at', 'desc');

        foreach ($filters as $filter) {
            if (isset($filter->params)) {
                $params = explode(',', $filter->params);
                foreach ($params as $param) {
                    if ($param == "remove_spaces") {
                        $filter->value = str_replace(' ', '', $filter->value);
                    }
                }
            }

            if ($filter->column == 'annee') {
                $zones = $zones->where('annee', $filter->value);
                continue;
            }
        }

        return Datatables::eloquent($zones)
            ->editColumn('nom', function ($zone) {
                return '<i style="font-size: 0.8rem;color: #7C7C7C;" class="fa-solid fa-draw-polygon"></i>&nbsp<a>' . $zone->nom . '</a>&nbsp';
            })
            ->addColumn('tarif', function ($zone) {
                return "<b style='color:#0053ae'>" . $zone->tarif . "</b> Dhs";
            })
            ->addColumn('annee', function ($zone) {
                return $zone->annee;
            })
            ->rawColumns(['nom', 'tarif', 'annee'])
            ->only(['nom', 'tarif', 'annee'])
            ->make(true);
    }
}
