<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Carbon\Carbon;

class SetTimezone
{
    public function handle(Request $request, Closure $next)
    {
        // Set Laravel's timezone dynamically
        date_default_timezone_set(config('app.timezone'));
        Carbon::setTestNow(now()); // Ensure Carbon respects timezone
        
        return $next($request);
    }
}
