<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Declaration extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false; 
    protected $table = "declarations";

  
    public function terrains()
    {
        return $this->belongsTo(Terrain::class);
    }


    
    public function operations()
    {
        return $this->morphMany(TerrainOperation::class, 'relatedModel');
    }

    
}
