<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\SoftDeletes;  
class Proprietaire extends Model
{
    use HasFactory;
    use SoftDeletes;  
    protected $keyType = 'string';
    public $incrementing = false; 
    protected $table = "proprietaires";


    protected $fillable = [
        'id',
        'type',
        'nom',
        'prenom',
        'cine',
        'rc',
        'ville_rc'
    ];

    public function terrains()
    {
        return $this->belongsToMany(Terrain::class, 'proprietaire_terrain', 'proprietaire_id', 'terrain_id')
                    ->withPivot('quote_part', 'active')
                    ->withTimestamps(); 
    }
  
    // public function terrains()
    // {
    //     return $this->belongsTo(Terrain::class);
    // }

    // public function declarations()
    // {
    //     return $this->hasMany(Declaration::class, 'id_proprietaire');
    // }

    // public function declarationDateTerrain($terrain_id)
    // {
    //     $declaration = $this->declarations()
    //         ->where('id_terrain', $terrain_id)
    //         ->first();

    //         return $declaration && $declaration->date
    //         ? \Carbon\Carbon::parse($declaration->date)->format('d/m/Y')
    //         : '-';
    // }

    public function qualites()
    {
        return $this->hasMany(ProprietaireQualite::class,"id_proprietaire");
    }    


    public function hasLiquide($terrain_id)
    {
        return DB::table('liquidations')
            ->where('id_proprietaire', $this->id)
            ->where('id_terrain', $terrain_id)
            ->exists();
    }


    public function proprietaire_documents()
    {
        return $this->hasMany(Proprietaire_document::class, 'proprietaire_id', 'id');
    }

    public function  specific_document(string $type)
    {
        $document = Proprietaire_document::where([['type_document', $type], ['proprietaire_id', $this->id]])->first();
        if ($document) {
            $document->formatted_created_at = Carbon::parse($document->created_at)->format('d/m/Y H:i');
        }
        return   $document;
    }

    
}
