<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Proprietaire_document extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false; 
    protected $table = "proprietaires_documents";

    // protected $connection = 'remote_db';

    public function proprietaire() 
    {
        return $this->belongsTo(Proprietaire_document::class.'proprietaire_id','id');
    }

    public function formated_created_at()
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at)->format('d/m/Y H:i');
    }
    public function formated_date_document()
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->date_document)->format('d/m/Y');
    }

    public function documentPath()
    {
        return  base_path('files/proprietaires_docs/' .  $this->id . '/' . $this->filename);
    }

    public function documentUrl()
    {
        return  asset('files/proprietaires_docs/' .  $this->id . '/' . $this->filename);
    }
    
}
