<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Terrain extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "terrains";



    public function zones()
    {
        return $this->belongsToMany(Zone::class, 'terrains_zones', 'terrain_id', 'zone_id');
    }

    public function proprietaires()
    {
        return $this->belongsToMany(Proprietaire::class, 'proprietaire_terrain', 'terrain_id', 'proprietaire_id')
            ->withPivot('quote_part', 'active')
            ->wherePivot('active', 1)
            ->withTimestamps();
    }

    public function old_proprietaires()
    {
        return $this->belongsToMany(Proprietaire::class, 'proprietaire_terrain', 'terrain_id', 'proprietaire_id')
            ->withPivot('quote_part', 'active')
            ->wherePivot('active', 0)
            ->withTimestamps();
    }


    public function declarations()
    {
        return $this->HasMany(Declaration::class, 'id_terrain');
    }

    public function liquidations()
    {
        return $this->hasMany(Liquidation::class, 'id_terrain');
    }

    public function hasLiquidationThisYear()
    {
        return $this->liquidations()->whereYear('date', date('Y'))->exists();
    }

    public function zones_pa()
    {
        return $this->belongsToMany(ZonePA::class, 'zone_pa_terrain', 'terrain_id', 'zone_pa_id')
            ->withPivot('ratio');
    }

    public function has_geometry()
    {
        if ($this->geojson != null && $this->geojson != "") {
            return true;
        }
    }

    public function operations()
    {
        return $this->hasMany(TerrainOperation::class, 'terrain_id');
    }


    public function  specific_document(string $type)
    {
        $document = Terrain_document::where([['active', 1], ['type_document', $type], ['terrain_id', $this->id]])->orderBy('created_at', 'desc')->get()->first();
        return   $document;
    }

    public function  specific_photos(string $type)
    {
        $photos = Terrain_document::where([['active', 1], ['type_document', $type], ['terrain_id', $this->id]])->get();
        return   $photos;
    }


    public function  etat_avancement_color(string $etat)
    {
        $color = "#F1F1F1";

        return $color;
    }

    public function  type_terrain_color(string $type)
    {
        $color = "#2d2d2d";

        if ($type == "Terrains taxables") {
            $color = "#5470c6";
        }
        if ($type == "Exonerations permanentes") {
            $color = "#fac858";
        }
        if ($type == "Terrains supprimes") {
            $color = "#91cc75";
        }
        if ($type == "Exonerations temporaires") {
            $color = "#ef7575";
        }
        if ($type == "Terrains non taxables") {
            $color = "#73c0de";
        }
        return $color;
    }


    // Append the custom attribute to JSON
    protected $appends = ['type_label'];

    public function getTypeLabelAttribute()
    {
        $mapping = [
            'Terrains taxables' => 'Terrain taxable',
            'Exonerations permanentes' => 'Exonération permanente',
            'Terrains supprimes' => 'Terrains loti/construit',
            'Exonerations temporaires' => 'Exonération temporaire',
        ];

        return $mapping[$this->type] ?? $this->type;
    }
}
