<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class TerrainOperation extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "terrain_operations";

    protected $casts = [
        'operation_data' => 'array',
    ];

    
    public function relatedModel()
    {
         return $this->morphTo();
    }


    public function getOperationTypeNameAttribute()
    {
        return match ($this->operation_type) {
            'DEC_TERRAIN' => 'Déclaration',
            'DEC_CHANGEMENT_PROP' => 'Déclaration changement proprietaire',
            'LIQ_TERRAIN' => 'Liquidation',
            'TT_ET' => 'Exonerations Temporaires',
            'ET_TT' => 'Terrains Taxables',
            'AVANCEMENT_TRAVAUX' => $this->getAvancementTravauxWithMotif(),
            default => 'Autre',
        };
    }

    private function getAvancementTravauxWithMotif()
    {
        $baseText = 'Avancement Travaux';
        
        // Check if motif exists in operation_data
        if (!empty($this->operation_motif)) {
            $motifText = $this->formatMotif($this->operation_motif);
            return $baseText . ' - ' . $motifText;
        }
        
        // If no motif, return just the base text
        return $baseText;
    }

    private function formatMotif($motif)
    {
        return match ($motif) {
            'non-achevement' => 'Non Achèvement',
            'achevement' => 'Achèvement',
            default => ucfirst(str_replace('-', ' ', $motif)),
        };
    }

    public function getTypeConstructionAttribute()
    {        

        $operationData = $this->operation_data;
        $typeConstruction = $operationData['type_construction'] ?? null;
        
        if (!$typeConstruction) {
            return null;
        }
        
        switch ($typeConstruction) {
            case 'maison':
                return 'Maison';
            case 'villa':
                return 'Villa';
            case 'immeuble':
                return 'Immeuble';
            case 'unite_industrielle':
                return 'Unité industrielle';
            default:
                return ucfirst(str_replace('_', ' ', $typeConstruction));
        }
    }

    public function getFormattedDateAttribute()
    {
        return $this->date ? Carbon::parse($this->date)->format('d/m/Y') : null;
    }


    public function terrain()
    {
        return $this->belongsTo(Terrain::class);
    }

    public function proprietaire()
    {
        return $this->belongsTo(Proprietaire::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }


    public function  specific_document(string $id)
    {
        $document = Terrain_document::where([['active', 1], ['operation_id', $id]])->orderBy('created_at', 'desc')->get()->first();
        return   $document;
    }
}
