<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Terrain_document extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "terrains_documents";

    public function terrain()
    {
        return $this->hasOne(Terrain::class, 'id', 'terrain_id');
    }
    public function plan_type()
    {
        return $this->hasOne(Plan_type::class, 'id', 'plan_type_id');
    }
    public function formated_created_at()
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at)->format('d/m/Y H:i');
    }
    public function formated_date_document()
    {
        if ($this->type_document == "PLAN_COTE_PDF") {
            return "-";
        }
        if ($this->type_document == "PLAN_COTE_DWG") {
            return "-";
        }
        if ($this->type_document == "PLAN_ARCHITECTE_PDF") {
            return "-";
        }
        if ($this->type_document == "PLAN_ARCHITECTE_DWG") {
            return "-";
        }
        if ($this->type_document == "LIMITE_PLLE") {
            return "-";
        }
        if ($this->type_document == "PLAN_BETON_ARME_PDF") {
            return "-";
        }
        if ($this->type_document == "PLAN_BETON_ARME_DWG") {
            return "-";
        }
        return Carbon::createFromFormat('Y-m-d', $this->date_document)->format('d/m/Y');
    }

    public function documentPath()
    {
       
        return  base_path('files/terrains_nus_docs/' .  $this->id . '/' . $this->filename);
        
    }

    public function documentUrl()
    {
        return  asset('files/terrains_nus_docs/' .  $this->id . '/' . $this->filename);
    }

    public function guichet()
    {
        return $this->hasOne(Guichet::class, 'id', 'guichet_id');
    }

    public function decision_color()
    {
        if ($this->decision == 'En attente') {
            return "#DBBB24";
        }
        if ($this->decision == 'Validé') {
            return "#779E25";
        }
        if ($this->decision == 'Rejeté') {
            return "#F44141";
        }
    }


    public function decision_full()
    {
        if ($this->decision == 'Rejeté') {
            return $this->decision . " (" . $this->motif_rejet . ")";
        }
        return $this->decision;
    }

    public function verificateur()
    {
        $v_user = User::where('id', $this->verified_by)->get()->first();

        if (is_null($v_user)) {
            return ' inconnu';
        } else {
            return  $v_user->nom . ' ' . $v_user->prenom;
        }
    }

    public function  getName()
    {
        if ($this->type_document == 'PLAN_COTE_PDF') {
            return "Plan coté (PDF)";
        }
        if ($this->type_document == 'PLAN_COTE_DWG') {
            return "Plan coté (DWG)";
        }
        if ($this->type_document == 'PLAN_ARCHITECTE_PDF') {
            return "Plan d'architecte (PDF)";
        }
        if ($this->type_document == 'PLAN_ARCHITECTE_DWG') {
            return "Plan d'architecte (DWG)";
        }
        if ($this->type_document == 'LIMITE_PLLE') {
            return "Limite de la parcelle";
        }
        if ($this->type_document == 'PLAN_BETON_ARME_PDF') {
            return "Plan béton armé / ferraillage (PDF)";
        }
        if ($this->type_document == 'PLAN_BETON_ARME_DWG') {
            return "Plan béton armé / ferraillage  (DWG)";
        }
        if ($this->type_document == 'DEMANDE_AUTORISATION') {
            return "Demande de l'autorisation";
        }
        if ($this->type_document == 'RECEPISSE') {
            return "Récépissé";
        }
        if ($this->type_document == 'AUTORISATION_CONSTRUIRE') {
            return "Autorisation de construire";
        }
        if ($this->type_document == 'ATTESTATION_IMPLANTATION') {
            return "Attestation d'implantation";
        }
        if ($this->type_document == 'OVERTURE_CHANTIER') {
            return "PV ouverture de chantier";
        }
        if ($this->type_document == 'RECPTION_FONDS_FOUILLES') {
            return "PV réception des fonds de fouilles";
        }
        if ($this->type_document == 'CONTROLES_FONDATIONS') {
            return "Contrôle des fondations";
        }
        if ($this->type_document == 'RECPTION_FONDATIONS') {
            return "PV réception des fondations";
        }
        if ($this->type_document == 'CONTROLE_STRUCTURE') {
            return "PV de réception de structure";
        }
        if ($this->type_document == 'RECEPTION_STRUCTURE') {
            return "PV de réception du coffrage /ferraillage";
        }
        if ($this->type_document == 'PV_RECEPTION_ENVOLOPPE') {
            return "Pv de réception de l'enveloppe";
        }
        if ($this->type_document == 'PV_RECEPTION_FINITION') {
            return "PV de réception de la finition";
        }
        if ($this->type_document == 'PV_FIN_TRAVAUX') {
            return "PV de réception des travaux";
        }
        if ($this->type_document == 'PERMIS_HABITER') {
            return "Permis d'habitere";
        }
    }

    public function  getRoleName()
    {
        if ($this->type_document == 'PLAN_COTE_PDF') {
            return "IGT";
        }
        if ($this->type_document == 'PLAN_COTE_DWG') {
            return "IGT";
        }
        if ($this->type_document == 'PLAN_ARCHITECTE_PDF') {
            return "Architecte";
        }
        if ($this->type_document == 'PLAN_ARCHITECTE_DWG') {
            return "Architecte";
        }
        if ($this->type_document == 'LIMITE_PLLE') {
            return "IGT";
        }
        if ($this->type_document == 'PLAN_BETON_ARME_PDF') {
            return "BET";
        }
        if ($this->type_document == 'PLAN_BETON_ARME_DWG') {
            return "BET";
        }
        if ($this->type_document == 'DEMANDE_AUTORISATION') {
            return "Architecte";
        }
        if ($this->type_document == 'RECEPISSE') {
            return "Architecte";
        }
        if ($this->type_document == 'AUTORISATION_CONSTRUIRE') {
            return "Architecte";
        }
        if ($this->type_document == 'ATTESTATION_IMPLANTATION') {
            return "IGT";
        }
        if ($this->type_document == 'OVERTURE_CHANTIER') {
            return "Architecte";
        }
        if ($this->type_document == 'RECPTION_FONDS_FOUILLES') {
            return "Laboratoire";
        }
        if ($this->type_document == 'CONTROLES_FONDATIONS') {
            return "BET";
        }
        if ($this->type_document == 'RECPTION_FONDATIONS') {
            return "Architecte";
        }
        if ($this->type_document == 'CONTROLE_STRUCTURE') {
            return "BET";
        }
        if ($this->type_document == 'RECEPTION_STRUCTURE') {
            return "Architecte";
        }
        if ($this->type_document == 'PV_RECEPTION_ENVOLOPPE') {
            return "Architecte";
        }
        if ($this->type_document == 'PV_RECEPTION_FINITION') {
            return "Architecte";
        }
        if ($this->type_document == 'PV_FIN_TRAVAUX') {
            return "Architecte";
        }
        if ($this->type_document == 'PERMIS_HABITER') {
            return "Architecte";
        }
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
}
