<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Carbon\Carbon;

class User extends Authenticatable
{
    protected $keyType = 'string';
    public $incrementing = false;
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'token'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];


    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    public function has_role(string $roles)
    {
        $roles_array = explode(',', $roles);
        foreach ($roles_array as $role) {
            if ($this->role->name == $role) {
                return true;
            }
        }
        return false;
    }

    public function notifications()
    {
        return $this->hasMany(Notification::class, 'user_id')->orderBy('created_at', 'desc');
    }

    public function notifications_mini()
    {
        return $this->hasMany(Notification::class, 'user_id')->orderBy('created_at', 'desc');
    }


    public function invitation_status()
    {
        if ($this->validation_completed_date != null) {
            return '<b style="color:#769C25">Validé le ' . Carbon::createFromFormat('Y-m-d H:i:s', $this->validation_completed_date)->format('d/m/Y H:i') . '</b>';
        }
        if ($this->validation_read_date != null) {
            return '<b style="color:#E8A824">Lus le ' . Carbon::createFromFormat('Y-m-d H:i:s', $this->validation_read_date)->format('d/m/Y H:i') . '</b>';
        }
        if ($this->validation_sent_date != null) {
            return '<b style="color:#29ABE2">Envoyé le ' . Carbon::createFromFormat('Y-m-d H:i:s', $this->validation_sent_date)->format('d/m/Y H:i') . '</b>';
        }


        return '<b style="color:#949494">Aucune invitation n\'a été envoyée.</b>';
    }

   

    public function avatar()
    {
        $profile_pic = base_path('files/users/' . auth()->user()->id . '/profile/profile.png');
        if (file_exists($profile_pic)) {
            $profile_pic = asset('files/users/' . auth()->user()->id . '/profile/profile.png');
        } else {
            $profile_pic = asset('images/default_profile.svg');
        }
        $profile_pic = $profile_pic . '?t=' . time();
        return $profile_pic;
    }

    public function demandes()
    {
        return $this->hasMany(Demande::class, 'user_id', 'id');
    }
 
    public function loginSecurity()
    {
        return $this->hasOne(LoginSecurity::class);
    }
}
