<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ZonesDocument extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "zones_documents";

     
    public function formated_created_at()
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at)->format('d/m/Y H:i');
    }
     

    public function documentPath()
    {
       
        return  base_path('files/zones_documents/' .  $this->id . '/' . $this->filename);
        
    }

    public function documentUrl()
    {
        return  asset('files/zones_documents/' .  $this->id . '/' . $this->filename);
    }

       

     

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
}
