<?php

namespace App\Services;

use TCPDF;

class ArabicTCPDF extends TCPDF
{
    public function __construct($orientation = 'L', $unit = 'mm', $format = 'A4', $unicode = true, $encoding = 'UTF-8', $diskcache = false)
    {
        parent::__construct($orientation, $unit, $format, $unicode, $encoding, $diskcache);
        
        // Set Arabic font
        $this->SetFont('droidarabic', '', 12);
        
        // Set RTL mode
        $this->setRTL(true);
        
        // Set margins
        $this->SetMargins(7, 40, 7);
        $this->SetAutoPageBreak(true, 20);
    }

     public function setDocumentType($type, $title = '', $subtitle = '')
    {
        $this->documentType = $type;
        $this->documentTitle = $title;
        $this->documentSubtitle = $subtitle;
    }

    public function Header()
    {
        switch ($this->documentType) {
            case 'notification':
                $this->renderNotificationHeader();
                break;
            case 'declaration':
                $this->renderDefaultHeader();
                break;
            // case 'liquidation':
            //     $this->renderLiquidationHeader();
            //     break;
            default:
                $this->renderDefaultHeader();
                break;
        }
    }

    public function Footer()
    {
        switch ($this->documentType) {
            case 'notification':
                $this->renderNotificationFooter();
                break;
            case 'declaration':
                $this->renderDeclarationFooter();
                break;
            // case 'liquidation':
            //     $this->renderLiquidationFooter();
            //     break;
            default:
                $this->renderDefaultFooter();
                break;
        }
    }


    protected function renderDefaultHeader()
    {
         $this->Ln(5);
        $html = '
        <table cellpadding="3" cellspacing="0" border="0" width="100%">
            <tr>
                 <td width="33%" align="center" dir="rtl">
                    <span style="font-family: droidarabic; font-size: 7pt; font-weight: bold; color: #2d2d2d;">
                        <u>المملكة المغربية</u> <br>
                        وزارة الداخلية<br>
                        عمالة المضيق  <i style="font-family: dejavusans !important">-</i> الفنيدق <br>
                        جماعة المضيق <br>
                        مديرية المصالح <br>
                        قسم الشؤون المالية والاقتصادية والادارية <br>
                        مصلحة الميزانية والشؤون المالية والممتلكات <br>
                        مكتب الوعاء الضريبي وتنمية الموارد المالية
                    </span>                
                </td>
                <td width="33%" align="center">
                    <img src="'.base_path('images/commune_mdiq.jpg').'" width="60" height="60" alt="Logo">
                </td>
               
                <td width="33%" align="center">
                    <span style="font-family: dejavusans; font-size: 7pt; color: #2d2d2d;">
                       <u>Royaume du Maroc</u><br>
                       Ministère de l’Intérieur <br>
                       Préfecture M’diq- fnideq <br>
                       Commune de M’diq <br>
                       Direction des services <br>
                       Division des AF, E et A <br>
                       Service du Budget, AF et P <br>
                       Bureau d’Assiettes et DRF <br>
                    </span>
                </td>
            </tr>
        </table>
       
        ';
        $this->writeHTML($html, true, 0, true, 0);
    }

    protected function renderNotificationHeader()
    {
        $this->Ln(5);
        $html = '
        <table cellpadding="3" cellspacing="0" border="0" width="100%">
            <tr>
                 <td width="33%" align="center" dir="rtl">
                    <span style="font-family: droidarabic; font-size: 7pt; font-weight: bold; color: #2d2d2d;">
                        <u>المملكة المغربية</u> <br>
                        وزارة الداخلية<br>
                        عمالة المضيق  <i style="font-family: dejavusans !important">-</i> الفنيدق <br>
                        جماعة المضيق <br>
                        مديرية المصالح <br>
                        قسم الشؤون المالية والاقتصادية والادارية <br>
                        مصلحة الميزانية والشؤون المالية والممتلكات <br>
                        مكتب الوعاء الضريبي وتنمية الموارد المالية
                    </span>                
                </td>
                <td width="33%" align="center">
                    <img src="'.base_path('images/commune_mdiq.jpg').'" width="60" height="60" alt="Logo">
                </td>
               
                <td width="33%" align="center">
                    <span style="font-family: dejavusans; font-size: 7pt; color: #2d2d2d;">
                       <u>Royaume du Maroc</u><br>
                       Ministère de l’Intérieur <br>
                       Préfecture M’diq- fnideq <br>
                       Commune de M’diq <br>
                       Direction des services <br>
                       Division des AF, E et A <br>
                       Service du Budget, AF et P <br>
                       Bureau d’Assiettes et DRF <br>
                    </span>
                </td>
            </tr>
        </table>
       
        ';
        $this->writeHTML($html, true, 0, true, 0);
    }




    protected function renderDefaultFooter()
    {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        
        $html = '
        <table cellpadding="2" cellspacing="0" border="0" width="100%">
            <tr>
                <td width="30%" align="left" dir="ltr">
                    <span style="font-family: droidarabic; font-size: 8pt; color: #7f8c8d;">
                        صفحة ' . $this->getAliasNumPage() . ' من ' . $this->getAliasNbPages() . '
                    </span>
                </td>
                <td width="40%" align="center" dir="rtl">
                    <span style="font-family: droidarabic; font-size: 8pt; color: #7f8c8d;">
                        عمالة المضيق الفنيدق - قسم الإدارة الجبائية المحلية
                    </span>
                </td>
                <td width="30%" align="right" dir="rtl">
                    <span style="font-family: droidarabic; font-size: 8pt; color: #7f8c8d;">
                        ' . date('Y/m/d H:i') . '
                    </span>
                </td>
            </tr>
        </table>
        ';
        $this->writeHTML($html, true, 0, true, 0);
    }


     protected function renderNotificationFooter()
    {

        $this->Ln(5);
        $html = '
        <table cellpadding="3" cellspacing="0" border="0" width="100%">
            <tr>
                 <td width="33%" align="center" dir="rtl">
                    <span style="font-family: droidarabic; font-size: 7pt; font-weight: bold; color: #2d2d2d;">
                        <u>المملكة المغربية</u> <br>
                        وزارة الداخلية<br>
                        عمالة المضيق  <i style="font-family: dejavusans !important">-</i> الفنيدق <br>
                        جماعة المضيق <br>
                        مديرية المصالح <br>
                        قسم الشؤون المالية والاقتصادية والادارية <br>
                        مصلحة الميزانية والشؤون المالية والممتلكات <br>
                        مكتب الوعاء الضريبي وتنمية الموارد المالية
                    </span>                
                </td>
                <td width="33%" align="center">
                    <img src="'.base_path('images/commune_mdiq.jpg').'" width="60" height="60" alt="Logo">
                </td>
               
                <td width="33%" align="center">
                    <span style="font-family: dejavusans; font-size: 7pt; color: #2d2d2d;">
                       <u>Royaume du Maroc</u><br>
                       Ministère de l’Intérieur <br>
                       Préfecture M’diq- fnideq <br>
                       Commune de M’diq <br>
                       Direction des services <br>
                       Division des AF, E et A <br>
                       Service du Budget, AF et P <br>
                       Bureau d’Assiettes et DRF <br>
                    </span>
                </td>
            </tr>
        </table>
       
        ';
        $this->writeHTML($html, true, 0, true, 0);
    }


    protected function renderDeclarationFooter()
    {
        // Position at 15 mm from bottom
        $this->SetY(-20);
        
        $html = '
        <hr style="color:rgb(92, 92, 92); background-color: #2d2d2d; height: 0.25px; border: none;">
        <table cellpadding="0.25" cellspacing="0" border="0" width="100%">
            <tr>
                <td align="center" dir="rtl">
                    <span style="font-family: droidarabic; font-size: 7pt; color: #7f8c8d;">
                        جماعة المضيق <i style="font-family: dejavusans !important">-</i> تجزئة اليمن طريق بوزغلال <i style="font-family: dejavusans !important">-</i> المضيق <i style="font-family: dejavusans !important">93200</i> <i style="font-family: dejavusans !important">//</i> الهاتف <i style="font-family: dejavusans !important">-</i> الفاكس <i style="font-family: dejavusans !important">:</i>  /  <i style="font-family: dejavusans !important">06615402830539664075</i>
                    </span>
                </td>   
            </tr>
            <tr>
                <td align="center" dir="rtl">
                    <span style="font-family: droidarabic; font-size: 6pt; color: #95a5a6;">
                        بوابة الجماعة  <i style="font-family: dejavusans !important"> : www.mdiq.ma   //</i>   البريد الالكتروني  <i style="font-family: dejavusans !important">:</i>  <i style="font-family: dejavusans !important">@mail: assiettemdiq@gmail.com</i> <i style="font-family: dejavusans !important">//</i> فيسبوك <i style="font-family: dejavusans !important">:</i> جماعة المضيق <i style="font-family: dejavusans !important">-</i> الصفحة الرسمية
                    </span>
                </td>
            </tr>
        </table>
        ';
        $this->writeHTML($html, true, 0, true, 0);
    }
}