<?php

namespace App\Services;

use App\Models\Terrain;
use App\Services\ArabicTCPDF;
use App\Models\Liquidation;
use Carbon\Carbon;

class TNBPDFService
{
     protected $pdf;

    public function __construct()
    {
        $this->pdf = new ArabicTCPDF();
    }

    public function generateTerrainsNotifications($terrains = null)
    {
        if (!$terrains) {
            $terrains = Terrain::with('proprietaires')->get();
        }

        $this->pdf = new ArabicTCPDF('P', 'mm', 'A4', true, 'UTF-8', false);

        $this->pdf->setDocumentType('notification', 'إشعار الأراضي غير المبنية', 'Notifications TNB');

        $this->pdf->SetCreator('TNB Management System');
        $this->pdf->SetAuthor('وزارة الداخلية');
        $this->pdf->SetTitle('تقرير الأراضي غير المبنية');
        $this->pdf->SetSubject('Terrains Non Bâtis');
        $this->pdf->setRTL(true);;

        $index_page = 0;
        foreach ($terrains as $terrain) {
            foreach($terrain->proprietaires as $proprietaire){
                $index_page++;
                $this->addTerrainNotificationPage($proprietaire,$terrain,$index_page);
            }
            
        }

        return $this->pdf->Output('terrains_notifications_' . date('Y-m-d') . '.pdf', 'D');
    }

    protected function addTerrainNotificationPage($proprietaire,$terrain,$index_page)
    {
        $this->pdf->AddPage();
        
        
         $html = '
            <table cellpadding="2" cellspacing="0" border="0" width="100%" 
                style="border:none; margin-top: 20px; border-collapse: collapse;">  
                
                    <tr>
                        <td width="15%" align="right" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;">
                            رقم
                        </td>
                        <td width="35%" align="left" dir="ltr" style="font-family: dejavusans; font-size: 8pt; border: none;">
                            N-' . ($terrain->article ?? 'XX') . '-' . date('Y') . '-' . str_pad($index_page, 3, '0', STR_PAD_LEFT) . '
                        </td>
                        <td width="50%" align="right" dir="rtl" style="font-family: dejavusans; font-size: 8pt; border: none;">
                            <!-- Empty space -->
                        </td>
                    </tr>  
                    <tr>                  
                        <td width="15%" align="right" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;">
                            المضيق في 
                        </td>
                        <td width="35%" align="left" dir="ltr" style="font-family: dejavusans; font-size: 8pt; border: none;">
                            ' . date('d/m/Y') . '
                        </td>
                        <td width="50%" align="right" dir="rtl" style="font-family: dejavusans; font-size: 8pt; border: none;">
                            <!-- Empty space -->
                        </td>
                    </tr>      
            </table>';

        $this->pdf->writeHTML($html, true, 0, true, 0);
      

         $html = '
            <table cellpadding="2" cellspacing="0" border="0" width="100%" style="border:none; margin-top: 20px; border-collapse: collapse;">
                
                <tr>
                    <td colspan="2" align="center" dir="rtl" style="font-family: droidarabic; font-size: 12pt; border: none;font-weight : bold">
                        من رئيس مجلس جماعة المضيق
                    </td>  
                </tr>
                <tr>
                    <td colspan="2" align="center" dir="rtl" style="font-family: droidarabic; font-size: 12pt; border: none;font-weight : bold">
                        إلـــــــــــى
                    </td>  
                </tr>

                 <tr>
                    <td colspan="2" align="center" dir="rtl" style="font-family: dejavusans; font-size: 12pt; border: none;font-weight : bold">
                        '.($proprietaire->type == "physique" ? ' السيد(ة):  ' : ' ممثل شركة ').'.'.$proprietaire->nom.' '.$proprietaire->prenom.'
                    </td>  
                </tr>
                <tr>
                    <td colspan="2" align="center" dir="rtl" style="font-family: dejavusans; font-size: 12pt; border: none;font-weight : bold">
                       العنوان: '.$proprietaire->adresse_ar.' 
                    </td>  
                </tr>                    
            </table>';

            $lastPaid = Liquidation::where('id_terrain', $terrain->id)
                ->orderByDesc('date')
                ->first();

            $currentYear = now()->year;

            if ($lastPaid) {
                $startYear = min(Carbon::parse($lastPaid->date)->year + 1, $currentYear);
            } else {
                $startYear = $currentYear - 3;
            }

            $endYear = $currentYear;

            // Limit to a maximum of 4 years
            $years = range($startYear, $endYear);
            $missingYearsStr = implode('-', $years);


        $this->pdf->writeHTML($html, true, 0, true, 0);     

           $html = '
            <h2 style="text-align : right" dir="rtl" style="font-family: dejavusans; font-size: 12pt; ">
                الموضوع: حول التصريح بامتلاك أرض حضرية غير مبنية.
            </h2>
            <p style="text-align : right" dir="rtl" style="font-family: dejavusans; font-size: 12pt; ">
                سلام تام بوجود مولانا الإمام
            </p>
            <p style="text-align : right" dir="rtl" style="font-family: dejavusans; font-size: 12pt; ">
            سلام تام بوجود مولانا الإمام
            وبعد، فعلاقة بالموضوع المشار إليه أعلاه، و بناءا على الظهير الشريف 195-07-01 الصادر في 19 ذي الحجة (30 نوفمبر 2007) القاضي بتنفيذ القانون رقم 06/47 المتعلق بجبايات الجماعات المحلية، الباب الخامس منه والمواد من 39 إلى 47 منه،
            يشرفني أن أحيطكم علما بأن المصلحة الجماعية لربط الضريبة لاحظت عدم إدلاءكم بإقرار بامتلاك أرض حضرية غير المبنية وتسوية الرسم العقاري رقم '.$terrain->ref.'، برسم السنوات '.$missingYearsStr.'.
            وعليه أطلب منكم التوجه إلى مصلحة الوعاء الضريبي من أجل إيداع الإقرار وتسوية وضعيتكم الجبائية داخل أجل 30 يوما طبقا للمادة 158 من القانون السالف الذكر، وتجدون طيه نسخة من وضعيتكم الجبائية.
            وتفضلوا بقبول خالص تحياتنا والسلام.

            </p>

            <p style="text-align : right" dir="rtl" style="font-family: dejavusans; font-size: 12pt; text-decoration : underline">
                المرفقات:

            </p>
            <p style="text-align : right" dir="rtl" style="font-family: dejavusans; font-size: 12pt;">
                 –	نسخة من بيان الأداء.
            </p>
            <br>
            <br>
            
            <div style="text-align: center; width: 100%;">
                <p dir="rtl" style="font-family: dejavusans; font-size: 12pt; text-align: center;">
                    <b>رئيس المجلس الجماعي</b>
                </p>
            </div>

           ';

        $this->pdf->writeHTML($html, true, 0, true, 0);    
      
    }


    // DECLARATIONS
    public function generateTerrainDeclaration($terrains = null,$generateTerrainDeclaration)
    {
        if (!$terrains) {
            $terrains = Terrain::with('proprietaires')->get();
        }

        // Set document type for declaration header
        $this->pdf->setDocumentType('declaration', 'إقرار الأراضي الحضرية غير المبنية', 'Déclarations TNB');

        $this->pdf->SetCreator('ETNB');
        $this->pdf->SetAuthor('ETNB');
        $this->pdf->SetTitle('Declaration');
        $this->pdf->SetSubject('Terrains Non Bâtis');

        foreach ($terrains as $terrain) {
            $this->addDeclarationTerrainPage($terrain,$generateTerrainDeclaration);
        }

        return $this->pdf->Output('terrains_declaration_' . date('Y-m-d') . '.pdf', 'D');
    }



    protected function addDeclarationTerrainPage($terrain,$generateTerrainDeclaration)
    {
        $this->pdf->AddPage();
        
        
         $html = '
            <table cellpadding="2" cellspacing="0" border="0" width="100%" 
                style="border:none; margin-top: 20px; border-collapse: collapse;">  
                
                <tr>
                    <td align="right" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;">
                        إقرار عدد
                    </td> 
                    <td align="center" style="font-family: dejavusans; font-size: 8pt; border: none;">
                       <b>'.$generateTerrainDeclaration.'</b>
                    </td>
                    <td align="left" style="font-family: dejavusans; font-size: 8pt; border: none;">
                        Déclaration Nº 
                    </td>
                </tr>        
            </table>';

        $this->pdf->writeHTML($html, true, 0, true, 0);
      

         $html = '
            <table cellpadding="2" cellspacing="0" border="0" width="100%" 
                style="border:none; background-color: #f0f0f0; margin-top: 20px; border-collapse: collapse;">
                
                <tr>
                    <td colspan="2" align="center" dir="rtl" style="font-family: droidarabic; font-size: 12pt; border: none;">
                        إقرار بامتلاك أرض حضرية غير مبنية
                    </td>  
                </tr>
                
                <tr>
                    <td colspan="2" align="center" style="font-family: dejavusans; font-size: 11pt; border: none;">
                        Déclaration de possession d’un terrain urbain non bâti
                    </td>  
                </tr>
                
                <tr>
                    <td align="right" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;">
                        الرسم على الأراضي الحضرية غير المبنية
                    </td> 
                    <td align="left" style="font-family: dejavusans; font-size: 8pt; border: none;">
                        Taxe des terrains urbains non bâtis
                    </td>
                </tr>        
            </table>';

        $this->pdf->writeHTML($html, true, 0, true, 0);



        $html = '
            <table cellpadding="2" cellspacing="0" border="0" width="100%" 
                style="border:0.25px solid #2d2d2d;  margin-top: 10px; border-collapse: collapse;">

                <tr style="background-color: #f0f0f0;">
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 8pt; border: none;">
                        Boite mail
                    </td>  
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 8pt; border: none;">
                        Fax
                    </td>
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 8pt; border: none;">
                        Téléphone
                    </td>  
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 8pt; border: none;">
                        Adresse
                    </td> 
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 8pt; border: none;">
                        CIN/RC
                    </td>
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 8pt; border: none;">
                        Qualité
                    </td> 
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 8pt; border: none;">
                        Nom
                    </td>     
                </tr>
                
                <tr style="background-color: #f0f0f0;">
                    <td align="center" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;border: none; border-bottom: 0.25px solid #000;">
                        البريد الإلكتروني
                    </td> 
                    <td align="center" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;border: none; border-bottom: 0.25px solid #000;">
                        الفاكس
                    </td> 
                    <td align="center" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;border: none; border-bottom: 0.25px solid #000;">
                        الهاتف
                    </td>
                    <td align="center" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;border: none; border-bottom: 0.25px solid #000;">
                        العنوان
                    </td>
                    <td align="center" dir="rtl" style="font-family: dejavusans; font-size: 8pt; border: none;border: none; border-bottom: 0.25px solid #000;">
                        ب.ت.و / ر.س.ت
                    </td>
                    <td align="center" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;border: none; border-bottom: 0.25px solid #000;">
                        الصفة
                    </td>
                    <td align="center" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;border: none; border-bottom: 0.25px solid #000;">
                        الاسم
                    </td>      
                </tr>                
            ';

        foreach ($terrain->proprietaires as $proprietaire) {

           $qualite = $proprietaire->qualites->first()?->qualite ?? '';
            
            $html .= '
                <tr >
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 7pt; border: none;">
                        '.$proprietaire->email.'
                    </td>  
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 7pt; border: none;">
                         '.$proprietaire->fax.'
                    </td>
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 7pt; border: none;">
                         '.$proprietaire->tel.'
                    </td>  
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 7pt; border: none;">
                         '.$proprietaire->adresse.'
                    </td> 
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 8pt; border: none;">
                        '.($proprietaire->type == "physique" ? $proprietaire->cine : $proprietaire->rc).'
                    </td>
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 7pt; border: none;">
                         '.$qualite.'
                    </td> 
                    <td align="center" dir="ltr" style="font-family: dejavusans; font-size: 7pt; border: none;">
                         '.$proprietaire->nom.' '.$proprietaire->prenom.'
                    </td>     
                </tr>
             '; 
        }    

        $html .= '</table>';    

        $this->pdf->writeHTML($html, true, 0, true, 0);


        $html = '
        <br>
        <table cellpadding="2" cellspacing="0" border="0" width="100%"  style="border:none; margin-top: 20px; border-collapse: collapse;">          
          
            <tr>
                <td align="right" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;">
                    الموقع
                </td> 

                <td align="center" style="font-family: dejavusans; font-size: 8pt; border: none;">
                    '.$terrain->adresse.'
                </td>

                <td align="left" style="font-family: dejavusans; font-size: 8pt; border: none;">
                    Emplacement
                </td>
            </tr>
            
            <tr>
                <td align="right" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;">
                    المساحة
                </td> 

                <td align="center" style="font-family: dejavusans; font-size: 8pt; border: none;">
                    '.$terrain->surface.' m²
                </td>

                <td align="left" style="font-family: dejavusans; font-size: 8pt; border: none;">
                    Superficie
                </td>
            </tr> 
            
            <tr>
                <td align="right" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;">
                    ملاحظات
                </td> 

                <td align="center" style="font-family: dejavusans; font-size: 8pt; border: none;">
                    
                </td>

                <td align="left" style="font-family: dejavusans; font-size: 8pt; border: none;">
                    Observation
                </td>
            </tr> 
            
        </table>';

        $this->pdf->writeHTML($html, true, 0, true, 0);


        $html = '
        <br>
        <table cellpadding="2" cellspacing="0" border="0" width="100%"  style="border:none; margin-top: 20px; border-collapse: collapse;">
            <tr>
                <td align="center" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;">
                    أنا الموقع أسفله، أشهد بصحة البيانات بهذا الإقرار
                </td>  
            </tr>            
            <tr>
                <td align="center" style="font-family: dejavusans; font-size: 8pt; border: none;">
                    Je, soussigné, déclare exacte les informations contenues dans cette déclaration
                </td>
            </tr>         
            
        </table>';

        $this->pdf->writeHTML($html, true, 0, true, 0);



          $html = '
        <br>
        <table cellpadding="2" cellspacing="0" border="0" width="100%"  style="border:none; margin-top: 20px; border-collapse: collapse;">
            <tr>
                <td align="center" dir="rtl" style="font-family: droidarabic; font-size: 8pt; border: none;">
                    توقيع المصرح
                </td>  

                <td align="center" style="font-family: dejavusans; font-size: 8pt; border: none;">
                    Signature du Déclarant
                </td>
            </tr>            
                   
            
        </table>';

        $this->pdf->writeHTML($html, true, 0, true, 0);

  
      
    }


    protected function addDetailRow($label, $value)
    {
        $this->pdf->Cell(40, 8, $label, 1, 0, 'R');
        $this->pdf->Cell(0, 8, $value, 1, 1, 'R');
    }

}
