var etude_geotechnique_conclusion_modal_map = undefined;
var last_zones_layer = undefined;

var conclusion_constructible_style = {
    fillColor: '#78D307',
    weight: 2,
    opacity: 1,
    color: 'white',
    dashArray: '3',
    fillOpacity: 0.7
}

var conclusion_non_constructible_style = {
    fillColor: '#C70039',
    weight: 2,
    opacity: 1,
    color: 'white',
    dashArray: '3',
    fillOpacity: 0.7
}

var conclusion_constructible_a_conditions_style = {
    fillColor: '#FFC300',
    weight: 2,
    opacity: 1,
    color: 'white',
    dashArray: '3',
    fillOpacity: 0.7
}

var conclusion_constructible_a_conditions_strictes_style = {
    fillColor: '#FF5733',
    weight: 2,
    opacity: 1,
    color: 'white',
    dashArray: '3',
    fillOpacity: 0.7
}

var googleSat = L.tileLayer('https://www.google.com/maps/vt?lyrs=s@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,
});

var googlehybrid = L.tileLayer('https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,

});

var googlemap = L.tileLayer('https://www.google.com/maps/vt?lyrs=m@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,
});


$(document).ready(function () {
    etude_geotechnique_conclusion_modal_map = new L.Map('etude_geotechnique_conclusion_modal_map', {
        zoomControl: false,
        center: new L.LatLng(32.62087018318113, -6.262207031250001),
        zoom: 6,
        editable: true,
        drawControl: true,
        preferCanvas: true,
        attributionControl: false
    });
    googlehybrid.addTo(etude_geotechnique_conclusion_modal_map);
});

$("#store_etude_geotechnique_conclusion_form").submit(function (event) {
    event.preventDefault();
    var id = $("#store_etude_geotechnique_conclusion_form [name='id']").val();
    var conclusion = $("#store_etude_geotechnique_conclusion_form [name='conclusion']").val();
    var commentaire = $("#store_etude_geotechnique_conclusion_form [name='commentaire']").val();
    var zone = "";
    if (last_zones_layer != undefined) {
        zone = JSON.stringify(last_zones_layer.toGeoJSON());
    }
    var conclusion_data = {
        id: id,
        conclusion: conclusion,
        commentaire: commentaire,
        zone: zone
    };
    etude_geotechnique_conclusion_add(conclusion_data);
    $("#etude_geotechnique_conclusion_modal").modal('hide');
});


function etude_geotechnique_conclusion_add(conclusion) {
    var conclusion_html = `<input  type="checkbox" item_id="${conclusion.id}" class="conclusion_cb" style="vertical-align: middle;position: relative;">&nbsp<a item_id="${conclusion.id}" href="javascript:;" class="conclusion_a">${conclusion.conclusion}</a>`;
    var commentaire_html = '<span> ' + conclusion.commentaire + '</span>';
    var zone_html = '<span> ' + (conclusion.zone.length > 10 ? 'Oui' : 'Non') + '</span>';

    etude_geotechnique_modal_conclusions_table.row.add([conclusion_html, commentaire_html, zone_html, conclusion]).draw();
}

document.getElementById('etude_geotechnique_conclusion_modal_geojson_file').onchange = function () {
    var file = this.files[0];
    var FR = new FileReader();
    FR.readAsText(file);
    FR.onload = function (data) {
        etude_geotechnique_conclusion_modal_map.invalidateSize();
        var content = data.target.result;
        if (last_zones_layer != undefined) {
            last_zones_layer.remove();
            last_zones_layer = undefined;
        }
        last_zones_layer = L.geoJSON(JSON.parse(content));
        last_zones_layer.setStyle(zones_layer_style);
        last_zones_layer.addTo(etude_geotechnique_conclusion_modal_map);
        etude_geotechnique_conclusion_modal_map.fitBounds(last_zones_layer.getBounds());
    }
};
