
var etude_geotechnique_modal_conclusions_table = undefined;

$(document).ready(function () {

    etude_geotechnique_modal_conclusions_table = $('#etude_geotechnique_modal_conclusions_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 5,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        dom: "lBfrtip",
        buttons: [
        ],
        columnDefs: { className: 'text-left', targets: '_all' },
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",

        }
    });

    var etude_geotechnique_modal_file_events = $('#etude_geotechnique_modal_file').dropify({
        messages: {
            'default': 'Faites glisser et déposez un fichier ici',
            'replace': 'Glisser-déposer ou cliquer pour remplacer',
            'remove': 'Supprimer',
            'error': 'Ooops, something wrong happended.'
        },
        error: {
            'fileSize': 'The file size is too big ({{ value }} max).',
            'minWidth': 'The image width is too small ({{ value }}}px min).',
            'maxWidth': 'The image width is too big ({{ value }}}px max).',
            'minHeight': 'The image height is too small ({{ value }}}px min).',
            'maxHeight': 'The image height is too big ({{ value }}px max).',
            'imageFormat': 'The image format is not allowed ({{ value }} only).'
        }
    });


    var etude_geotechnique_modal_effet_site_lithologique_input_events = $('#etude_geotechnique_modal_effet_site_lithologique_input').dropify({
        messages: {
            'default': 'Faites glisser et déposez un fichier ici',
            'replace': 'Glisser-déposer ou cliquer pour remplacer',
            'remove': 'Supprimer',
            'error': 'Ooops, something wrong happended.'
        },
        error: {
            'fileSize': 'The file size is too big ({{ value }} max).',
            'minWidth': 'The image width is too small ({{ value }}}px min).',
            'maxWidth': 'The image width is too big ({{ value }}}px max).',
            'minHeight': 'The image height is too small ({{ value }}}px min).',
            'maxHeight': 'The image height is too big ({{ value }}px max).',
            'imageFormat': 'The image format is not allowed ({{ value }} only).'
        }
    });

    var etude_geotechnique_modal_effet_topo_input_events = $('#etude_geotechnique_modal_effet_topo_input').dropify({
        messages: {
            'default': 'Faites glisser et déposez un fichier ici',
            'replace': 'Glisser-déposer ou cliquer pour remplacer',
            'remove': 'Supprimer',
            'error': 'Ooops, something wrong happended.'
        },
        error: {
            'fileSize': 'The file size is too big ({{ value }} max).',
            'minWidth': 'The image width is too small ({{ value }}}px min).',
            'maxWidth': 'The image width is too big ({{ value }}}px max).',
            'minHeight': 'The image height is too small ({{ value }}}px min).',
            'maxHeight': 'The image height is too big ({{ value }}px max).',
            'imageFormat': 'The image format is not allowed ({{ value }} only).'
        }
    });


    var etude_geotechnique_modal_lpee_file_events = $('#etude_geotechnique_modal_lpee_file').dropify({
        messages: {
            'default': 'Faites glisser et déposez un fichier ici',
            'replace': 'Glisser-déposer ou cliquer pour remplacer',
            'remove': 'Supprimer',
            'error': 'Ooops, something wrong happended.'
        },
        error: {
            'fileSize': 'The file size is too big ({{ value }} max).',
            'minWidth': 'The image width is too small ({{ value }}}px min).',
            'maxWidth': 'The image width is too big ({{ value }}}px max).',
            'minHeight': 'The image height is too small ({{ value }}}px min).',
            'maxHeight': 'The image height is too big ({{ value }}px max).',
            'imageFormat': 'The image format is not allowed ({{ value }} only).'
        }
    });


});

$("body").on('click', '.etude_geotechnique_a', function () {
    $('#etude_geotechnique_modal_file').next(".dropify-clear").trigger("click");
    $('#etude_geotechnique_modal_lpee_file').next(".dropify-clear").trigger("click");

    document.getElementById('store_etude_geotechnique_form').reset();
    $("#store_etude_geotechnique_form [name='id']").val($(this).attr('item_id'));
    $("#etude_geotechnique_modal_conclusions_delete").attr("disabled", "disabled");
    etude_geotechnique_modal_conclusions_table.rows().clear().draw();
    $.ajax({
        url: assetBaseUrl + "douar/" + $(this).attr('item_id'),
        type: "GET",
        success: function (response) {

            $("#etude_geotechnique_modal_loaded_label").css('display', 'none');
            $("#etude_geotechnique_modal_loaded_lpee_label").css('display', 'none');
            $("#etude_geotechnique_modal_effet_site_lithologique_loaded_label").css('display', 'none');
            $("#etude_geotechnique_modal_effet_topo_loaded_label").css('display', 'none');

            if (response.etude_geotechnique != null) {

                response.etude_geotechnique.etudes_geotechniques_documents.forEach(document => {
                    if (document.type_document == "RAPPORT_GEOTECHNIQUE") {
                        $("#etude_geotechnique_modal_loaded_label").css('display', 'block');
                        $("#etude_geotechnique_modal_created_at").text(document.created_at_formated);
                    }
                    if (document.type_document == "EFFET_SITE_LITHOLOGIQUE") {
                        $("#etude_geotechnique_modal_effet_site_lithologique_loaded_label").css('display', 'block');
                        $("#etude_geotechnique_modal_effet_site_lithologique_created_at").text(response.etude_geotechnique.created_at_formated);
                    }
                    if (document.type_document == "EFFET_TOPO") {
                        $("#etude_geotechnique_modal_effet_topo_loaded_label").css('display', 'block');
                        $("#etude_geotechnique_modal_effet_topo_created_at").text(response.etude_geotechnique.created_at_formated);
                    }
                    if (document.type_document == "RAPPORT_GEOTECHNIQUE_LPEE") {
                        $("#etude_geotechnique_modal_loaded_lpee_label").css('display', 'block');
                        $("#etude_geotechnique_modal_lpee_created_at").text(document.created_at_formated);
                    }
                });


                response.etude_geotechnique.etudes_geotechniques_conclusions.forEach(conclusion => {
                    etude_geotechnique_conclusion_add(conclusion);
                });
            }

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });




    $("#etude_geotechnique_modal").modal('show');
});


$("#store_etude_geotechnique_form").submit(function (event) {
    event.preventDefault();
    var formData = new FormData(this);

    var conclusions = [];

    etude_geotechnique_modal_conclusions_table.rows().every(function (rowIdx, tableLoop, rowLoop) {
        conclusions.push(this.data()[this.data().length - 1]);
    });
    formData.append('conclusions', JSON.stringify(conclusions));

    $.ajax({
        url: assetBaseUrl + "centre_donnees/douars_store_etude_geotechnique",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            $("#etat_sol_modal").modal('hide');
            $.toast({
                heading: "HMR",
                text: 'La modification a été enregistrée avec succès.',
                icon: "success",
                position: "bottom-right",
                hideAfter: 3000,
                stack: false,
            });
            douars_table.ajax.reload();
            $("#etude_geotechnique_modal").modal('hide');
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});


$("#etude_geotechnique_modal_conclusions_add").click(function () {
    document.getElementById("store_etude_geotechnique_conclusion_form").reset();
    if (last_zones_layer != undefined) {
        last_zones_layer.remove();
        last_zones_layer = undefined;
    }
    
    $("#etude_geotechnique_conclusion_modal").modal('show');
});

$("#etude_geotechnique_modal_download_rapport").click(function () {
    downloadFile(assetBaseUrl + "douar/files/etude_geotechnique/" + $("#store_etude_geotechnique_form [name='id']").val() + '?t=' + Date.now());
});
$("#etude_geotechnique_modal_lpee_download_rapport").click(function () {
    downloadFile(assetBaseUrl + "douar/files/etude_geotechnique_lpee/" + $("#store_etude_geotechnique_form [name='id']").val() + '?t=' + Date.now());
});


$("#etude_geotechnique_modal_effet_site_lithologique_download").click(function () {
    downloadFile(assetBaseUrl + "douar/files/effet_lithologique/" + $("#store_etude_geotechnique_form [name='id']").val() + '?t=' + Date.now());
});

$("#etude_geotechnique_modal_effet_topo_download").click(function () {
    downloadFile(assetBaseUrl + "douar/files/effet_topo/" + $("#store_etude_geotechnique_form [name='id']").val() + '?t=' + Date.now());
});

$("#etude_geotechnique_modal_upload_constructibilite_add").click(function () {
    $("#etude_geotechnique_modal_upload_constructibilite_input").click();
});

function idToConclusion(id) {
    if (id == "1")
        return "Constructible";
    if (id == "2")
        return "Constructible à conditions";
    if (id == "3")
        return "Constructible à conditions strictes";
    if (id == "4")
        return "Non constructible";
}


$("body").on('click', '.conclusion_a', function () {
    var item_id = $(this).attr('item_id');
    
    $("#etude_geotechnique_conclusion_modal").modal('show');
    etude_geotechnique_conclusion_modal_map.invalidateSize();
    showLoading('HMR', 'Chargement...');
    $.ajax({
        url: assetBaseUrl + "douar/etude_geotechnique/conclusion/" + item_id,
        type: "GET",
        success: function (response) {


            document.getElementById("store_etude_geotechnique_conclusion_form").reset();
            if (last_zones_layer != undefined) {
                last_zones_layer.remove();
                last_zones_layer = undefined;
            }

            $("#store_etude_geotechnique_conclusion_form [name='id']").val(response.id);
            $("#store_etude_geotechnique_conclusion_form [name='conclusion']").val(response.conclusion).change();
            $("#store_etude_geotechnique_conclusion_form [name='commentaire']").text(response.commentaire);

            last_zones_layer = L.geoJSON(JSON.parse(response.zone));
            if (response.conclusion == "Constructible") {
                last_zones_layer.setStyle(conclusion_constructible_style);
            }
            if (response.conclusion == "Constructible à conditions") {
                last_zones_layer.setStyle(conclusion_constructible_a_conditions_style);
            }
            if (response.conclusion == "Constructible à conditions strictes") {
                last_zones_layer.setStyle(conclusion_constructible_a_conditions_strictes_style);
            }
            if (response.conclusion == "Non constructible") {
                last_zones_layer.setStyle(conclusion_non_constructible_style);
            }

            last_zones_layer.addTo(etude_geotechnique_conclusion_modal_map);

            setTimeout(() => {
                etude_geotechnique_conclusion_modal_map.invalidateSize();
                etude_geotechnique_conclusion_modal_map.fitBounds(last_zones_layer.getBounds());

                closeLoading();
            }, 500);


        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });


});

$("body").on('change', '.conclusion_cb', function () {
    if ($(".conclusion_cb:checked").length > 0) {
        $("#etude_geotechnique_modal_conclusions_delete").removeAttr("disabled");
    } else {

        $("#etude_geotechnique_modal_conclusions_delete").attr("disabled", "disabled");
    }
});

$("#etude_geotechnique_modal_conclusions_delete").click(function () {
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir supprimer les éléments sélectionnés?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $('input[type="checkbox"]:checked').each(function () {
                var tr = $(this).closest('tr');              
                etude_geotechnique_modal_conclusions_table.rows(tr).remove().draw();

                $("#etude_geotechnique_modal_conclusions_delete").attr("disabled", "disabled");
            });
        }
    });
});

document.getElementById('etude_geotechnique_modal_upload_constructibilite_input').onchange = function () {
    var file = this.files[0];
    var FR = new FileReader();
    FR.readAsText(file);
    FR.onload = function (data) {
        var content = data.target.result;
        var geojson = L.geoJSON(JSON.parse(content));


        var conclusions_1_geojson = {
            type: "FeatureCollection",
            name: "Constructibilité Douar Tizgui",
            crs: { "type": "name", "properties": { "name": "urn:ogc:def:crs:OGC:1.3:CRS84" } },
            features: []
        }
        var conclusions_2_geojson = {
            type: "FeatureCollection",
            name: "Constructibilité Douar Tizgui",
            crs: { "type": "name", "properties": { "name": "urn:ogc:def:crs:OGC:1.3:CRS84" } },
            features: []
        }
        var conclusions_3_geojson = {
            type: "FeatureCollection",
            name: "Constructibilité Douar Tizgui",
            crs: { "type": "name", "properties": { "name": "urn:ogc:def:crs:OGC:1.3:CRS84" } },
            features: []
        }
        var conclusions_4_geojson = {
            type: "FeatureCollection",
            name: "Constructibilité Douar Tizgui",
            crs: { "type": "name", "properties": { "name": "urn:ogc:def:crs:OGC:1.3:CRS84" } },
            features: []
        }


        geojson.eachLayer(function (layer) {

            var conclusion_id = layer.feature.properties.id;



            if (conclusion_id == "1") {
                conclusions_1_geojson.features.push(layer.toGeoJSON());
            }
            if (conclusion_id == "2") {
                conclusions_2_geojson.features.push(layer.toGeoJSON());
            }
            if (conclusion_id == "3") {
                conclusions_3_geojson.features.push(layer.toGeoJSON());
            }
            if (conclusion_id == "4") {
                conclusions_4_geojson.features.push(layer.toGeoJSON());
            }
        });

        if (conclusions_1_geojson.features.length > 0) {
            var conclusion_data = {
                id: null,
                conclusion: idToConclusion("1"),
                commentaire: '',
                zone: JSON.stringify(conclusions_1_geojson)
            };
            etude_geotechnique_conclusion_add(conclusion_data);
        }

        if (conclusions_2_geojson.features.length > 0) {
            var conclusion_data = {
                id: null,
                conclusion: idToConclusion("2"),
                commentaire: '',
                zone: JSON.stringify(conclusions_2_geojson)
            };
            etude_geotechnique_conclusion_add(conclusion_data);
        }

        if (conclusions_3_geojson.features.length > 0) {
            var conclusion_data = {
                id: null,
                conclusion: idToConclusion("3"),
                commentaire: '',
                zone: JSON.stringify(conclusions_3_geojson)
            };
            etude_geotechnique_conclusion_add(conclusion_data);
        }

        if (conclusions_4_geojson.features.length > 0) {
            var conclusion_data = {
                id: null,
                conclusion: idToConclusion("4"),
                commentaire: '',
                zone: JSON.stringify(conclusions_4_geojson)
            };
            etude_geotechnique_conclusion_add(conclusion_data);
        }




    }
};

function idToConclusion(id) {
    if (id == "1")
        return "Constructible";
    if (id == "2")
        return "Constructible à conditions";
    if (id == "3")
        return "Constructible à conditions strictes";
    if (id == "4")
        return "Non constructible";
}


$("body").on('click', '.conclusion_a', function () {
    var item_id = $(this).attr('item_id');
    
    $("#etude_geotechnique_conclusion_modal").modal('show');
    etude_geotechnique_conclusion_modal_map.invalidateSize();
    showLoading('HMR', 'Chargement...');
    $.ajax({
        url: assetBaseUrl + "douar/etude_geotechnique/conclusion/" + item_id,
        type: "GET",
        success: function (response) {


            document.getElementById("store_etude_geotechnique_conclusion_form").reset();
            if (last_zones_layer != undefined) {
                last_zones_layer.remove();
                last_zones_layer = undefined;
            }

            $("#store_etude_geotechnique_conclusion_form [name='id']").val(response.id);
            $("#store_etude_geotechnique_conclusion_form [name='conclusion']").val(response.conclusion).change();
            $("#store_etude_geotechnique_conclusion_form [name='commentaire']").text(response.commentaire);

            last_zones_layer = L.geoJSON(JSON.parse(response.zone));
            if (response.conclusion == "Constructible") {
                last_zones_layer.setStyle(conclusion_constructible_style);
            }
            if (response.conclusion == "Constructible à conditions") {
                last_zones_layer.setStyle(conclusion_constructible_a_conditions_style);
            }
            if (response.conclusion == "Constructible à conditions strictes") {
                last_zones_layer.setStyle(conclusion_constructible_a_conditions_strictes_style);
            }
            if (response.conclusion == "Non constructible") {
                last_zones_layer.setStyle(conclusion_non_constructible_style);
            }

            last_zones_layer.addTo(etude_geotechnique_conclusion_modal_map);

            setTimeout(() => {
                etude_geotechnique_conclusion_modal_map.invalidateSize();
                etude_geotechnique_conclusion_modal_map.fitBounds(last_zones_layer.getBounds());

                closeLoading();
            }, 500);


        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });


});

$("body").on('change', '.conclusion_cb', function () {
    if ($(".conclusion_cb:checked").length > 0) {
        $("#etude_geotechnique_modal_conclusions_delete").removeAttr("disabled");
    } else {

        $("#etude_geotechnique_modal_conclusions_delete").attr("disabled", "disabled");
    }
});

$("#etude_geotechnique_modal_conclusions_delete").click(function () {
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir supprimer les éléments sélectionnés?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $('input[type="checkbox"]:checked').each(function () {
                var tr = $(this).closest('tr');              
                etude_geotechnique_modal_conclusions_table.rows(tr).remove().draw();

                $("#etude_geotechnique_modal_conclusions_delete").attr("disabled", "disabled");
            });
        }
    });
});