var files_datatable = undefined; 
var current_selected_file_id = undefined;

$(document).ready(function () {
    files_datatable = $('#files_datatable').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: true,
        ajax: assetBaseUrl + 'centre_donnees/plan_types_bet_files_datatable?douar=' + douar.id,
        dom: "lBfrtip",
        buttons: [

        ],
        columnDefs: [
        ],
        columns: [
            { data: 'plan_type' },
            { data: 'architecte' }         

        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }
    });

     


    var plan_type_file_modal_file_pdf_events = $('#plan_type_file_modal_file_pdf').dropify({
        messages: {
            'default': 'Faites glisser et déposez un fichier ici',
            'replace': 'Glisser-déposer ou cliquer pour remplacer',
            'remove': 'Supprimer',
            'error': 'Ooops, something wrong happended.'
        },
        error: {
            'fileSize': 'The file size is too big ({{ value }} max).',
            'minWidth': 'The image width is too small ({{ value }}}px min).',
            'maxWidth': 'The image width is too big ({{ value }}}px max).',
            'minHeight': 'The image height is too small ({{ value }}}px min).',
            'maxHeight': 'The image height is too big ({{ value }}px max).',
            'imageFormat': 'The image format is not allowed ({{ value }} only).'
        }
    });

    var plan_type_file_modal_file_dwg_events = $('#plan_type_file_modal_file_dwg').dropify({
        messages: {
            'default': 'Faites glisser et déposez un fichier ici',
            'replace': 'Glisser-déposer ou cliquer pour remplacer',
            'remove': 'Supprimer',
            'error': 'Ooops, something wrong happended.'
        },
        error: {
            'fileSize': 'The file size is too big ({{ value }} max).',
            'minWidth': 'The image width is too small ({{ value }}}px min).',
            'maxWidth': 'The image width is too big ({{ value }}}px max).',
            'minHeight': 'The image height is too small ({{ value }}}px min).',
            'maxHeight': 'The image height is too big ({{ value }}px max).',
            'imageFormat': 'The image format is not allowed ({{ value }} only).'
        }
    });

});

$("#files_datatable_add").click(function () {
    $("#plan_type_bet_file_modal").modal('show');
})


$("#store_plan_type_file_form").submit(function (event) {
    showLoading('Chargement...', 'Le fichier est en cours de chargement, veuillez patienter');

    event.preventDefault();
    var formData = new FormData(this);

    $.ajax({
        url: assetBaseUrl + "centre_donnees/plan_type_upload",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            closeLoading();

            $("#plan_type_bet_file_modal").modal('hide');
            files_datatable.ajax.reload();
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

function reset_viewer() {
    $("#validation_div").css('display', 'none');
    $("#plan_type_pdf_view").attr('src', '');
    $("#plan_type_nom_label").text("aucun fichier sélectionné");
    $("#plan_type_date_label").text("aucun fichier sélectionné");
    $("#plan_type_architecte_label").text("aucun fichier sélectionné");
    $("#plan_type_etat_label").text("aucun fichier sélectionné");
    $("#plan_type_dwg_label").text("aucun fichier sélectionné");


    $("#plan_type_nom_label").css('color', 'gray');
    $("#plan_type_date_label").css('color', 'gray');
    $("#plan_type_architecte_label").css('color', 'gray');
    $("#plan_type_etat_label").css('color', 'gray');

    $("#plan_type_dwg_label").css("filter", "grayscale(1)");
    $("#plan_type_dwg_label").css("pointer-events", "none");

    $("#remarques_datatable_delete").attr("disabled", "disabled");

    $("#plan_type_dwg_label").attr('plan_type_id', "");
}

$('body').on('click', '.plant_type_a', function () {
    var plan_type_id = $(this).attr('item_id');

    load_file(plan_type_id);

});

function load_file(plan_type_id) {
    showLoading('Chargement...', 'Le fichier est en cours de chargement, veuillez patienter');
    reset_viewer();
    current_selected_file_id = plan_type_id;
    $.ajax({
        url: assetBaseUrl + "centre_donnees/plan_type/" + plan_type_id,
        type: "GET",
        success: function (response) {
            closeLoading();
            $("#plan_type_pdf_view").attr('src', assetBaseUrl + 'centre_donnees/plan_type_file_pdf/' + plan_type_id);

            $("#plan_type_dwg_label").attr('plan_type_id', plan_type_id);

            $("#plan_type_nom_label").text(response.nom);
            $("#plan_type_date_label").text(response.created_at_formated);
            $("#plan_type_architecte_label").text(response.architecte.organisme_ste);
            $("#plan_type_etat_label").text(response.etat);

            $("#plan_type_nom_label").css('color', '#2EA05F');
            $("#plan_type_date_label").css('color', '#2EA05F');
            $("#plan_type_architecte_label").css('color', '#2EA05F');

            if (response.etat == "En cours") {
                $("#plan_type_etat_label").css('color', '#FF8040');
                if (response.can_validate) {
                    $("#validation_div").css('display', 'block');
                }

            }
            if (response.etat == "Validé") {
                $("#plan_type_etat_label").css('color', '#2EA05F');

            }

            if (response.filename_dwg != null) {
                $("#plan_type_dwg_label").text("Télécharger");
                $("#plan_type_dwg_label").css("filter", "unset");
                $("#plan_type_dwg_label").css("pointer-events", "all");
            }


         },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}

$("#plan_type_dwg_label").click(function () {
    var plan_type_id = $(this).attr('plan_type_id');
    downloadFile(assetBaseUrl + 'centre_donnees/plan_type_file_dwg/' + plan_type_id);
});


$("body").on('change', '.plant_type_cb', function () {
    if ($(".plant_type_cb:checked").length > 0) {
        $("#files_datatable_delete").removeAttr("disabled");
    } else {

        $("#files_datatable_delete").attr("disabled", "disabled");
    }
});

$("#files_datatable_delete").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir supprimer  les 'éléments sélectionnés?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {


            var ids = [];
            $(".plant_type_cb").each(function () {
                if ($(this).prop('checked')) {
                    ids.push($(this).attr('item_id'));

                    if (current_selected_file_id == $(this).attr('item_id')) {
                        reset_viewer();
                    }
                }

            });

            $.ajax({
                url: assetBaseUrl + "centre_donnees/delete_plan_type",
                type: "POST",
                data: {
                    _token: csrfToken,
                    ids: JSON.stringify(ids),
                },
                success: function (response) {
                    files_datatable.ajax.reload();
                    $.toast({
                        heading: "HMR",
                        text: 'Modification terminé avec succès',
                        icon: "success",
                        position: "bottom-right",
                        hideAfter: 3000,
                        stack: false,
                    });
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });

            $("#files_datatable_delete").attr("disabled", "disabled");
        }
    });
});
  