var prestataires_table = undefined;

$(document).ready(function () {
    charges_guichets_table = $('#charges_guichets_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: true,
        scrollX: false,
        ajax: assetBaseUrl + 'centre_donnees/charges_guichets_datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
        ],
        columnDefs: { className: 'text-center', targets: '_all' },
        columns: [
            {
                data: 'email',
            },
            {
                data: 'nom',
            },
            {
                data: 'prenom',
            },
            {
                data: 'tel',
            },
            {
                data: 'guichet',
            },
            {
                data: 'date',
            },
            {
                data: 'invitation',
            }

        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",

        }
    });



});

$("#charge_guichet_add").click(function () {
    document.getElementById("store_charge_guichet_form").reset();
    $("#add_charge_guichet_modal").modal('show');
});

$("#store_charge_guichet_form").submit(function (event) {

    event.preventDefault();
    var formData = new FormData(this);
    $.ajax({
        url: assetBaseUrl + "user/store_charge_guichet",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            if (response.success == 1) {
                $("#add_charge_guichet_modal").modal('hide');
                $.toast({
                    heading: "HMR",
                    text: 'Le prestataire a été créé avec succès.',
                    icon: "success",
                    position: "bottom-right",
                    hideAfter: 3000,
                    stack: false,
                });

                charges_guichets_table.ajax.reload();
            }
            else {
                Swal.fire({
                    icon: "error",
                    title: "HMR",
                    text: "Cet email est déjà présent dans notre base de données.",

                });

            }


        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

$("body").on('click', '.prestataire_a', function () {

    $.ajax({
        url: assetBaseUrl + "user/" + $(this).attr('item_id'),
        type: "GET",
        dataType: "json",

        success: function (response) {
            $("#store_charge_guichet_form [name='id']").val(response.id);
            $("#store_charge_guichet_form [name='nom']").val(response.nom);
            $("#store_charge_guichet_form [name='prenom']").val(response.prenom);
            $("#store_charge_guichet_form [name='email']").val(response.email);
            $("#store_charge_guichet_form [name='tel']").val(response.tel);


            if (response.validation_completed_date != null) {
                $("#store_charge_guichet_form [name='email']").attr('disabled', 'disabled');
            }
            else {
                $("#store_charge_guichet_form [name='email']").removeAttr('disabled');
            }
            $("#add_charge_guichet_modal").modal('show');

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });

});


$("body").on('change', "#charges_guichets_table .prestataire_cb", function () {
    if ($("#charges_guichets_table .prestataire_cb").length > 0) {

        $("#send_invitation").removeAttr("disabled");

    } else {
        $("#send_invitation").attr("disabled", "disabled");
    }
});
$("#send_invitation").click(function () {
    loading_popup = Swal.fire({
        title: 'Chargement',
        html: 'Envoie des invitation...',
        timer: 2000000000,
        timerProgressBar: true,
        hideOnOverlayClick: false,
        hideOnContentClick: false,
        allolwOutsideClick: false,
        closeClick: false,
        helpers: {
            overlay: { closeClick: false }
        },
        didOpen: () => {
            Swal.showLoading()

        },
        willClose: () => {

        }
    }).then((result) => {

    })


    $("#charges_guichets_table .prestataire_cb").each(function () {

        $.ajax({
            url: assetBaseUrl + "send-invitation-mail/" + $(this).attr('item_id'),
            type: "GET",
            dataType: "json",

            success: function (response) {
                Swal.close();

                $.toast({
                    heading: "HMR",
                    text: 'Invitation(s) envoyée(s).',
                    icon: "success",
                    position: "bottom-right",
                    hideAfter: 3000,
                    stack: false,
                });

                prestataires_table.ajax.reload();
                $("#prestataires_delete").attr("disabled", "disabled");
                $("#send_invitation").attr("disabled", "disabled");
                $("#edit_etat_engagement").attr("disabled", "disabled");
            },
            error: function (xhr, status, error) {
                console.log(xhr.responseText);
            },
        });



    });

});
