var douars_table = undefined;
var affectation_des_prestations_modal_douars = undefined;
var douars_select_modal_douars = undefined;
var etat_deblaiement_modal_historique_table = undefined;
var douars_select_modal_douars_checked_list = [];

var affectation_douar_cb_checked_list = [];

$(document).ready(function () {
    douars_table = $('#douars_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'centre_donnees/douars_datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '<button class="btn"><i class="fa fa-file-excel-o" ></i>  Exporter Excel</button>',
                "titleAttr": 'excel',
                'title': '',
                "action": newexportaction
            },
        ],
        columnDefs: [
        ],
        columns: douars_tab_columns,
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }
    });

    affectation_des_prestations_modal_douars = $('#affectation_des_prestations_modal_douars').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: true,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        scrollY: "360px",
        ajax: null,
        dom: "lBfrtip",
        buttons: [
        ],
        columnDefs: { className: 'text-left', targets: '_all' },
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }
    });

    douars_select_modal_douars = $('#douars_select_modal_douars').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 15,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'centre_donnees/douars_datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
        ],
        columnDefs: { className: 'text-left', targets: '_all' },
        columns: [
            {
                data: 'douar_cb',
            },
            {
                data: 'commune',
            },
            // {
            //     data: 'cercle',
            // },
            {
                data: 'province',
            },
            {
                data: 'prestataire',
            }
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }
    });

    etat_deblaiement_modal_historique_table = $('#etat_deblaiement_modal_historique_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 10,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'douar/deblaiement/datatable/get?douar_id=-1',
        dom: "lBfrtip",
        buttons: [
        ],
        columnDefs: { className: 'text-left', targets: '_all' },
        columns: [
            {
                data: 'etat',
            },
            {
                data: 'date',
            },
            {
                data: 'user',
            }


        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }
    });



    douars_select_modal_douars.on('draw', function () {

        $(".douars_select_modal_douars_select_all_cb").prop('checked', false);
        douars_select_modal_douars_checked_list.forEach(douar => {
            $('.douar_cb[item_id="' + douar.id + '"]').prop('checked', true);
        });
    });



    douars_table.on('draw', function () {
        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });
    });

});

$("#affectation_prestations_btn").click(function () {
    $("#affectation_des_prestations_modal_prestataire").change();
    $("#affectation_des_prestations_modal").modal('show');
});

$("#affectation_des_prestations_modal_add_douar").click(function () {

    douars_select_modal_douars_checked_list = [];
    $("#select_modal_provinces_filter").val('all').change();
    //douars_select_modal_douars.ajax.url(assetBaseUrl + 'centre_donnees/douars_datatable?prestataire_role=' + $("#affectation_des_prestations_modal_type").val() + '&filters=[]').load();
    $("#douars_select_modal_douars_seclted_counter").text('0');
    $("#douars_select_modal").modal('show');
});

$("body").on('change', '.douar_cb', function () {

    var checked = $(this).prop('checked');
    var tr = $(this).closest('tr');
    var data = douars_select_modal_douars.rows(tr).data();
    data = data[0];

    if (checked) {
        var douar = {
            id: data.id,
            nom: data.nom,
            commune: data.commune,
            cercle: data.cercle,
            province: data.province,
        }
        douars_select_modal_douars_checked_list = douars_select_modal_douars_checked_list.filter(function (obj) {
            return obj.id !== data.id;
        });
        douars_select_modal_douars_checked_list.push(douar);
    }
    else {
        douars_select_modal_douars_checked_list = douars_select_modal_douars_checked_list.filter(function (obj) {
            return obj.id !== data.id;
        });
    }

    $("#douars_select_modal_douars_seclted_counter").text(douars_select_modal_douars_checked_list.length);
});


$("#douars_select_modal_douars_save").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    $.ajax({
        url: assetBaseUrl + "set_dours/" + $("#affectation_des_prestations_modal_prestataire").val(),
        type: "POST",
        data: {
            _token: csrfToken,
            douars: JSON.stringify(douars_select_modal_douars_checked_list)
        },
        success: function (response) {
            $("#douars_select_modal").modal('hide');
            douars_select_modal_douars_checked_list = [];
            refresh_affectation_des_prestations_modal_douars();
            douars_table.ajax.reload();
        },
        error: function (xhr, status, error) {

            console.log(xhr.responseText);
        },
    });

});
$("#affectation_des_prestations_modal_prestataire").change(function () {
    refresh_affectation_des_prestations_modal_douars();
});

function refresh_affectation_des_prestations_modal_douars() {
    affectation_douar_cb_checked_list = [];
    $("#affectation_des_prestations_modal_delete_douar").attr("disabled", "disabled");
    affectation_des_prestations_modal_douars.row().clear().draw();
    $.ajax({
        url: assetBaseUrl + "get_dours/" + $("#affectation_des_prestations_modal_prestataire").val(),
        type: "GET",
        success: function (response) {

            response.douars.forEach(douar => {
                var data = {
                    id: douar.id,
                    nom: douar.nom,
                    commune: douar.commune_nom,
                    cercle: douar.cercle_nom,
                    province: douar.province_nom,
                }
                affectation_des_prestations_modal_douars_add(data);
            });
            affectation_des_prestations_modal_douars.draw();
        },
        error: function (xhr, status, error) {

            console.log(xhr.responseText);
        },
    });
}

$("body").on('change', '.affectation_douar_cb', function () {

    $("#affectation_des_prestations_modal_reaffectation").attr('disabled', 'disabled');
    affectation_douar_cb_checked_list = [];
    $(".affectation_douar_cb").each(function () {
        var checked = $(this).prop('checked');
        if (checked) {
            affectation_douar_cb_checked_list.push($(this).attr('item_id'));
            $("#affectation_des_prestations_modal_reaffectation").removeAttr('disabled');
        }
    });

    if (affectation_douar_cb_checked_list.length == 0) {
        $("#affectation_des_prestations_modal_reaffectation").attr('disabled', 'disabled');
    }
});

$("#affectation_des_prestations_modal_reaffectation").click(function () {

    $("#reaffectation_modal_type").val($("#affectation_des_prestations_modal_type option:selected").text());
    $("#reaffectation_modal_old_prestataire").val($("#affectation_des_prestations_modal_prestataire option:selected").text());
    $("#reaffectation_modal_new_prestataire").empty();

    $("#affectation_des_prestations_modal_prestataire option").each(function () {

        $("#reaffectation_modal_new_prestataire").append(new Option($(this).text(), $(this).val()));
    });

    $("#reaffectation_modal_new_prestataire").val($("#affectation_des_prestations_modal_prestataire").val());

    $("#reaffectation_modal").modal('show');
});


$("#reaffectation_modal_save").click(function () {




    swal.fire({
        title: 'Confirmation',
        text: "Veuillez noter que la réaffectation implique que le nouveau prestataire aura accès à l'ensemble des dossiers, y compris ceux qui étaient initialement attribués à l'ancien prestataire. Ce dernier ne pourra plus accéder à ces dossiers, mais les plans et les documents déjà téléchargés resteront associés à son nom.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {
            var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
            $.ajax({
                url: assetBaseUrl + "centre_donnees/reaffecter",
                type: "POST",
                data: {
                    _token: csrfToken,
                    new_prestataire: $("#reaffectation_modal_new_prestataire").val(),
                    douars: JSON.stringify(affectation_douar_cb_checked_list),
                    old_prestataire: $("#affectation_des_prestations_modal_prestataire").val()
                },
                success: function (response) {

                    $("#reaffectation_modal").modal('hide');

                    refresh_affectation_des_prestations_modal_douars();
                },
                error: function (xhr, status, error) {

                    console.log(xhr.responseText);
                },
            });
        }
    });


});

function affectation_des_prestations_modal_douars_add(douar) {
    var douar_html = '<input style="vertical-align: middle;position: relative;" class="affectation_douar_cb" item_id="' + douar.id + '" type="checkbox"><span class="douar-a">&nbsp' + douar.nom + "</span>";
    var commune_html = '<span> ' + douar.commune + '</span>';
    var cercle_html = '<span> ' + douar.cercle + '</span>';
    var province_html = '<span> ' + douar.province + '</span>';
    var delete_html = `<button style="padding: 0px;" type="button" class="btn btn-danger delete_affectation_btn" douar_id="${douar.id}" > <i class="fa-solid fa-trash"></i>&nbsp;Supprimer</button>`;

    affectation_des_prestations_modal_douars.row.add([douar_html, commune_html, cercle_html, province_html, delete_html, douar]);
}

$("#affectation_des_prestations_modal_type").change(function () {
    $("#affectation_des_prestations_modal_prestataire").empty();

    $.ajax({

        url: assetBaseUrl + "user/get_by_role/" + $("#affectation_des_prestations_modal_type").val(),
        type: "GET",
        success: function (response) {
            response.forEach(user => {
                $("#affectation_des_prestations_modal_prestataire").append(new Option(user.organisme_ste, user.id));
            });
            $("#affectation_des_prestations_modal_prestataire").change();
        },
        error: function (xhr, status, error) {

            console.log(xhr.responseText);
        },
    });
});

$("body").on('change', '.index_douar_cb', function () {
    if ($(".index_douar_cb:checked").length > 0) {
        $("#etat_sol_btn").removeAttr("disabled");
    } else {

        $("#etat_sol_btn").attr("disabled", "disabled");
    }
});

$("#etat_sol_btn").click(function () {

    document.getElementById("store_etat_sol_form").reset();
    var ids = [];
    $(".index_douar_cb:checked").each(function () {
        ids.push($(this).attr('item_id'));
    });
    $("#store_etat_sol_form [name='ids']").val(ids.join(","));
    $("#etat_sol_modal").modal('show');
});

$("#store_etat_sol_form").submit(function (event) {
    event.preventDefault();
    var formData = new FormData(this);
    $.ajax({
        url: assetBaseUrl + "centre_donnees/douars_edit_etat_sol",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            $("#etat_sol_modal").modal('hide');
            $.toast({
                heading: "HMR",
                text: 'La modification a été enregistrée avec succès.',
                icon: "success",
                position: "bottom-right",
                hideAfter: 3000,
                stack: false,
            });
            douars_table.ajax.reload();

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});


$("#provinces_filter").change(function () {

    refresh_situation_filters("provinces_filter", "cercles_filter", "communes_filter", "douars_filter", 'province');
});
$("#cercles_filter").change(function () {
    refresh_situation_filters("provinces_filter", "cercles_filter", "communes_filter", "douars_filter", 'cercle');
});
$("#communes_filter").change(function () {
    refresh_situation_filters("provinces_filter", "cercles_filter", "communes_filter", "douars_filter", 'commune');
});
$("#douars_filter").change(function () {
    refresh_situation_filters("provinces_filter", "cercles_filter", "communes_filter", "douars_filter", 'douar');
});


$("#select_modal_provinces_filter").change(function () {

    refresh_situation_filters("select_modal_provinces_filter", "select_modal_cercles_filter", "select_modal_communes_filter", "select_modal_douars_filter", 'province');
});
$("#select_modal_cercles_filter").change(function () {
    refresh_situation_filters("select_modal_provinces_filter", "select_modal_cercles_filter", "select_modal_communes_filter", "select_modal_douars_filter", 'cercle');
});
$("#select_modal_communes_filter").change(function () {
    refresh_situation_filters("select_modal_provinces_filter", "select_modal_cercles_filter", "select_modal_communes_filter", "select_modal_douars_filter", 'commune');
});
$("#select_modal_douars_filter").change(function () {
    refresh_situation_filters("select_modal_provinces_filter", "select_modal_cercles_filter", "select_modal_communes_filter", "select_modal_douars_filter", 'douar');
});








function fill_situation_filter_cercle(id, province_id) {
    $("#" + id).empty();
    $("#" + id).append(new Option('Indifferent', 'all'));
    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                $("#" + id).append(new Option(cercle.nom, cercle.id));
            }
        }
        else {
            $("#" + id).append(new Option(cercle.nom, cercle.id));
        }
    });
}

function fill_situation_filter_commune(id, province_id, cercle_id) {
    $("#" + id).empty();
    $("#" + id).append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });

    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        $("#" + id).append(new Option(commune.nom, commune.id));
                    }
                }
                else {
                    $("#" + id).append(new Option(commune.nom, commune.id));
                }
            }
        });
    });

}


function fill_situation_filter_douar(id, province_id, cercle_id, commune_id) {

    console.log({
        province_id: province_id,
        cercle_id: cercle_id,
        commune_id: commune_id,
    });
    $("#" + id).empty();
    $("#" + id).append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });
    console.log(filtred_cercles);

    var filtred_communes = [];
    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        filtred_communes.push(commune);
                    }
                }
                else {
                    filtred_communes.push(commune);
                }
            }
        });
    });
    console.log(filtred_communes);
    filtred_communes.forEach(commune => {
        douars.forEach(douar => {
            if (douar.commune_id == commune.id) {
                if (commune_id != 'all') {
                    if (commune.id == commune_id) {
                        $("#" + id).append(new Option(douar.nom, douar.id));
                    }
                }
                else {
                    $("#" + id).append(new Option(douar.nom, douar.id));
                }
            }
        });
    });

}
function refresh_situation_filters(_province_id, _cercle_id, _commune_id, _douar_id, trigger_source) {

    if (trigger_source == 'province') {
        fill_situation_filter_cercle(_cercle_id, $("#" + _province_id).val(), 'all');
        fill_situation_filter_commune(_commune_id, $("#" + _province_id).val(), 'all');
        fill_situation_filter_douar(_douar_id, $("#" + _province_id).val(), 'all', 'all');
    }
    if (trigger_source == 'cercle') {
        var province_id = undefined;

        if ($("#" + _cercle_id).val() == 'all') {
            refresh_situation_filters(_province_id, _cercle_id, _commune_id, _douar_id, 'province');
            return;
        }

        cercles.forEach(cercle => {
            if (cercle.id == $("#" + _cercle_id).val()) {
                province_id = cercle.province_id;
            }
        });

        $("#" + _province_id).val(province_id);
        $('#' + _province_id).trigger('change.select2');


        fill_situation_filter_commune(_commune_id, province_id, $("#" + _cercle_id).val());
        fill_situation_filter_douar(_douar_id, province_id, $("#" + _cercle_id).val(), 'all');
    }

    if (trigger_source == 'commune') {
        var province_id = undefined;
        var cercle_id = undefined;

        if ($("#" + _commune_id).val() == 'all') {
            refresh_situation_filters(_province_id, _cercle_id, _commune_id, _douar_id, 'cercle');
            return;
        }

        communes.forEach(commune => {
            if (commune.id == $("#" + _commune_id).val()) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#" + _province_id).val(province_id);
        $('#' + _province_id).trigger('change.select2');

        $("#" + _cercle_id).val(cercle_id);
        $('#' + _cercle_id).trigger('change.select2');


        fill_situation_filter_douar(_douar_id, province_id, $("#" + _cercle_id).val(), $("#" + _commune_id).val(), 'all');
    }

    if (trigger_source == 'douar') {
        var province_id = undefined;
        var cercle_id = undefined;
        var commune_id = undefined;

        if ($("#" + _douar_id).val() == 'all') {
            refresh_situation_filters(_province_id, _cercle_id, _commune_id, _douar_id, 'commune');
            return;
        }

        douars.forEach(douar => {
            if (douar.id == $("#" + _douar_id).val()) {
                commune_id = douar.commune_id;
            }
        });

        communes.forEach(commune => {
            if (commune.id == commune_id) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#" + _province_id).val(province_id);
        $('#' + _province_id).trigger('change.select2');

        $("#" + _cercle_id).val(cercle_id);
        $('#' + _cercle_id).trigger('change.select2');

        $("#" + _commune_id).val(commune_id);
        $('#' + _commune_id).trigger('change.select2');


    }
}

function filter_tab_douar_index_table() {
    var filters = [];

    $(".dt_filter").each(function () {
        var column = $(this).attr('column');
        var table = $(this).attr('table');
        var value = $(this).val();
        if (value != 'all') {
            filters.push({ column: column, table: table, value: value });
        }
    });

    if ($("#etude_geotechnique_filter").val() != 'all') {
        var column = "etude_geotechnique";
        var table = "";
        var value = parseInt($("#etude_geotechnique_filter").val());
        filters.push({ column: column, table: table, value: value });
    }
    douars_table.ajax.url(assetBaseUrl + 'centre_donnees/douars_datatable' + '?filters=' + JSON.stringify(filters)).load();
}

$(".dt_filter").change(function () {
    filter_tab_douar_index_table();
});
$(".custom_filter").change(function () {
    filter_tab_douar_index_table();
});



function filter_tab_douar_modal_select_douars_table() {
    var filters = [];

    $(".douars_select_modal_filter").each(function () {
        var column = $(this).attr('column');
        var table = $(this).attr('table');
        var value = $(this).val();
        if (value != 'all') {
            filters.push({ column: column, table: table, value: value });
        }
    });

    douars_select_modal_douars.ajax.url(assetBaseUrl + 'centre_donnees/douars_datatable' + '?prestataire_role=' + $("#affectation_des_prestations_modal_type").val() + '&filters=' + JSON.stringify(filters)).load();
}

$(".douars_select_modal_filter").change(function () {
    filter_tab_douar_modal_select_douars_table();
});




$('body').on('click', ".etat_deblaiement_a", function () {
    $("#store_deblaiement_form [name='douar_id']").val($(this).attr('douar_id'));

    showLoading('HMR', 'Chargement...');
    $.ajax({
        url: assetBaseUrl + "douar/deblaiement/" + $(this).attr('douar_id'),
        type: "GET",
        dataType: "json",

        success: function (response) {
            closeLoading();
            if (response.success == 1) {
                $("#store_deblaiement_form [name='concerne']").prop('checked', response.deblaiement.concerne == 1);
                $("#store_deblaiement_form [name='concerne']").change();


                $("#store_deblaiement_form [name='entame']").prop('checked', response.deblaiement.entame == 1);
                $("#store_deblaiement_form [name='entame']").change();

                $("#store_deblaiement_form [name='acheve']").prop('checked', response.deblaiement.acheve == 1);
                $("#store_deblaiement_form [name='acheve']").change();

                $("#store_deblaiement_form [name='progression']").val(response.deblaiement.progression);

                if (response.deblaiement.acheve == 1) {
                    $("#store_deblaiement_form [name='date_achevement']").data('daterangepicker').setStartDate(response.deblaiement.date_achevement_formated);
                }


            }
            else {
                $("#store_deblaiement_form [name='concerne']").prop('checked', false);
                $("#store_deblaiement_form [name='concerne']").change();

                $("#store_deblaiement_form [name='entame']").prop('checked', false);
                $("#store_deblaiement_form [name='entame']").change();

                $("#store_deblaiement_form [name='acheve']").prop('checked', false);
                $("#store_deblaiement_form [name='acheve']").change();


            }

            $("#etat_deblaiement_modal_deblaiement_div").css('display', 'none');
            $("#etat_deblaiement_modal_concerne_div").css('display', 'block');

            etat_deblaiement_modal_historique_table.ajax.url(assetBaseUrl + 'douar/deblaiement/datatable/get?douar_id=' + $("#store_deblaiement_form [name='douar_id']").val(),).load();

            $("#etat_deblaiement_modal").modal('show');
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});
$('body').on('click', ".deblaiement_a", function () {
    $("#store_deblaiement_form [name='douar_id']").val($(this).attr('douar_id'));

    showLoading('HMR', 'Chargement...');
    $.ajax({
        url: assetBaseUrl + "douar/deblaiement/" + $(this).attr('douar_id'),
        type: "GET",
        dataType: "json",

        success: function (response) {
            closeLoading();
            if (response.success == 1) {
                $("#store_deblaiement_form [name='concerne']").prop('checked', response.deblaiement.concerne == 1);
                $("#store_deblaiement_form [name='concerne']").change();


                $("#store_deblaiement_form [name='entame']").prop('checked', response.deblaiement.entame == 1);
                $("#store_deblaiement_form [name='entame']").change();

                $("#store_deblaiement_form [name='acheve']").prop('checked', response.deblaiement.acheve == 1);
                $("#store_deblaiement_form [name='acheve']").change();

                $("#store_deblaiement_form [name='progression']").val(response.deblaiement.progression);

                if (response.deblaiement.acheve == 1) {
                    $("#store_deblaiement_form [name='date_achevement']").data('daterangepicker').setStartDate(response.deblaiement.date_achevement_formated);
                }


            }
            else {
                $("#store_deblaiement_form [name='concerne']").prop('checked', false);
                $("#store_deblaiement_form [name='concerne']").change();

                $("#store_deblaiement_form [name='entame']").prop('checked', false);
                $("#store_deblaiement_form [name='entame']").change();

                $("#store_deblaiement_form [name='acheve']").prop('checked', false);
                $("#store_deblaiement_form [name='acheve']").change();


            }
            $("#etat_deblaiement_modal_deblaiement_div").css('display', 'block');
            $("#etat_deblaiement_modal_concerne_div").css('display', 'none');

            etat_deblaiement_modal_historique_table.ajax.url(assetBaseUrl + 'douar/deblaiement/datatable/get?douar_id=' + $("#store_deblaiement_form [name='douar_id']").val(),).load();
            $("#etat_deblaiement_modal").modal('show');
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});



$("#store_deblaiement_form [name='entame']").change(function () {
    if ($(this).prop('checked')) {
        $("#store_deblaiement_form [name='progression']").removeAttr('disabled');
    }
    else {
        $("#store_deblaiement_form [name='progression']").attr('disabled', 'disabled');
    }
});

$("#store_deblaiement_form [name='acheve']").change(function () {
    if ($(this).prop('checked')) {
        $("#store_deblaiement_form [name='date_achevement']").removeAttr('disabled');
        $("#store_deblaiement_form [name='date_achevement']").data('daterangepicker').setStartDate(current_date);
    }
    else {
        $("#store_deblaiement_form [name='date_achevement']").attr('disabled', 'disabled');
        $("#store_deblaiement_form [name='date_achevement']").val('Aucune date');
    }
});



$("#store_deblaiement_form").submit(function (event) {
    event.preventDefault();
    var formData = new FormData(this);
    $.ajax({
        url: assetBaseUrl + "douar/deblaiement/store",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            $("#etat_sol_modal").modal('hide');
            $.toast({
                heading: "HMR",
                text: 'La modification a été enregistrée avec succès.',
                icon: "success",
                position: "bottom-right",
                hideAfter: 3000,
                stack: false,
            });
            $("#etat_deblaiement_modal").modal('hide');
            douars_table.ajax.reload();

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

$("#store_deblaiement_form [name='non_concerne']").change(function () {

    var non_concerne = $("#store_deblaiement_form [name='non_concerne']").prop('checked');

    if (non_concerne) {
        $("#store_deblaiement_form [name='concerne']").prop('checked', false);
        $("#etat_deblaiement_modal_concerne_div").addClass('disabled');

    }
});

$("#store_deblaiement_form [name='concerne']").change(function () {
    var concerne = $("#store_deblaiement_form [name='concerne']").prop('checked');

    if (concerne) {
        $("#store_deblaiement_form [name='non_concerne']").prop('checked', false);
        $("#etat_deblaiement_modal_concerne_div").removeClass('disabled');
    }
    else {
        $("#etat_deblaiement_modal_concerne_div").addClass('disabled');
    }

});

$(".douars_select_modal_douars_select_all_cb").change(function () {
    var checked = $(this).prop('checked');
    if (checked) {

        $(".douar_cb").prop('checked', true);
        $(".douar_cb").each(function () {
            var tr = $(this).closest('tr');
            if (douars_select_modal_douars.rows(tr) != undefined) {
                var data = douars_select_modal_douars.rows(tr).data();
                data = data[0];

                var douar = {
                    id: data.id,
                    nom: data.nom,
                    commune: data.commune,
                    cercle: data.cercle,
                    province: data.province,
                }
                douars_select_modal_douars_checked_list = douars_select_modal_douars_checked_list.filter(function (obj) {
                    return obj.id !== data.id;
                });
                douars_select_modal_douars_checked_list.push(douar);
            }
        });
        $("#douars_select_modal_douars_seclted_counter").text(douars_select_modal_douars_checked_list.length);
    }
    else {

        $(".douar_cb").prop('checked', false);
        $(".douar_cb").each(function () {
            if (!$(this).prop('checked')) {
                var tr = $(this).closest('tr');

                if (douars_select_modal_douars.rows(tr) != undefined) {
                    var data = douars_select_modal_douars.rows(tr).data();
                    data = data[0];
                    douars_select_modal_douars_checked_list = douars_select_modal_douars_checked_list.filter(function (obj) {
                        return obj.id !== data.id;
                    });
                }

            }
        });
        $("#douars_select_modal_douars_seclted_counter").text(douars_select_modal_douars_checked_list.length);

    }


})



$("body").on('click', '.delete_affectation_btn', function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");

    var douar_id = $(this).attr('douar_id');
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir supprimer les 'éléments sélectionnés?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {
            showLoading('HMR', 'Chargement...');
            $.ajax({
                url: assetBaseUrl + "centre_donnees/check_affectation_delection",
                type: "POST",
                data: {
                    _token: csrfToken,
                    douar_id: douar_id,
                    prestataire_id: $("#affectation_des_prestations_modal_prestataire").val(),
                    role: $("#affectation_des_prestations_modal_type option:selected").text(),
                    force_delete: 0,
                },
                success: function (response) {
                    if (response.success == 1) {

                        $.toast({
                            heading: "HMR",
                            text: 'La modification a été enregistrée avec succès.',
                            icon: "success",
                            position: "bottom-right",
                            hideAfter: 3000,
                            stack: false,
                        });
                        refresh_affectation_des_prestations_modal_douars();
                        closeLoading();
                    }
                    else {
                        if (response.error == "USER_HAS_DEMANDES") {
                            swal.fire({
                                title: 'Confirmation',
                                text: "Attention, le prestataire que vous souhaitez désaffecter détient " + response.count + " dossier(s) en cours. Bien qu'il conserve l'accès à ces dossiers, les futurs dossiers ne lui seront pas attribués.",

                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#88C241',
                                cancelButtonColor: '#F83F37',
                                confirmButtonText: 'Oui',
                                cancelButtonText: 'Non'
                            }).then((result) => {
                                if (result.isConfirmed) {

                                    $.ajax({
                                        url: assetBaseUrl + "centre_donnees/check_affectation_delection",
                                        type: "POST",
                                        data: {
                                            _token: csrfToken,
                                            douar_id: douar_id,
                                            prestataire_id: $("#affectation_des_prestations_modal_prestataire").val(),
                                            role: $("#affectation_des_prestations_modal_type option:selected").text(),
                                            force_delete: 1,
                                        },
                                        success: function (response) {
                                            if (response.success == 1) {

                                                $.toast({
                                                    heading: "HMR",
                                                    text: 'La modification a été enregistrée avec succès.',
                                                    icon: "success",
                                                    position: "bottom-right",
                                                    hideAfter: 3000,
                                                    stack: false,
                                                });
                                                refresh_affectation_des_prestations_modal_douars();
                                                closeLoading();
                                            }
                                            else {
                                                closeLoading();
                                            }

                                        }
                                    });
                                }
                            });
                        }

                    }
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });

        }
    });

});

$("#add_douar_btn").click(function () {
    $("#add_douar_modal").modal('show');
});


$("#add_douar_modal_provinces_filter").change(function () {
    refresh_situation_filters("add_douar_modal_provinces_filter", "add_douar_modal_cercles_filter", "add_douar_modal_communes_filter", "add_douar_modal_douars_filter", 'province');
    refresh_add_douar_modal_submit();
});
$("#add_douar_modal_cercles_filter").change(function () {
    refresh_situation_filters("add_douar_modal_provinces_filter", "add_douar_modal_cercles_filter", "add_douar_modal_communes_filter", "add_douar_modal_douars_filter", 'cercle');
    refresh_add_douar_modal_submit();
});

$("#add_douar_modal_communes_filter").change(function () {
    refresh_situation_filters("add_douar_modal_provinces_filter", "add_douar_modal_cercles_filter", "add_douar_modal_communes_filter", "add_douar_modal_douars_filter", 'commune');
    refresh_add_douar_modal_submit();
});

 
$("#add_douar_modal_douar").change(function () {
    refresh_add_douar_modal_submit();
});

$("#add_douar_modal_douar").keyup(function () {
    refresh_add_douar_modal_submit();
});

function refresh_add_douar_modal_submit() {
    $("#add_douar_modal_submit").attr('disabled', 'disabled');
    var province = $("#add_douar_modal_provinces_filter").val();
    var cercle = $("#add_douar_modal_cercles_filter").val();
    var commune = $("#add_douar_modal_communes_filter").val();
    var douar = $("#add_douar_modal_douar").val();

    if (province != 'all') {
        if (cercle != 'all') {
            if (commune != 'all') {
                if (douar.length > 0) {
                    $("#add_douar_modal_submit").removeAttr('disabled');
                }
            }
        }
    }
}

$("#store_new_douar_form").submit(function (event) {

    event.preventDefault();
    var formData = new FormData(this);
    $.ajax({
        url: assetBaseUrl + "centre_donnees/store_new_douar",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            if (response.success == 1) {
                $("#add_douar_modal").modal('hide');
                $.toast({
                    heading: "HMR",
                    text: 'La modification a été enregistrée avec succès.',
                    icon: "success",
                    position: "bottom-right",
                    hideAfter: 3000,
                    stack: false,
                });
                douars_table.ajax.reload();
            }
            else {
                if (response.error = 'DUPLICATED_DOUAR') {
                    gl_alert('error', 'HMR', "Le douar que vous êtes en train d'ajouter est déjà présent.");
                }
            }
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});
