var guichets_table = undefined;

$(document).ready(function () {
    guichets_table = $('#guichets_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'guichets/datatable?filters=[]',         
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '<button class="btn"><i class="fa fa-file-excel-o" ></i>  Exporter Excel</button>',
                "titleAttr": 'excel',
                'title':'',
                "action": newexportaction
            },
        ],
        columnDefs: { className: 'text-left', targets: '_all' },
        columns: [
            {
                data: 'nom',
            },
            {
                data: 'province',
            },
            {
                data: 'creation',
            },
            {
                data: 'date_creation',
            }

        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",

        }
    });


    guichet_creation_modal_charges_guichets_table = $('#guichet_creation_modal_charges_guichets_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: true,
        scrollX: false,
        ajax: assetBaseUrl + 'centre_donnees/charges_guichets_datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
        ],
        columnDefs: { className: 'text-center', targets: '_all' },
        columns: [    
            {
                data: 'email',
            },       
            {
                data: 'nom',
            },
            {
                data: 'prenom',
            },
            {
                data: 'guichet'
            }

        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",

        }
    });

});



$("body").on('click', '.guichet_a', function () {
    guichet_creation_modal_charges_guichets_table.ajax.reload();
    var item_id = $(this).attr('item_id');
    $("#store_guichet_form [name='id']").val(item_id);

    showLoading('HMR', 'Chargement');
    $.ajax({
        url: assetBaseUrl + "guichets/get/" + item_id,
        type: "GET",

        success: function (response) {
            closeLoading();

            if (response.creation == 1) {
                $("#store_guichet_form [name='creation']").prop('checked', true);
                $("#store_guichet_form [name='date_creation']").data('daterangepicker').setStartDate(response.date_creation_fromated);
                $("#store_guichet_form [name='date_creation']").removeAttr('disabled');
            }
            else {
                $("#store_guichet_form [name='creation']").prop('checked', false);
                $("#store_guichet_form [name='creation']").change();
            }



            $("#guichet_creation_modal").modal();
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });



});

$("#store_guichet_form [name='creation']").change(function () {
    if ($(this).prop('checked')) {
        $("#store_guichet_form [name='date_creation']").removeAttr('disabled');
        $("#store_guichet_form [name='date_creation']").data('daterangepicker').setStartDate(current_date);
    }
    else {
        $("#store_guichet_form [name='date_creation']").attr('disabled', 'disabled');
        $("#store_guichet_form [name='date_creation']").val('Aucune date');
    }
});


$("#store_guichet_form").submit(function (event) {
    event.preventDefault();
    var formData = new FormData(this);

    var ids = [];
    $("#guichet_creation_modal_charges_guichets_table .prestataire_cb:checked").each(function () {
        ids.push($(this).attr('item_id'));
    });
    formData.append('charges_guichets_ids', JSON.stringify(ids));
    $.ajax({
        url: assetBaseUrl + "guichets/store",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {

            $.toast({
                heading: "HMR",
                text: 'La modification a été enregistrée avec succès.',
                icon: "success",
                position: "bottom-right",
                hideAfter: 3000,
                stack: false,
            });
            $("#guichet_creation_modal").modal('hide');
            guichets_table.ajax.reload();
            charges_guichets_table.ajax.reload();


        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

