$(document).ready(function () {

    load_avis_favorables_stats('all');
});
function load_avis_favorables_stats(province) {
    $.ajax({
        url: assetBaseUrl + "dashboard/avis_favorables_chart?province=" + province,
        type: "GET",
        success: function (response) {
            load_avis_favorables_chart(response);
            closeLoading();
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}

function load_avis_favorables_chart(response) {

    var dom = document.getElementById('avis_favorables_chart');

    var myChart = echarts.init(dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });
    var app = {};

    var option;

    option = {
        title: {
            text: 'Avis favorables',
            left: 'left',
            textStyle: {
                color: '#000000',
                fontWeight: 'normal',
                fontSize: 14
            }
        },
        tooltip: {
            trigger: 'axis',
            axisPointer: {
                type: 'shadow'
            }
        },
        legend: {},
        grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            containLabel: true
        },
        xAxis: {
            type: 'value',
            boundaryGap: [0, 0.01]
        },
        yAxis: {
            type: 'category',
            data: response.data
        },
        series: [             
            {                
                type: 'bar',
                color:"#8DC007",
                data: response.values
            }
        ]
    };

    if (option && typeof option === 'object') {
        myChart.setOption(option);
    }

    window.addEventListener('resize', myChart.resize);

}