
$(document).ready(function () {

    load_prestataires_stats('all');
});


$(".prestataire_h_role").click(function () {
    showLoading('HMR','Chargement...');
    var role = $(this).attr('role');
    load_prestataires_stats(role);

    $('.prestataire_h_role').removeClass('active');
    $(this).addClass('active');

});
 

$("#prestataire_filter").change(function()
{
    showLoading('HMR', 'Chargement...');
    var role = $("#prestataire_filter").val();
    load_prestataires_stats(role);
 
});
function load_prestataires_stats(role ) {
    $.ajax({
        url: assetBaseUrl + "dashbaord/prestatraires_stat/?role="+role+"&province=all",
        type: "GET",
        success: function (response) {

            load_charts_prestataires_etat_engagement_chart(response);
            load_charts_prestataires_affectation_chart(response);

            $(".prestataires_nb_total.main_value").text(response.total);
            $(".prestataires_affectes.main_value").text(response.affectes);
            $(".prestataires_manifestations_interet.main_value").text(response.manifistation_interet);
            $(".prestataires_contractuels.main_value").text(response.contractuels);

            $(".prestataires_affectes.percentage1").text( (100*response.affectes/response.total).toFixed(2)+" %");
            $(".prestataires_manifestations_interet.percentage1").text( (100*response.manifistation_interet/response.total).toFixed(2)+" %");
            $(".prestataires_contractuels.percentage1").text( (100*response.contractuels/response.total).toFixed(2)+" %");


            closeLoading();
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}

function load_charts_prestataires_etat_engagement_chart(response) {
    console.log(response);
    var charts_prestataires_etat_engagement_dom = document.getElementById('charts_prestataires_etat_engagement');

    var charts_prestataires_etat_engagement_chart = echarts.init(charts_prestataires_etat_engagement_dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });

    var charts_prestataires_etat_engagement_option = {
        title: {
            text: 'Prestataires : état d\engagement',
            left: 'left',
            textStyle: {
                color: '#000000',
                fontWeight: 'normal',
                fontSize: 14
            }
        },
        tooltip: {
            trigger: 'item'
        },
        legend: {
            orient: 'horizontal',
            left: 'left',
            show:false,
        },
        grid: { containLabel: true },

        toolbox: {
            show: true,
            feature: {
                mark: { show: true },
                dataView: { show: false, readOnly: false },
                restore: { show: false },
                saveAsImage: { show: false }
            }
        },
        series: [
            {
                label: {
                    overflow: "break",
                    alignTo: 'edge',
                    minMargin: 5,
                    edgeDistance: 10,
                    lineHeight: 15,

                },
                labelLine: {
                    length: 15,
                    length2: 10,
                    maxSurfaceAngle: 80
                },

                type: 'pie',
                radius: [10, 50],
                center: ['50%', '50%'],
                itemStyle: {
                    borderRadius: 8
                },
                data: [
                    { value: response.manifistation_interet, name: 'Manifestations d\'Intérêt', itemStyle: { color: '#F08A38' } },
                    { value: response.contractuels, name: 'Contractuels', itemStyle: { color: '#93C47D' } },


                ]
            }
        ]
    };

    if (charts_prestataires_etat_engagement_option && typeof charts_prestataires_etat_engagement_option === 'object') {
        charts_prestataires_etat_engagement_chart.setOption(charts_prestataires_etat_engagement_option);
    }

    window.addEventListener('resize', charts_prestataires_etat_engagement_chart.resize);

}

function load_charts_prestataires_affectation_chart(response) {

    var charts_prestataires_affectation_dom = document.getElementById('charts_prestataires_affectation');

    var charts_prestataires_affectation_chart = echarts.init(charts_prestataires_affectation_dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });

    var charts_prestataires_affectation_option = {
        title: {
            text: 'Prestataires : affectations',
            left: 'left',
            textStyle: {
                color: '#000000',
                fontWeight: 'normal',
                fontSize: 14
            }
        },
        grid: {
            left: 0,
            right: 0,
            top: 0,
            bottom: 0
        },
        tooltip: {
            trigger: 'item'
        },
        legend: {
            orient: 'horizontal',
            left: 'left',
            show:false,
        },
        toolbox: {
            show: true,
            feature: {
                mark: { show: true },
                dataView: { show: false, readOnly: false },
                restore: { show: false },
                saveAsImage: { show: false }
            }
        },
        series: [
            {
                label: {
                    overflow: "break",
                    alignTo: 'edge',
                    minMargin: 5,
                    edgeDistance: 10,
                    lineHeight: 15,

                },
                tooltip: {
                    trigger: 'item'
                },
                labelLine: {
                    length: 15,
                    length2: 5,
                    maxSurfaceAngle: 80
                },

                type: 'pie',
                radius: [15, 50],
                center: ['50%', '50%'],
                itemStyle: {
                    borderRadius: 8
                },
                data: [
                    { value: response.affectes, name: 'Affectés', itemStyle: { color: '#0F91C8' } },
                    { value: response.non_affectes, name: 'Non affectés', itemStyle: { color: '#7D7D7D' } },
                ]
            }
        ]
    };

    if (charts_prestataires_affectation_option && typeof charts_prestataires_affectation_option === 'object') {
        charts_prestataires_affectation_chart.setOption(charts_prestataires_affectation_option);
    }

    window.addEventListener('resize', charts_prestataires_affectation_chart.resize);

}