$(document).ready(function () {

    load_demandes_stats('all');
});
function load_demandes_stats(province) {
    $.ajax({
        url: assetBaseUrl + "dashboard/demandes_chart?province=" + province,
        type: "GET",
        success: function (response) {


            load_demandes_chart(response);
            closeLoading();
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}

function load_demandes_chart(response) {

    var dom = document.getElementById('demandes_chart');
    var myChart = echarts.init(dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });
    var app = {};

    var option;

    option = {
        title: {
            text: 'Demandes saisies',
            left: 'left',
            textStyle: {
                color: '#000000',
                fontWeight: 'normal',
                fontSize: 14
            }
        },
        xAxis: {
            type: 'category',
            data: response.data
        },
        yAxis: {
            type: 'value'
        },
        tooltip: {
            show: true,
            trigger: "axis",
            triggerOn: "mousemove",
        },
        series: [
            {
                data: response.values,
                type: 'line'
            }
        ]
    };

    if (option && typeof option === 'object') {
        myChart.setOption(option);
    }

    window.addEventListener('resize', myChart.resize);

}

