$(document).ready(function () {
  $(".select2").select2();
  $(".select2nc").select2({
    minimumResultsForSearch: -1,
  });
  load_terrains_stats();
  load_terrains_liquidations("all");
});

$(".terrains_h_year").click(function () {
  showLoading("ETNB", "Chargement...");
  var year = $(this).attr("year");
  load_terrains_liquidations(year);

  $(".terrains_h_year").removeClass("active");
  $(this).addClass("active");
});

function load_suivi_administratif_stat(province) {
  $.ajax({
    url:
      assetBaseUrl + "dashbaord/suivi_administratif_stat?province=" + province,
    type: "GET",
    success: function (response) {
      console.log(response);
      $(".arretes_gubernatoriaux.main_value").text(
        response.arretes_gubernatoriaux
      );
      $(".guichets_prevus.main_value").text(response.guichets_prevus);
      $(".guichets_crees.main_value").text(response.guichets_crees);
      $(".commissions_instruction.main_value").text(
        response.commissions_instruction
      );

      $(".guichets_crees.percentage_1").text(
        (
          100 *
          (response.guichets_prevus == 0
            ? 0
            : response.guichets_crees / response.guichets_prevus)
        ).toFixed(2) + " %"
      );

      closeLoading();
    },
    error: function (xhr, status, error) {
      console.log(xhr.responseText);
    },
  });
}
function load_terrains_stats() {
  $.ajax({
    url: assetBaseUrl + "dashboard/index_terrains_stats",
    type: "GET",
    success: function (response) {
      console.log(response.total_terrains_surface_value);

      $(".total_terrains_value").text(
        response.total_terrains_value.toLocaleString("fr-FR")
      );
      $(".total_terrains_surface_value").text(
        response.total_terrains_surface_value.toLocaleString("fr-FR")
      );
      $(".total_surface_perimetre_value").text(
        response.total_surface_perimetre_value.toLocaleString("fr-FR")
      );
      $(".terrains_nus_percentage").text(
        response.terrains_nus_percentage.toLocaleString("fr-FR")
      );

      $(".terrains_taxables_count").text(
        response.terrains_taxables_count.toLocaleString("fr-FR")
      );
      $(".terrains_taxables_surface").text(
        response.terrains_taxables_surface.toLocaleString("fr-FR")
      );
      $(".terrains_taxables_percentage").text(
        response.terrains_taxables_percentage.toLocaleString("fr-FR")
      );

      $(".exonerations_temporaires_count").text(
        response.exonerations_temporaires_count.toLocaleString("fr-FR")
      );
      $(".exonerations_temporaires_surface").text(
        response.exonerations_temporaires_surface.toLocaleString("fr-FR")
      );
      $(".exonerations_temporaires_percentage").text(
        response.exonerations_temporaires_percentage.toLocaleString("fr-FR")
      );

      $(".terrains_non_taxables_count").text(
        response.terrains_non_taxables_count.toLocaleString("fr-FR")
      );
      $(".terrains_non_taxables_surface").text(
        response.terrains_non_taxables_surface.toLocaleString("fr-FR")
      );
      $(".terrains_non_taxables_percentage").text(
        response.terrains_non_taxables_percentage.toLocaleString("fr-FR")
      );

      $(".exonerations_permanentes_count").text(
        response.exonerations_permanentes_count.toLocaleString("fr-FR")
      );
      $(".exonerations_permanentes_surface").text(
        response.exonerations_permanentes_surface.toLocaleString("fr-FR")
      );
      $(".exonerations_permanentes_percentage").text(
        response.exonerations_permanentes_percentage.toLocaleString("fr-FR")
      );

      $(".total_declarations_value").text(
        response.total_declarations_value.toLocaleString("fr-FR")
      );
      $(".total_declarations_surface_value").text(
        response.total_declarations_surface_value.toLocaleString("fr-FR")
      );
      $(".declarations_surface_percentage").text(
        response.declarations_surface_percentage.toLocaleString("fr-FR")
      );

      $(".declarations_changement_proprietaires_count").text(
        response.declarations_changement_proprietaires_count.toLocaleString(
          "fr-FR"
        )
      );
      $(".declarations_changement_proprietaires_percentage").text(
        response.declarations_changement_proprietaires_percentage.toLocaleString(
          "fr-FR"
        )
      );

      //operations
      $(".exonerations_temporaires_construction_count").text(
        response.exonerations_temporaires_construction_count.toLocaleString(
          "fr-FR"
        )
      );
      $(".exonerations_temporaires_lotissement_count").text(
        response.exonerations_temporaires_lotissement_count.toLocaleString(
          "fr-FR"
        )
      );

      $(".zones_faiblement_count").text(
        response.zones_faiblement_count.toLocaleString("fr-FR")
      );
      $(".zones_faiblement_percentage").text(
        response.zones_faiblement_percentage.toLocaleString("fr-FR")
      );
      $(".zones_moyennement_count").text(
        response.zones_moyennement_count.toLocaleString("fr-FR")
      );
      $(".zones_moyennement_percentage").text(
        response.zones_moyennement_percentage.toLocaleString("fr-FR")
      );
      $(".zones_bien_count").text(
        response.zones_bien_count.toLocaleString("fr-FR")
      );
      $(".zones_bien_percentage").text(
        response.zones_bien_percentage.toLocaleString("fr-FR")
      );

      load_terrain_types_chart(response);
      load_declarations_chart(response);
      closeLoading();
    },
    error: function (xhr, status, error) {
      console.log(xhr.responseText);
    },
  });
}

function load_terrains_liquidations(year) {
  $.ajax({
    url: assetBaseUrl + "dashboard/index_terrains_liquidations?year=" + year,
    type: "GET",
    success: function (response) {
      const total = Number(response.total_liquidation_value) || 0;
      const withPaid = Number(response.number_terrain_liquidation_value) || 0;
      const withoutPaid =
        Number(response.number_terrain_liquidation_reste) || 0;
      const percent = Number(response.number_terrain_liquidation_percent) || 0;

      $(".total_recette_value").text(
        total.toLocaleString("fr-FR", {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
        }) + " DH"
      );
      $(".number_terrain_liquidation_value").text(
        withPaid.toLocaleString("fr-FR")
      );
      $(".number_terrain_liquidation_reste").text(
        withoutPaid.toLocaleString("fr-FR")
      );
      $(".number_terrain_liquidation_percent").text(
        percent.toLocaleString("fr-FR", { minimumFractionDigits: 2 }) + " %"
      );

      closeLoading();
    },
    error: function (xhr) {
      console.log(xhr.responseText);
    },
  });
}

function load_terrain_types_chart() {
  $.ajax({
    url: assetBaseUrl + "dashboard/terrain_types_chart",
    type: "GET",
    success: function (response) {
      var dom = document.getElementById("terrain_types_chart");

      // Check if element exists
      if (!dom) {
        console.error('Element with ID "terrain_types_chart" not found');
        return;
      }

      var myChart = echarts.init(dom, null, {
        renderer: "canvas",
        useDirtyRect: false,
      });
      var app = {};

      var option;

      option = {
        title: {
          text: "Types de Terrains",
          left: "center",
          textStyle: {
            color: "#000000",
            fontWeight: "normal",
            fontSize: 16,
          },
        },
        tooltip: {
          trigger: "item",
          formatter: "{a} <br/>{b}: {c} ({d}%)",
        },
        legend: {
          orient: "vertical",
          left: "right",
          data: response.data,
        },
        series: [
          {
            name: "Types de Terrains",
            type: "pie",
            radius: "50%",
            center: ["50%", "60%"],
            data: response.data.map((item, index) => ({
              value: response.values[index],
              name: item,
            })),
            emphasis: {
              itemStyle: {
                shadowBlur: 10,
                shadowOffsetX: 0,
                shadowColor: "rgba(0, 0, 0, 0.5)",
              },
            },
            itemStyle: {
              borderRadius: 8,
              borderColor: "#fff",
              borderWidth: 2,
            },
          },
        ],
      };

      if (option && typeof option === "object") {
        myChart.setOption(option);
      }

      window.addEventListener("resize", myChart.resize);
    },
    error: function (xhr, status, error) {
      console.log(xhr.responseText);
    },
  });
}

function load_declarations_chart() {
  $.ajax({
    url: assetBaseUrl + "dashboard/declarations_chart",
    type: "GET",
    success: function (response) {
      var dom = document.getElementById("declarations_chart");
      var myChart = echarts.init(dom, null, {
        renderer: "canvas",
        useDirtyRect: false,
      });
      var app = {};
      var option;

      option = {
        title: {
          text: "Déclarations " + new Date().getFullYear(),
          left: "left",
          textStyle: {
            color: "#000000",
            fontWeight: "normal",
            fontSize: 14,
          },
        },
        xAxis: {
          type: "category",
          data: response.data,
        },
        yAxis: {
          type: "value",
        },
        tooltip: {
          show: true,
          trigger: "axis",
          triggerOn: "mousemove",
          formatter: function (params) {
            return (
              params[0].name + "<br/>" + "Déclarations: " + params[0].value
            );
          },
        },
        series: [
          {
            itemStyle: {
              normal: {
                color: "#00b894", // Using your green color
              },
            },
            data: response.values,
            type: "line",
            smooth: true,
            symbol: "circle",
            symbolSize: 6,
          },
        ],
        dataZoom: [
          {
            startValue: response.data[0],
          },
          {
            type: "inside",
          },
        ],
        grid: {
          left: "3%",
          right: "4%",
          bottom: "10%",
          containLabel: true,
        },
      };

      if (option && typeof option === "object") {
        myChart.setOption(option);
      }

      window.addEventListener("resize", myChart.resize);
    },
    error: function (xhr, status, error) {
      console.log("Error loading declarations chart:", xhr.responseText);
    },
  });
}
