

function load_autorisations_chart2(province) {

    $.ajax({
        url: assetBaseUrl + "dashboard/autorisations_chart?province=" + province,
        type: "GET",
        success: function (response) {

            var dom = document.getElementById('autorisations_chart2');
            var myChart = echarts.init(dom, null, {
                renderer: 'canvas',
                useDirtyRect: false
            });
            var app = {};

            var option;

            option = {
                title: {
                    text: 'Autorisations de construire',
                    left: 'left',
                    textStyle: {
                        color: '#000000',
                        fontWeight: 'normal',
                        fontSize: 14
                    }
                },
                xAxis: {
                    type: 'category',
                    data: response.data
                },
                yAxis: {
                    type: 'value'
                },
                tooltip: {
                    show: true,
                    trigger: "axis",
                    triggerOn: "mousemove",
                },
                series: [
                    {
                        itemStyle: { normal: { color: 'green' } },
                        data: response.values,
                        type: 'line'
                    }
                ],
                dataZoom: [
                    {
                        startValue: '2014-06-01'
                    },
                    {
                        type: 'inside'
                    }
                ],
            };

            if (option && typeof option === 'object') {
                myChart.setOption(option);
            }

            window.addEventListener('resize', myChart.resize);

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });



}



function load_demandes_chart2(province) {

    $.ajax({
        url: assetBaseUrl + "dashboard/demandes_chart?province=" + province,
        type: "GET",
        success: function (response) {
            var dom = document.getElementById('demandes_chart2');
            var myChart = echarts.init(dom, null, {
                renderer: 'canvas',
                useDirtyRect: false
            });
            var app = {};

            var option;

            option = {
                title: {
                    text: 'Demandes saisies',
                    left: 'left',
                    textStyle: {
                        color: '#000000',
                        fontWeight: 'normal',
                        fontSize: 14
                    }
                },
                xAxis: {
                    type: 'category',
                    data: response.data
                },
                yAxis: {
                    type: 'value'
                },
                tooltip: {
                    show: true,
                    trigger: "axis",
                    triggerOn: "mousemove",
                },
                series: [
                    {
                        data: response.values,
                        type: 'line'
                    }
                ],
                dataZoom: [
                    {
                        startValue: '2014-06-01'
                    },
                    {
                        type: 'inside'
                    }
                ],

            };

            if (option && typeof option === 'object') {
                myChart.setOption(option);
            }

            window.addEventListener('resize', myChart.resize);

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });



}

function load_demandes_chart(response) {

    var dom = document.getElementById('demandes_chart');

    if (dom == null) {
        return;
    }
    var myChart = echarts.init(dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });
    var app = {};

    var option;

    option = {
        title: {
            text: 'Demandes validées',
            left: 'center'
        },
        tooltip: {
            trigger: 'item'
        },
        legend: {
            orient: 'vertical',
            left: 'left'
        },
        series: [
            {
                name: 'Access From',
                type: 'pie',
                radius: '50%',
                data: [
                    { value: response.rehabilitation_main_value, name: 'Confortement' },
                    { value: response.reconstruction_140_main_value, name: 'Démolition totale' },
                    { value: response.reconstruction_80_main_value, name: 'Démolition partielle' },
                    { value: response.non_identifiees_main_value, name: 'Non identifiées' },

                ],
                emphasis: {
                    itemStyle: {
                        shadowBlur: 10,
                        shadowOffsetX: 0,
                        shadowColor: 'rgba(0, 0, 0, 0.5)'
                    }
                }
            }
        ]
    };

    if (option && typeof option === 'object') {
        myChart.setOption(option);
    }

    window.addEventListener('resize', myChart.resize);

}

function load_autorisations_chart(response) {
    var dom = document.getElementById('autorisations_chart');
    if (dom == null)
        return;
    var myChart = echarts.init(dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });
    var app = {};

    var option;

    option = {
        title: {
            text: 'Autorisations de construire',
            left: 'center'
        },
        legend: {
            orient: 'vertical',
            left: 'left'
        },
        tooltip: {},
        dataset: {
            source: [
                ['product', 'Total', 'Autorisées'],
                ['Confortement', response.autorisations_total_main_value, response.autorisations_nv_rehabilitation_main_value],
                ['Démolition totale', response.reconstruction_140_main_value, response.autorisations_nv_reconstruction_140_main_value],
                ['Démolition partielle', response.reconstruction_80_main_value, response.autorisations_nv_reconstruction_80_main_value],

            ]
        },
        xAxis: { type: 'category' },
        yAxis: {},
        series: [
            {
                type: 'bar',
                label: {
                    show: true,
                    position: 'top'
                },
            },
            {
                type: 'bar',
                label: {
                    show: true,
                    position: 'top'
                },
            }]
    };

    if (option && typeof option === 'object') {
        myChart.setOption(option);
    }

    window.addEventListener('resize', myChart.resize);
}


function load_ouvertures_chantiers_chart_chart(response) {
    var dom = document.getElementById('ouvertures_chantiers_chart');

    var myChart = echarts.init(dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });
    var app = {};

    var option;

    option = {
        title: {
            text: ' Ouvertures de chantier',
            left: 'center'
        },
        legend: {
            orient: 'vertical',
            left: 'left'
        },
        tooltip: {},
        dataset: {
            source: [
                ['product', 'Total', 'Ouverture de chantier'],
                ['Démolition totale', response.autorisations_reconstruction_140_main_value, response.ouverture_chantier_reconstruction_140_main_value],
                ['Démolition partielle', response.autorisations_reconstruction_80_main_value, response.ouverture_chantier_reconstruction_80_main_value],

            ]
        },
        xAxis: { type: 'category' },
        yAxis: {},
        // Declare several bar series, each will be mapped
        // to a column of dataset.source by default.
        series: [
            {
                type: 'bar',
                label: {
                    show: true,
                    position: 'top'
                },
            },
            {
                type: 'bar',
                label: {
                    show: true,
                    position: 'top'
                },
            }
        ]
    };

    if (option && typeof option === 'object') {
        myChart.setOption(option);
    }

    window.addEventListener('resize', myChart.resize);
}


function load_af_chart(response) {
    var dom = document.getElementById('af_chart');

    var myChart = echarts.init(dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });
    var app = {};

    var option;

    option = {
        xAxis: {
            type: 'category',
            data: ['Tranche 1', 'Tranche 2', 'Tranche 3', 'Tranche 4']
        },
        yAxis: {
            type: 'value'
        },
        series: [
            {
                data: [{
                    value: response.af1_total_main_value,
                    itemStyle: {
                        color: '#2D9E23'
                    }
                }, {
                    value: response.af2_total_main_value,
                    itemStyle: {
                        color: '#35BB50'
                    }
                }, {
                    value: response.af3_total_main_value,
                    itemStyle: {
                        color: '#6CD582'
                    }
                }, {
                    value: response.af4_total_main_value,
                    itemStyle: {
                        color: '#AEE8BA'
                    }
                }],
                type: 'bar'
            }
        ]
    };

    if (option && typeof option === 'object') {
        myChart.setOption(option);
    }

    window.addEventListener('resize', myChart.resize);
}