$(document).ready(function () {

    load_overtures_chantier_stats('all');
});
function load_overtures_chantier_stats(province) {
    $.ajax({
        url: assetBaseUrl + "dashboard/overtures_chantier_chart?province=" + province,
        type: "GET",
        success: function (response) {


            //load_overtures_chantier_chart(response);
            closeLoading();
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}

function load_overtures_chantier_chart(response) {
 
    var dom = document.getElementById('overtures_chantier_chart');
    var myChart = echarts.init(dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });
    var app = {};

    var option;

    // prettier-ignore
    let dataAxis =response.data;
    // prettier-ignore
    let data = response.values;
    let yMax = 500;
    let dataShadow = [];
    for (let i = 0; i < data.length; i++) {
        dataShadow.push(yMax);
    }

    var labelOption = {
        normal: {
            show: true,
            position: 'insideBottom',
            rotate: 90,
            formatter: '{b} - {c}',
            textStyle: {
                align: 'left',
                verticalAlign: 'middle',
                color: '#484848',
                fontFamily: 'Roboto',

            }
        }
    };

    option = {
        title: {
            text: 'Ouvertures de chantier',
            left: 'left',
            textStyle: {
                color: '#000000',
                fontWeight: 'normal',
                fontSize: 14
            }
        },
        xAxis: {
            data: dataAxis,
            axisLabel: {
                inside: false,
                color: '#fff'
            },
            axisTick: {
                show: false
            },
            axisLine: {
                show: false
            },
            z: 10
        },
        yAxis: {
            axisLine: {
                show: false
            },
            axisTick: {
                show: false
            },
            axisLabel: {
                color: '#999'
            }
        },
        dataZoom: [
            {
                type: 'inside'
            }
        ],
        series: [
            {
                label: labelOption,
                type: 'bar',
                showBackground: true,
                itemStyle: {
                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
                        { offset: 0, color: '#83bff6' },
                        { offset: 0.5, color: '#188df0' },
                        { offset: 1, color: '#188df0' }
                    ])
                },
                emphasis: {
                    itemStyle: {
                        color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
                            { offset: 0, color: '#2378f7' },
                            { offset: 0.7, color: '#2378f7' },
                            { offset: 1, color: '#83bff6' }
                        ])
                    }
                },
                data: data
            }
        ]
    };
    // Enable data zoom when user click bar.
    const zoomSize = 6;
    myChart.on('click', function (params) {
        console.log(dataAxis[Math.max(params.dataIndex - zoomSize / 2, 0)]);
        myChart.dispatchAction({
            type: 'dataZoom',
            startValue: dataAxis[Math.max(params.dataIndex - zoomSize / 2, 0)],
            endValue:
                dataAxis[Math.min(params.dataIndex + zoomSize / 2, data.length - 1)]
        });
    });

    if (option && typeof option === 'object') {
        myChart.setOption(option);
    }

    window.addEventListener('resize', myChart.resize);

}