
function load_prestataire_avancement_chart() {
 
    var dom = document.getElementById('etats_reconstruction_chart');
    var myChart = echarts.init(dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });
    var app = {};

    var option;

    option = {
        title: {
            text: '',
            subtext: '',
            left: 'center'
        },
        tooltip: {
            trigger: 'item'
        },
        legend: {
            orient: 'vertical',
            left: 'left'
        },
        series: [
            {
                name: 'Access From',
                type: 'pie',
                radius: '50%',
                data: [
                    { value: parseInt($(".prestataire_pv_ouverture_chantier.main_value").text()), name: 'Ouverture de chantier' },
                    { value: parseInt($(".prestataire_travaux_gros_oeuvres.main_value").text()), name: "Récpetion des fondations" },
                    { value: parseInt($(".prestataire_finitions.main_value").text()), name: "Finitions" },
                    { value: parseInt($(".prestataire_permis_habiter.main_value").text()), name: "Permis d'habiter" }
                ],
                emphasis: {
                    itemStyle: {
                        shadowBlur: 10,
                        shadowOffsetX: 0,
                        shadowColor: 'rgba(0, 0, 0, 0.5)'
                    }
                }
            }
        ]
    };

    if (option && typeof option === 'object') {
        myChart.setOption(option);
    }

    window.addEventListener('resize', myChart.resize);

}