$(document).ready(function () {

    load_prestataire_avis_favorables_stats();
});
function load_prestataire_avis_favorables_stats() {
    $.ajax({
        url: assetBaseUrl + "dashboard/prestataires_avis_favorables_chart" ,
        type: "GET",
        success: function (response) {
            load_prestataire_avis_favorables_chart(response);
            closeLoading();
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}

function load_prestataire_avis_favorables_chart(response) {

    var dom = document.getElementById('prestataire_avis_favorables_chart');

    var myChart = echarts.init(dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });
    var app = {};

    var option;

    option = {
        title: {
            text: 'Avis favorables'
        },
        tooltip: {
            trigger: 'axis',
            axisPointer: {
                type: 'shadow'
            }
        },
        legend: {},
        grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            containLabel: true
        },
        xAxis: {
            type: 'category',
       
            data: response.data
        },
        yAxis: {
            type: 'value',
            allowDecimals: false, 
            minInterval: 1
        },
        series: [             
            {                
                type: 'bar',
                color:"#8DC007",
                data: response.values
            }
        ]
    };

    if (option && typeof option === 'object') {
        myChart.setOption(option);
    }

    window.addEventListener('resize', myChart.resize);

}