$(document).ready(function () {

    load_prestataires_demandes_stats();
});
function load_prestataires_demandes_stats(province) {
    $.ajax({
        url: assetBaseUrl + "dashboard/prestataires_demandes_chart?t=" + Date.now(),
        type: "GET",
        success: function (response) {


            load_prestataire_demandes_chart(response);
            closeLoading();
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}

function load_prestataire_demandes_chart(response) {

    var dom = document.getElementById('prestataires_demandes_chart');
    var myChart = echarts.init(dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });
    var app = {};

    var option;

    option = {
        title: {
            text: 'Demandes'
        },
        xAxis: {
            type: 'category',
            data: response.data
        },
        yAxis: {
            type: 'value',
            allowDecimals: false, 
            minInterval: 1
        },
        legend: {
            orient: 'horizontal',
            left: 'center',
            top: 30,
        },
        series: [
            {
                name: "Demandes",
                data: response.values,
                type: 'line'
            },
            {
                name: "Demandes saisies",
                data: response.user_values,
                color: 'red',
                type: 'line'
            }
        ]
    };

    if (option && typeof option === 'object') {
        myChart.setOption(option);
    }

    window.addEventListener('resize', myChart.resize);

}

