var fichiers_echange_table = undefined;

$(document).ready(function () {


    fichiers_echange_table = $('#fichiers_echange_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: true,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'echangemi/fihciers_echange_datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '<button class="btn"><i class="fa fa-file-excel-o" ></i>  Exporter Excel</button>',
                "titleAttr": 'excel',
                'title': '',
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3] }
        ],
        columns: [
            {
                data: 'date',
            },
            {
                data: 'progression',
            },
            {
                data: 'excel_file',
            },
            {
                data: 'txt_file',
            },
            {
                data: 'ea_excel_file',
            },
            {
                data: 'ea_txt_file',
            },
            {
                data: 'public',
            },
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }


    });

    // suivi_table.on('draw', function () {
    //     $(".select2").select2();
    //     $(".select2nc").select2({
    //         minimumResultsForSearch: -1
    //     });
    // });   


    // $('#filter_date').daterangepicker({
    //     startDate: (new Date(new Date().getFullYear(), 0, 1)).toLocaleDateString('fr-FR'),
    //     endDate: '31/12/2023',
    //     applyButtonClasses: 'btn-success',
    //     cancelButtonClasses: 'btn-danger',
    //     locale: {
    //         format: 'DD/MM/YYYY',
    //         applyLabel: "Accepter",
    //         cancelLabel: "Annuler",
    //     }
    // });


});

$('.generate_fichier_echange').click(function () {
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous certain(e) de vouloir générer un nouveau fichier d'échange ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $.ajax({
                url: assetBaseUrl + "export_new_fichier_echange",
                type: "GET",
                dataType: "json",
                success: function (response) {
                    fichiers_echange_table.ajax.reload();
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });
        }
    });
});

$('body').on('click', '.download_fichier_echange_xlsx', function () {
    var id = $(this).attr('echange_id');
    downloadFile(assetBaseUrl + 'echangemi/download_xlsx/' + id);
});

$('body').on('click', '.download_fichier_echange_txt', function () {
    var id = $(this).attr('echange_id');
    downloadFile(assetBaseUrl + 'echangemi/download_txt/' + id);
});


$('body').on('click', '.download_fichier_echange_xlsx_ea', function () {
    var id = $(this).attr('echange_id');
    downloadFile(assetBaseUrl + 'echangemi/download_xlsx_ea/' + id);
});

$('body').on('click', '.download_fichier_echange_txt_ea', function () {
    var id = $(this).attr('echange_id');
    downloadFile(assetBaseUrl + 'echangemi/download_txt_ea/' + id);
});

$('body').on('click', '.fichier_echange_a', function () {
    var id = $(this).attr('id');
    $("#fichier_echange_modal").modal('show');
    $('.echange_mi_recap_input').val("...");
    $.ajax({
        url: assetBaseUrl + "echangemi/get_fichier_echange/" + id,
        type: "GET",
        success: function (response) {
            $('.echange_mi_recap_input[column="nb_total"]').val(response.nb_total.toLocaleString('fr-FR'));
            $('.echange_mi_recap_input[column="recons_count"]').val(response.recons_count.toLocaleString('fr-FR'));
            $('.echange_mi_recap_input[column="rehab_count"]').val(response.rehab_count.toLocaleString('fr-FR'));
            $('.echange_mi_recap_input[column="ni_count"]').val(response.ni_count.toLocaleString('fr-FR'));
            $('.echange_mi_recap_input[column="af_1_count"]').val(response.af_1_count.toLocaleString('fr-FR'));
            $('.echange_mi_recap_input[column="af_2_count"]').val(response.af_2_count.toLocaleString('fr-FR'));
            $('.echange_mi_recap_input[column="af_3_count"]').val(response.af_3_count.toLocaleString('fr-FR'));
            $('.echange_mi_recap_input[column="af_4_count"]').val(response.af_4_count.toLocaleString('fr-FR'));
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });

    
});