
$("#provinces_filter").change(function () {
    refresh_situation_filters('province');
});
$("#cercles_filter").change(function () {
    refresh_situation_filters('cercle');
});
$("#communes_filter").change(function () {
    refresh_situation_filters('commune');
});
$("#douars_filter").change(function () {
    refresh_situation_filters('douar');
});

function fill_situation_filter_cercle(province_id) {
    $("#cercles_filter").empty();
    $("#cercles_filter").append(new Option('Indifferent', 'all'));
    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                $("#cercles_filter").append(new Option(cercle.nom, cercle.id));
            }
        }
        else {
            $("#cercles_filter").append(new Option(cercle.nom, cercle.id));
        }
    });
}

function fill_situation_filter_commune(province_id, cercle_id) {
    $("#communes_filter").empty();
    $("#communes_filter").append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });

    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        $("#communes_filter").append(new Option(commune.nom, commune.id));
                    }
                }
                else {
                    $("#communes_filter").append(new Option(commune.nom, commune.id));
                }
            }
        });
    });

}


function fill_situation_filter_douar(province_id, cercle_id, commune_id) {
    $("#douars_filter").empty();
    $("#douars_filter").append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });

    var filtred_communes = [];
    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        filtred_communes.push(commune);
                    }
                }
                else {
                    filtred_communes.push(commune);
                }
            }
        });
    });

    filtred_communes.forEach(commune => {
        douars.forEach(douar => {
            if (douar.commune_id == commune.id) {
                if (commune_id != 'all') {
                    if (commune.id == commune_id) {
                        $("#douars_filter").append(new Option(douar.nom, douar.id));
                    }
                }
                else {
                    $("#douars_filter").append(new Option(douar.nom, douar.id));
                }
            }
        });
    });

}
function refresh_situation_filters(trigger_source) {
    if (trigger_source == 'province') {
        fill_situation_filter_cercle($("#provinces_filter").val(), 'all');
        fill_situation_filter_commune($("#provinces_filter").val(), 'all');
        fill_situation_filter_douar($("#provinces_filter").val(), 'all', 'all');
    }
    if (trigger_source == 'cercle') {
        var province_id = undefined;

        if ($("#cercles_filter").val() == 'all') {
            refresh_situation_filters('province');
            return;
        }

        cercles.forEach(cercle => {
            if (cercle.id == $("#cercles_filter").val()) {
                province_id = cercle.province_id;
            }
        });

        $("#provinces_filter").val(province_id);
        $('#provinces_filter').trigger('change.select2');

        fill_situation_filter_commune(province_id, $("#cercles_filter").val());
        fill_situation_filter_douar(province_id, $("#cercles_filter").val(), 'all');
    }

    if (trigger_source == 'commune') {
        var province_id = undefined;
        var cercle_id = undefined;

        if ($("#communes_filter").val() == 'all') {
            refresh_situation_filters('cercle');
            return;
        }

        communes.forEach(commune => {
            if (commune.id == $("#communes_filter").val()) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#provinces_filter").val(province_id);
        $('#provinces_filter').trigger('change.select2');

        $("#cercles_filter").val(cercle_id);
        $('#cercles_filter').trigger('change.select2');

        fill_situation_filter_douar(province_id, $("#cercles_filter").val(), $("#communes_filter").val(), 'all');
    }

    if (trigger_source == 'douar') {
        var province_id = undefined;
        var cercle_id = undefined;
        var commune_id = undefined;

        if ($("#douars_filter").val() == 'all') {
            refresh_situation_filters('commune');
            return;
        }

        douars.forEach(douar => {
            if (douar.id == $("#douars_filter").val()) {
                commune_id = douar.commune_id;
            }
        });

        communes.forEach(commune => {
            if (commune.id == commune_id) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#provinces_filter").val(province_id);
        $('#provinces_filter').trigger('change.select2');

        $("#cercles_filter").val(cercle_id);
        $('#cercles_filter').trigger('change.select2');

        $("#communes_filter").val(commune_id);
        $('#communes_filter').trigger('change.select2');


    }
}

 


$("#v_tab_filters_btn").click(function () {
    $("#v_tab_list_btn").removeClass('active');
    $("#v_tab_filters_btn").addClass('active');

    $("#terrains_filters_div").addClass('active');
    $("#terrains_result_div").removeClass('active');
});

$("#v_tab_list_btn").click(function () {
    $("#v_tab_filters_btn").removeClass('active');
    $("#v_tab_list_btn").addClass('active');

    $("#terrains_filters_div").removeClass('active');
    $("#terrains_result_div").addClass('active');
});



$("#filters_tab_apply").click(function () {
    console.log('filter')
    filter_terrains_table();

    $("#v_tab_list_btn").click();
    $("#v_tab_filters_btn").removeClass('active');
    $("#v_tab_list_btn").addClass('active');

    $("#terrains_filters_div").removeClass('active');
    $("#terrains_result_div").addClass('active');
});




function reset_filters() {
    $("#type_filter").val('all').change();
    $("#zones_filter").val('all').change();
    $("#declaration_filter").val('all').change();
    $("#liquidation_filter").val('all').change();

    $("#filters_tab_apply").click();
}

$("#filters_tab_rest").click(function () {

    reset_filters();
})


function filter_terrains_table(start = 0, load_geometries = true) {
    var filters = [];

    $(".dt_filter").each(function () {
        var column = $(this).attr('column');
        var table = $(this).attr('table');
        var value = $(this).val();
        if (value != 'all') {
            filters.push({ column: column, table: table, value: value });
        }
    });
 
    // var column = "dossiers.created_at";
    // var table = "";
    // var value = daterange;
    // filters.push({ column: column, table: table, value: value });

    // if ($("#permis_habiter_filter").prop('checked')) {
    //     var column = "dossiers.permis_habiter";
    //     var table = "";
    //     var value = 1;
    //     filters.push({ column: column, table: table, value: value });
    // }

    terrains_table.ajax.url(assetBaseUrl + "geoportail/terrains_datatable?offset=" + start + "&limit=30&filters=" + JSON.stringify(filters)).load();
    if (load_geometries) {
        loadDossiers(filters);
    }

}

$("#couche_terrains_cb").change(function()
{
    initData();
});


$("#couche_zones_pa_cb").change(function()
{
    initData();
});


$("#couche_zoning_cb").change(function()
{
    initData();
});