var map = undefined;
var map_fullscreen = false;
const dossier_popup = new maplibregl.Popup({
    closeButton: true,
    closeOnClick: false
});

const zone_pa_popup = new maplibregl.Popup({
    closeButton: false,
    closeOnClick: false
});

var terrains_list = undefined;
var zones_pa_list = undefined;

$(document).ready(function () {
    map = new maplibregl.Map({
        container: 'map',
        style: {
            version: 8,
            sources: {
                osm: {
                    type: 'raster',
                    tiles: ['https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}'],
                    tileSize: 256,
                    attribution: '',
                    maxzoom: 22
                },
            },

            layers: [{
                id: 'osm',
                type: 'raster',
                source: 'osm'
            },],

            "glyphs": "https://fonts.openmaptiles.org/{fontstack}/{range}.pbf",
        },

        attributionControl: false,
        center: [-5.3288743638643155, 35.6932342419659],
        zoom: 13.25,
        pitch: 0,
        antialias: false,


    });

    map.on('load', function () {

        initData();
    });
    var intervalId = window.setInterval(function () {
        rSize();
    }, 100);


});


function cleanMap() {

    map.getStyle().layers.forEach(layer => {
        if (layer.type != 'raster') {
            map.removeLayer(layer.id);
        }

    });
    Object.keys(map.getStyle().sources).forEach(elem => {
        if (map.getStyle().sources[elem].type != 'raster') {
            map.removeSource(elem);
        }
    });

    map.listImages().forEach(image => {
        map.removeImage(image);
    });


    map.setTerrain();
}

function initData() {
    cleanMap();



    if ($("#vuew_3d_cb").prop('checked')) {
        //initTerrain3d();
    }



    loadZones();
    loadZonesPA();

}

function loadZonesPA(callback) {



    if (!$("#couche_zones_pa_cb").prop('checked')) {
        filter_terrains_table();
        return;
    }
    $.ajax({
        type: "GET",
        dataType: 'json',
        url: assetBaseUrl + "zonespa/getZonesPA",

        success: function (res) {

            var zones_features = [];
            res.zonespa.forEach(element => {
                var geometry = typeof element.geojson === 'string' ? JSON.parse(element.geojson) : element.geojson;


                var feature = {
                    type: "Feature",
                    properties: {
                        id: element.id,
                        fill: element.color
                    },
                    geometry: geometry
                };

                zones_features.push(feature);
            });
            zones_pa_list = res.zonespa;


            zones_pa_geojson = {
                "type": "FeatureCollection",
                'features': zones_features,
            };

            map.addSource('zones_pa', {
                type: 'geojson',
                data: zones_pa_geojson
            });

            map.addLayer({
                'id': 'zones_pa_fill',
                'type': 'fill',
                'source': 'zones_pa',
                'paint': {
                    'fill-color': ['get', 'fill'],
                    'fill-opacity': 0.35,
                }
            });



            map.addLayer({
                'id': 'zones_pa_line',
                'type': 'line',
                'source': 'zones_pa',
                'paint': {
                    'line-color': ['get', 'fill'],
                    'line-width': 1,
                    'line-dasharray': [2, 4]
                }

            });



            // Call the callback after zones are loaded
            if (callback && typeof callback === 'function') {
                callback();
            }

            filter_terrains_table();
        },
        error: function (xhr, status, error) {
            console.error('Error loading zones:', error);
            // Still call callback even on error to prevent hanging
            if (callback && typeof callback === 'function') {
                callback();
            }
        }
    });
}

function getColorFromType(type) {


    if (type == "Terrains taxables") {
        return "#5470c6";
    }
    if (type == "Terrains non taxables") {
        return "#73c0de";
    }
    if (type == "Exonerations temporaires") {
        return "#ef7575";
    }
    if (type == "Exonerations permanentes") {
        return "#fac858";
    }
    if (type == "Terrains supprimes") {
        return "#91cc75";
    }
}

// Function to calculate centroid of a polygon
function calculateCentroid(coords) {
    var latSum = 0, lngSum = 0, area = 0;

    for (var i = 0, len = coords.length - 1; i < len; i++) {
        var x1 = coords[i][0], y1 = coords[i][1];
        var x2 = coords[i + 1][0], y2 = coords[i + 1][1];

        var factor = (x1 * y2 - x2 * y1);
        lngSum += (x1 + x2) * factor;
        latSum += (y1 + y2) * factor;
        area += factor;
    }

    area = area / 2;
    var centroidLng = lngSum / (6 * area);
    var centroidLat = latSum / (6 * area);

    return [centroidLat, centroidLng];
}


function loadDossiers(filters = []) {

    if (!$("#couche_terrains_cb").prop('checked')) {
        return;
    }
    $.ajax({
        type: "GET",
        dataType: 'json',

        url: assetBaseUrl + "geoportail/getAllTerrains?filters=" + JSON.stringify(filters),

        success: function (res) {

            if (map.getLayer("dossiers_fill") != undefined) {
                map.removeLayer("dossiers_fill");
            }
            if (map.getLayer("terrains_symboles") != undefined) {
                map.removeLayer("terrains_symboles");
            }
            if (map.getLayer("dossiers_line") != undefined) {
                map.removeLayer("dossiers_line");
            }

            if (map.getSource("dossiers") != undefined) {
                map.removeSource("dossiers");
            }

            var dossiers_features = [];



            terrains_list = res.terrains;
            res.terrains.forEach(element => {


                var geometry = JSON.parse(element.geojson);

                var feature = {
                    type: "Feature",
                    properties: {
                        id: element.id,
                        type: element.type,
                        color: getColorFromType(element.type),
                        ref: element.ref,

                    },
                    geometry: geometry
                };

                dossiers_features.push(feature);

                $(".show_hide_layer:not(.disabled)").each(function () {


                });


            });





            dossiers_geojson = {
                "type": "FeatureCollection",
                'features': dossiers_features,
            };

            map.addSource('dossiers', {
                type: 'geojson',
                data: dossiers_geojson
            });

            map.addLayer({
                'id': 'dossiers_fill',
                'type': 'fill',
                'source': 'dossiers',
                'paint': {
                    'fill-color': ['get', 'color'],
                    'fill-opacity': 0.75,
                }
            });

            map.addLayer({
                'id': 'dossiers_line',
                'type': 'line',
                'source': 'dossiers',
                'paint': {
                    'line-color': '#000000',
                    'line-width': 2,
                }
            });

            map.addLayer({
                "id": "terrains_symboles",
                "type": "symbol",
                "source": "dossiers",
                "layout": {
                    "symbol-placement": "point",
                    "text-font": ["Metropolis Semi Bold"],
                    "text-field": '{ref}',
                    "text-offset": [0, 0],
                    "icon-overlap": "always",
                    "text-allow-overlap": false,
                    "text-size": 11

                },
                "paint": {
                    "text-color": "#cacacaff",
                    "text-halo-color": "black",
                    "text-halo-width": 1,
                    "text-halo-blur": 0
                }
            });


        }
    });
    zone_pa_popup.addTo(map);
    map.on('mouseenter', 'dossiers_fill', function (e) {
        this.getCanvas().style.cursor = 'pointer';

    });
    map.on('mouseleave', 'dossiers_fill', function (e) {
        this.getCanvas().style.cursor = '';

    });

    map.on('mousemove', 'zones_pa_fill', function (e) {
        this.getCanvas().style.cursor = 'pointer';
        const features = map.queryRenderedFeatures(e.point);
        var id = features[0].properties.id;
        zones_pa_list.forEach(zone => {
            if (zone.id == id) {
                var html = `<h5 style="border-bottom:1px gray dashed;font-size:16px">Zone : ${zone.nom}</h5>
                                <span style="font-size:15px">${zone.utilisation}</span>     
                             `;

                zone_pa_popup.setLngLat(e.lngLat).setHTML(html);
            }
        });


    });
    map.on('mouseleave', 'zones_pa_fill', function (e) {
        this.getCanvas().style.cursor = '';

        zone_pa_popup.setLngLat({ lat: 90, lng: 90 }).setHTML("");

    });


    map.on('click', 'dossiers_fill', function (e) {
        this.getCanvas().style.cursor = 'pointer';
        const features = map.queryRenderedFeatures(e.point);

        handleDossierMarkerClick(features[0].properties.id, e.lngLat);
    });
}

function handleDossierMarkerClick(id, coordinates) {


    terrains_list.forEach(terrain => {
        if (terrain.id == id) {
            let zonesText = "Aucune zone";
            if (terrain.zones && terrain.zones.length > 0) {
                zonesText = terrain.zones.map(zone => zone.nom).join(', ');
            }

            // Process affectations urbanistiques (zones_pa) - just get the names separated by commas
            let affectationsText = "Aucune affectation";
            if (terrain.zones_pa && terrain.zones_pa.length > 0) {
                affectationsText = terrain.zones_pa.map(affectation => affectation.nom).join(', ');
            }

            var declarationText = "";
            var liquidatiionText = "";
            var html = `
            <div style="width: 350px;"> 
            <h5 style="border-bottom:1px gray dashed;">Référence Foncière : ${terrain.ref}</h5>
             

           <div class="row" style="display: unset !important;">

               <div class="col-12 form-group label-floating">
                   <label class="input-group-text form-group-label" style="color:black;"><i class="fa-solid fa-ruler-combined mr-2"></i>Surface : <b style="color:#0053ae;margin-left:8px">${terrain.surface}</b> m²</label>
                    
               </div>
           </div>

            <div class="row" style="display: unset !important;">			
                <div class="col-12 form-group label-floating">   

                    <label class="input-group-text form-group-label" style="color:black;"><i class="fa-solid fa-clone mr-2"></i>Zoning : <b style="color:#0053ae;margin-left:8px">${zonesText}</b></label>

                </div>
                
           </div>

           <div class="row" style="display: unset !important;">
               <div class="col-12 form-group label-floating">     
                      <label class="input-group-text form-group-label" style="color:black;"><i class="fa-solid fa-draw-polygon mr-2"></i>Affectation urbanistique : <b style="color:#0053ae;margin-left:8px">${affectationsText}</b></label>
               </div>
           </div>

           <div class="row"  style="display: unset !important;">										
               <div class="col-12 form-group label-floating">
                    <label class="input-group-text form-group-label" style="color:black;"><i class="fa-solid fa-location-dot mr-2"></i>Adresse : <b style="color:#0053ae;margin-left:8px">${terrain.adresse}</b></label>
               </div>	
           </div>

            <div class="row" style="display: unset !important;">
               <div class="col-12 form-group label-floating">     
                      <label class="input-group-text form-group-label" style="color:black;"><i class="fa-solid fa-file-circle-check mr-2"></i>Déclaration : <b style="color:#0053ae;margin-left:8px">${terrain.declation_html}</b></label>
               </div>
           </div>
            <div class="row" style="display: unset !important;">
               <div class="col-12 form-group label-floating">     
                      <label class="input-group-text form-group-label" style="color:black;"><i class="fa-solid fa-coins mr-2"></i>Liquidation : <b style="color:#0053ae;margin-left:8px">${terrain.liquidation_html}</b></label>
               </div>
           </div>

           </br> 
           <div style="margin: auto;display: block;" class="btn btn-info more-info" onclick='var win = window.open("terrains/show/${terrain.id}", "_blank");' ><span><i class="fa-solid fa-circle-info mr-2"></i><b>Plus d\'informations</b></span></div>
            
           </div>`
                ;
            dossier_popup.setLngLat(coordinates).setHTML(html).addTo(map);
        }
    });

};

function rSize() {
    var side_panel_h = $(".side_panel").height();
    var dossiers_filter_h = $("#myTab").height();
    $("#dossiers_result_list").css('height', (side_panel_h - dossiers_filter_h - 40) + 'px');
};


$("#v_tab_filters_btn").click(function () {
    $("#v_tab_list_btn").removeClass('active');
    $("#v_tab_filters_btn").addClass('active');

    $("#dossiers_filters_div").addClass('active');
    $("#dossiers_result_div").removeClass('active');
});

$("#v_tab_list_btn").click(function () {
    $("#v_tab_filters_btn").removeClass('active');
    $("#v_tab_list_btn").addClass('active');

    $("#dossiers_filters_div").removeClass('active');
    $("#dossiers_result_div").addClass('active');
});


$("body").on('click', '.dossier_row', function () {

    var lat = parseFloat($(this).attr('lat'));
    var lng = parseFloat($(this).attr('lng'));
    var id = $(this).attr('item_id');

    if (lng == 0 || lat == 0)
        return;
    map.flyTo({
        center: [lng, lat],
        essential: true,
        zoom: 18
    });
    handleDossierMarkerClick(id, [lng, lat]);


});


$("#baselayer_google_streets").click(function () {

    $("#baselayer_google_streets").removeClass('disabled');
    $("#baselayer_google_sat").addClass('disabled');
    $("#baselayer_google_hybrid").addClass('disabled');
    $("#baselayer_none").addClass('disabled');

    map.setStyle({
        version: 8,
        sources: {
            osm: {
                type: 'raster',
                tiles: ['https://www.google.com/maps/vt?lyrs=m@189&gl=ma&x={x}&y={y}&z={z}'],
                tileSize: 256,
                attribution: '',
                maxzoom: 22
            },
        },
        layers: [{
            id: 'osm',
            type: 'raster',
            source: 'osm'
        },],
        "glyphs": "https://fonts.openmaptiles.org/{fontstack}/{range}.pbf",
    });
    initData();
});

$("#baselayer_google_sat").click(function () {

    $("#baselayer_google_streets").addClass('disabled');
    $("#baselayer_google_sat").removeClass('disabled');
    $("#baselayer_google_hybrid").addClass('disabled');
    $("#baselayer_none").addClass('disabled');

    map.setStyle({
        version: 8,
        sources: {
            osm: {
                type: 'raster',
                tiles: ['https://www.google.com/maps/vt?lyrs=s@189&gl=ma&x={x}&y={y}&z={z}'],
                tileSize: 256,
                attribution: '',
                maxzoom: 22
            },
        },
        layers: [{
            id: 'osm',
            type: 'raster',
            source: 'osm'
        },],
        "glyphs": "https://fonts.openmaptiles.org/{fontstack}/{range}.pbf",
    });
    initData();
});


$("#baselayer_google_hybrid").click(function () {

    $("#baselayer_google_streets").addClass('disabled');
    $("#baselayer_google_sat").addClass('disabled');
    $("#baselayer_google_hybrid").removeClass('disabled');
    $("#baselayer_none").addClass('disabled');

    map.setStyle({
        version: 8,
        sources: {
            osm: {
                type: 'raster',
                tiles: ['https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}'],
                tileSize: 256,
                attribution: '',
                maxzoom: 22
            },
        },
        layers: [{
            id: 'osm',
            type: 'raster',
            source: 'osm'
        },],
        "glyphs": "https://fonts.openmaptiles.org/{fontstack}/{range}.pbf",
    });
    initData();
});

$("#baselayer_none").click(function () {

    $("#baselayer_google_streets").addClass('disabled');
    $("#baselayer_google_sat").addClass('disabled');
    $("#baselayer_google_hybrid").addClass('disabled');
    $("#baselayer_none").removeClass('disabled');

     if (map.getLayer('osm')) {
        map.removeLayer('osm'); // remove layer first
    }
    if (map.getSource('osm')) {
        map.removeSource('osm'); // then remove the source
    }
});

$("#vue_3d").click(function () {

    $("#vue_2d").addClass('disabled');
    $("#vue_3d").removeClass('disabled');

    if (map.getSource('terrainSource')) {
        map.removeSource('terrainSource');
    }

    map.addSource('terrainSource', {
        'type': 'raster-dem',
        'url': 'https://api.maptiler.com/tiles/terrain-rgb-v2/tiles.json?key=zW43iuG1uAEGN0AUvT7O',
        'tileSize': 256,
    });
    map.setPitch(60);
    map.setTerrain({ 'source': 'terrainSource', 'exaggeration': 1 });
});


$("#vue_2d").click(function () {

    $("#vue_2d").removeClass('disabled');
    $("#vue_3d").addClass('disabled');
    map.setPitch(0);
    map.setTerrain();
});

$(".side-panel-toggle").click(function () {
    $(".side_panel").toggleClass('folded');
    $(".side_panel .nav").toggleClass('hidden');
    $(".side_panel .tab-content").toggleClass('hidden');

    $(".side-panel-toggle i").toggleClass('fa-chevron-left');
    $(".side-panel-toggle i").toggleClass('fa-chevron-right');



});

// $("#filters_tab_apply").click(function () {
//     console.log('filter clicked')
//     loadDossiers();


//     $("#v_tab_filters_btn").removeClass('active');
//     $("#v_tab_list_btn").addClass('active');

//     $("#dossiers_filters_div").removeClass('active');
//     $("#dossiers_result_div").addClass('active');
// });

$(".show_hide_layer").click(function () {
    $(this).toggleClass("disabled");
    $(this).toggleClass("fa-eye");
    $(this).toggleClass("fa-eye-slash");

    var layerType = $(this).attr('data');
    if (layerType === "Limite urbaine") {
        toggleLimiteUrbaine(); // More efficient - just toggle visibility
    } else {
        loadDossiers(); // Handle other terrain layers as before
    }

});


function toggleLimiteUrbaine() {
    var shouldShow = !$('.show_hide_layer[data="Limite urbaine"]').hasClass('disabled');

    if (shouldShow) {
        // Show the layer if it exists
        if (map.getLayer("zones_pa_line")) {
            map.setLayoutProperty('zones_pa_line', 'visibility', 'visible');
            map.setLayoutProperty('zones_pa_fill', 'visibility', 'visible');
        } else {
            // If layer doesn't exist, reload zones to create it
            loadZonesPA();
        }
    } else {
        // Hide the layer
        if (map.getLayer("zones_pa_line")) {
            map.setLayoutProperty('zones_pa_line', 'visibility', 'none');
            map.setLayoutProperty('zones_pa_fill', 'visibility', 'none');
        }
    }
}

var last_search_id = 0;
$("#search_val").keyup(function () {
    var search_id = Date.now();
    last_search_id = search_id;
    //$("#serach_result_ul").empty();
    if ($("#search_val").val() != "") {


        $.ajax({
            type: "POST",
            dataType: 'json',
            url: "scripts/getTerrains.php?search_value=" + $("#search_val").val() + "&type_filter=%27%27&autorisation_filter=Indifferent&zoning_filter=Indifferent&declaration_filter=Indifferent&liquidation_filter=Indifferent&redevable_filter=Indifferent&form_redevable_filter=Indifferent&start=0&length=5&draw=&output_format=json",
            crossDomain: true,
            success: function (res) {
                var data = res['data'];

                if (last_search_id == search_id) {
                    $("#serach_result_ul").empty();
                    for (var i = 0; i < data.length; i++) {
                        $("#serach_result_ul").append('<li item_id="' + data[i][7] + '" lat="' + data[i][6][1] + '" lng="' + data[i][6][0] + '" style="padding: 4px;"><a  item_id="' + data[i][7] + '" lat="' + data[i][6][1] + '" lng="' + data[i][6][0] + '" alt="' + data[i][0] + '" style="text-decoration: none !important;" class="search_result search_result_link" href="#"> <i style="line-height: 32px; " class="material-icons">location_on</i> Référence Foncière : ' + data[i][0] + "</a></li>");

                    }
                }
                $(".search_result_link").click(function () {

                    var lat = parseFloat($(this).attr('lat'));
                    var lng = parseFloat($(this).attr('lng'));
                    var id = $(this).attr('item_id');

                    if (lng == 0 || lat == 0)
                        return;
                    map.flyTo({
                        center: [lng, lat],
                        essential: true,
                        zoom: 18
                    });
                    handleDossierMarkerClick(id, [lng, lat]);

                });
            }
        });

    } else {
        $("#serach_result_ul").empty();
    }
});

$("#zoom_in").click(function () {
    map.zoomIn();
});

$("#zoom_out").click(function () {
    map.zoomOut();
});

$("#reset_orientation").click(function () {
    map.resetNorth();
});

$("#full_screen").click(function () {
    if (map_fullscreen) {
        map_fullscreen = false;


        if (document.fullscreenElement) {
            document.exitFullscreen();
        } else if (document.mozFullScreenElement) {
            document.mozCancelFullScreen();
        } else if (document.webkitFullscreenElement) {
            document.webkitExitFullscreen();
        } else if (document.msFullscreenElement) {
            document.msExitFullscreen();
        }
        $("#full_screen > i").addClass("fa-up-right-and-down-left-from-center");
        $("#full_screen > i").removeClass("fa-down-left-and-up-right-to-center");
    }
    else {
        map_fullscreen = true;
        map.getContainer().requestFullscreen();


        $("#full_screen > i").removeClass("fa-up-right-and-down-left-from-center");
        $("#full_screen > i").addClass("fa-down-left-and-up-right-to-center");
    }


});



function loadZones() {

    if (!$("#couche_zoning_cb").prop('checked')) {
        return;
    }

    var annee = new Date().getFullYear();
    $.ajax({
        type: "GET",
        dataType: 'json',

        url: assetBaseUrl + `zoning/getZones?annee=${annee}`,
        success: function (res) {

            var zones_features = [];
            res.forEach(element => {
                var geometry = typeof element.geojson === 'string' ? JSON.parse(element.geojson) : element.geojson;

                var feature = {
                    type: "Feature",
                    properties: {
                        id: element.id,
                        fill: element.fill_color,
                        nom: element.nom,
                        tarif: element.tarif
                    },
                    geometry: geometry
                };

                zones_features.push(feature);
            });

            zones_geojson = {
                "type": "FeatureCollection",
                'features': zones_features,
            };

            map.addSource('zones', {
                type: 'geojson',
                data: zones_geojson
            });

            var zones_centroid_features = [];

            zones_features.forEach(feature => {
                // Calculate centroid
                var centroid = turf.centroid(feature);

                // Copy relevant properties
                centroid.properties = {
                    id: feature.properties.id,
                    nom: feature.properties.nom,
                    tarif: feature.properties.tarif,
                    fill: feature.properties.fill
                };

                zones_centroid_features.push(centroid);
            });

            // Build centroid GeoJSON
            var zones_centroid_geojson = {
                type: "FeatureCollection",
                features: zones_centroid_features
            };

            // Add centroid layer to MapLibre (optional)
            map.addSource('zones_centroids', {
                type: 'geojson',
                data: zones_centroid_geojson
            });

            map.addLayer({
                'id': 'zones_fill',
                'type': 'fill',
                'source': 'zones',
                'paint': {
                    'fill-color': ['get', 'fill'],
                    'fill-opacity': 0,
                }
            });

            map.addLayer({
                'id': 'zones_line',
                'type': 'line',
                'source': 'zones',
                'paint': {
                    'line-color': ['get', 'fill'],
                    'line-width': 4,
                }
            });

            map.addLayer({
                "id": "zones_symboles",
                "type": "symbol",
                "source": "zones_centroids",
                "layout": {
                    "symbol-placement": "point",
                    "text-font": ["Metropolis Semi Bold"],
                    "text-field": '{nom}\n{tarif} Dhs',
                    "text-offset": [0, 0],
                    "icon-overlap": "always",
                    "text-allow-overlap": true,
                    "text-size": 13,

                },
                "paint": {
                    "text-color": "#ffff00",
                    "text-halo-color": "black",
                    "text-halo-width": 1,
                    "text-halo-blur": 0
                }
            });


        },
        error: function (xhr, status, error) {

        }
    });
}