var terrains_table = undefined;

$(document).ready(function () {
    terrains_table = $('#terrains_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 15,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        deferRender: true,
        ajax: assetBaseUrl + "geoportail/terrains_datatable?offset=0&limit=30&filters=[]",
        dom: "lBfrtip",
        buttons: [
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },
        columnDefs: [
            { lassName: 'text-left', targets: [0] }
        ],
        columns: [
            {
                data: 'row',
            }
        ],
    });

    terrains_table.on("xhr.dt", function (e, settings, json, xhr) {

        if (json.recordsTotal > 0) {
            $("#dossiers_count").text(json.recordsTotal);

            $("#dossiers_pagelist").empty();

            var pages_count = Math.ceil(json.recordsTotal / 30);

            for (var i = 1; i <= pages_count; i++) {
                $("#dossiers_pagelist").append(new Option(`Page ${i} / ${pages_count}`, i));
            }
        }


    })

    $("#dossiers_pagelist").change(function () {
        var page_i = $(this).val();
        var start = (page_i - 1) * 30;
        filter_dossiers_table(start, false);
    });

   
});