$("#profile_pic_input").change(function () {
    const file = $("#profile_pic_input").prop('files')[0];
    if (file) {

        let reader = new FileReader();
        reader.onload = function (event) {

            $('#profile_pic_photo').attr('src', event.target.result);
        }
        reader.readAsDataURL(file);

    }
});

$("#edit_user_form").submit(function (event) {

    event.preventDefault();
    $("#store_user_submit_btn").attr('disabled', 'disabled');
    var formData = new FormData(this);
    $.ajax({
        url: "/profile/update",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {

            location.reload();

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

$("#edit_pwd_form").submit(function (event) {

    event.preventDefault();
    $("#edit_pwd_btn").attr('disabled', 'disabled');
    var formData = new FormData(this);
    $.ajax({
        url: "/profile/updatePassword",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {

            if (response.success == 1) {
                $.toast({
                    heading: "HMR",
                    text: 'Le changement de mot de passe a été effectué avec succès.',
                    icon: "success",
                    position: "bottom-right",
                    hideAfter: 3000,
                    stack: false,
                });
            }
            else {
                if (response.error == "PASSWORDS_MISS_MATCHED") {
                    gl_alert('error', 'HMR', "Les mots de passe ne correspondent pas");
                }
                if (response.error == "SHORT_PASSWORD") {
                    gl_alert('error', 'HMR', "Le mot de passe doit contenir un minimum de 8 caractères.");
                }
                if (response.error == "PASSWORD_NO_UPPERCASE") {
                    gl_alert('error', 'HMR', "Le mot de passe doit comporter au moins une lettre majuscule.");
                }
            
                if (response.error == "PASSWORD_NO_LOWERCASE") {
                    gl_alert('error', 'HMR', "Le mot de passe doit comporter au moins une lettre minuscule.");
                }
                if (response.error == "PASSWORD_NO_SYMBOLE") {
                    gl_alert('error', 'HMR', "Le mot de passe doit comporter au moins un caractère spécial.");
                }
                if (response.error == "PASSWORD_NO_NUMBER") {
                    gl_alert('error', 'HMR', "Le mot de passe doit comporter au moins un chiffre.");
                }
               
                 

            }
            $("#edit_pwd_btn").removeAttr('disabled');

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});