var suivi_table = undefined;

$(document).ready(function () {

    // showLoading("HMR","Veuillez patienter pendant la préparation des données...");

    // $.ajax({
    //     url: assetBaseUrl + "suivi/refresh_users_suivi",
    //     type: "GET",
    //     success: function (response) {
    //         closeLoading();
            
    //     },
    //     error: function (xhr, status, error) {
    //         console.log(xhr.responseText);
    //     },
    // });
    


    suivi_table = $('#suivi_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: true,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'suivi/suivi_datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '<button class="btn"><i class="fa fa-file-excel-o" ></i>  Exporter Excel</button>',
                "titleAttr": 'excel',
                'title':'',
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3, 4, 5, 6, 7] }
        ],
        columns: [
            {
                data: 'type',
            },
            {
                data: 'prestataire',
            },
            {
                data: 'demandes_seasie',
            },
            {
                data: 'demandes_affectes',
            },
            
            {
                data: 'autorisations',
            },
            {
                data: 'autorisations_journalier',
            },
            {
                data: 'ouvertures_chantier',
            },
            {
                data: 'taux_depot',
            },
            {
                data: 'depot_journalier',
            },
            {
                data: 'contacte',
            }
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }


    });

    suivi_table.on('draw', function () {
        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });
    });   
   

    $('#filter_date').daterangepicker({
        startDate: (new Date(new Date().getFullYear(), 0, 1)).toLocaleDateString('fr-FR'),
        endDate: '31/12/2023',
        applyButtonClasses: 'btn-success',
        cancelButtonClasses: 'btn-danger',
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Accepter",
            cancelLabel: "Annuler",
        }
    });


});

$("#provinces_filter").change(function () {
    refresh_situation_filters('province');
});
$("#cercles_filter").change(function () {
    refresh_situation_filters('cercle');
});
$("#communes_filter").change(function () {
    refresh_situation_filters('commune');
});
$("#douars_filter").change(function () {
    refresh_situation_filters('douar');
});


 
function fill_situation_filter_cercle(province_id) {
    $("#cercles_filter").empty();
    $("#cercles_filter").append(new Option('Indifferent', 'all'));
    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                $("#cercles_filter").append(new Option(cercle.nom, cercle.id));
            }
        }
        else {
            $("#cercles_filter").append(new Option(cercle.nom, cercle.id));
        }
    });
}

function fill_situation_filter_commune(province_id, cercle_id) {
    $("#communes_filter").empty();
    $("#communes_filter").append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });

    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        $("#communes_filter").append(new Option(commune.nom, commune.id));
                    }
                }
                else {
                    $("#communes_filter").append(new Option(commune.nom, commune.id));
                }
            }
        });
    });

}


function fill_situation_filter_douar(province_id, cercle_id, commune_id) {
    $("#douars_filter").empty();
    $("#douars_filter").append(new Option('Indifferent', 'all'));
    var filtred_cercles = [];

    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                filtred_cercles.push(cercle);
            }
        }
        else {
            filtred_cercles.push(cercle);
        }
    });

    var filtred_communes = [];
    filtred_cercles.forEach(cercle => {
        communes.forEach(commune => {
            if (commune.cercle_id == cercle.id) {
                if (cercle_id != 'all') {
                    if (commune.cercle_id == cercle_id) {
                        filtred_communes.push(commune);
                    }
                }
                else {
                    filtred_communes.push(commune);
                }
            }
        });
    });

    filtred_communes.forEach(commune => {
        douars.forEach(douar => {
            if (douar.commune_id == commune.id) {
                if (commune_id != 'all') {
                    if (commune.id == commune_id) {
                        $("#douars_filter").append(new Option(douar.nom, douar.id));
                    }
                }
                else {
                    $("#douars_filter").append(new Option(douar.nom, douar.id));
                }
            }
        });
    });

}
function refresh_situation_filters(trigger_source) {
    if (trigger_source == 'province') {
        fill_situation_filter_cercle($("#provinces_filter").val(), 'all');
        fill_situation_filter_commune($("#provinces_filter").val(), 'all');
        fill_situation_filter_douar($("#provinces_filter").val(), 'all', 'all');
    }
    if (trigger_source == 'cercle') {
        var province_id = undefined;

        if ($("#cercles_filter").val() == 'all') {
            refresh_situation_filters('province');
            return;
        }

        cercles.forEach(cercle => {
            if (cercle.id == $("#cercles_filter").val()) {
                province_id = cercle.province_id;
            }
        });

        $("#provinces_filter").val(province_id);
        $('#provinces_filter').trigger('change.select2');

        fill_situation_filter_commune(province_id, $("#cercles_filter").val());
        fill_situation_filter_douar(province_id, $("#cercles_filter").val(), 'all');
    }

    if (trigger_source == 'commune') {
        var province_id = undefined;
        var cercle_id = undefined;

        if ($("#communes_filter").val() == 'all') {
            refresh_situation_filters('cercle');
            return;
        }

        communes.forEach(commune => {
            if (commune.id == $("#communes_filter").val()) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#provinces_filter").val(province_id);
        $('#provinces_filter').trigger('change.select2');

        $("#cercles_filter").val(cercle_id);
        $('#cercles_filter').trigger('change.select2');

        fill_situation_filter_douar(province_id, $("#cercles_filter").val(), $("#communes_filter").val(), 'all');
    }

    if (trigger_source == 'douar') {
        var province_id = undefined;
        var cercle_id = undefined;
        var commune_id = undefined;

        if ($("#douars_filter").val() == 'all') {
            refresh_situation_filters('commune');
            return;
        }

        douars.forEach(douar => {
            if (douar.id == $("#douars_filter").val()) {
                commune_id = douar.commune_id;
            }
        });

        communes.forEach(commune => {
            if (commune.id == commune_id) {
                cercle_id = commune.cercle_id;
            }
        });

        cercles.forEach(cercle => {
            if (cercle.id == cercle_id) {
                province_id = cercle.province_id;
            }
        });

        $("#provinces_filter").val(province_id);
        $('#provinces_filter').trigger('change.select2');

        $("#cercles_filter").val(cercle_id);
        $('#cercles_filter').trigger('change.select2');

        $("#communes_filter").val(commune_id);
        $('#communes_filter').trigger('change.select2');


    }
}


function filter_tab_douar_index_table() {
    var filters = [];


    $(".dt_filter").each(function () {
        var column = $(this).attr('column');
        var table = $(this).attr('table');
        var value = $(this).val();
        var params = $(this).attr('params');
        if (value != 'all' && value.trim().length > 0) {
            filters.push({ column: column, table: table, value: value, params: params });
        }
    });



    suivi_table.ajax.url(assetBaseUrl + 'suivi/suivi_datatable' + '?filters=' + JSON.stringify(filters)).load();
}

$(".dt_filter").change(function () {
    filter_tab_douar_index_table();
});

$(".dt_filter").keyup(function () {
    filter_tab_douar_index_table();
});

$(".custom_filter").change(function () {
    filter_tab_douar_index_table();
});

$("body").on('click', '.contacte_a', function () {
    var prestataire_id = $(this).attr('item_id');
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous certain(e) de vouloir changer la valeur ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {
            $("#create_dossier .spinner-border").css('display', 'inline-block');

            $.ajax({
                url: assetBaseUrl + "suivi/contacte/" + prestataire_id,
                type: "GET",
                success: function (response) {
                    suivi_table.ajax.reload( null, false );                 
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });
        }
    });
});